package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptGdSbxxDTO;
import com.zksy.szpt.domain.po.SzptGdSbxx;
import com.zksy.szpt.mapper.SzptGdSbxxMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import com.zksy.szpt.util.UserContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptGdSbxxService {
    @Resource
    private SzptGdSbxxMapper szptGdSbxxMapper;

    public Integer addSzptGdSbxx(SzptGdSbxxDTO szptGdSbxxDTO) {
        SzptGdSbxx szptGdSbxx = BeanMapperUtil.map(szptGdSbxxDTO, SzptGdSbxx.class);
        return szptGdSbxxMapper.insert(szptGdSbxx);
    }

    public Integer updateSzptGdSbxx(SzptGdSbxxDTO szptGdSbxxDTO) {
        SzptGdSbxx szptGdSbxx = BeanMapperUtil.map(szptGdSbxxDTO, SzptGdSbxx.class);
        LambdaUpdateWrapper<SzptGdSbxx> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptGdSbxx::getSbbh, szptGdSbxx.getSbbh());
        wrapper.eq(SzptGdSbxx::getSjgsdwdm, szptGdSbxx.getSjgsdwdm());
        return szptGdSbxxMapper.update(szptGdSbxx,wrapper);
    }

    public Integer deleteSzptGdSbxx(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptGdSbxx> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptGdSbxx::getSbbh, commonDelDTO.getIds());
        wrapper.eq(SzptGdSbxx::getSjgsdwdm, UserContextHolder.get().getDeptCode());
//        wrapper.eq(SzptGdSbxx::getSjgsdwdm, commonDelDTO.getSjgsdwdm());
        return szptGdSbxxMapper.delete(wrapper);

    }
}
