package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptQyxxDTO;
import com.zksy.szpt.service.SzptQyxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "区域信息")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptQyxxController {
    private final SzptQyxxService szptQyxxService;

    public SzptQyxxController(SzptQyxxService szptQyxxService) {
        this.szptQyxxService = szptQyxxService;
    }

    @ApiOperation(value="新增区域信息表")
    @PostMapping("/addSzptQyxx")
    public Integer addSzptQyxx(@RequestBody @Validated SzptQyxxDTO szptQyxxDTO){
        return szptQyxxService.addSzptQyxx(szptQyxxDTO);
    }

    @ApiOperation(value="编辑工地预警流水表")
    @PostMapping("/updateSzptQyxx")
    public Integer updateSzptQyxx(@RequestBody @Validated SzptQyxxDTO szptQyxxDTO){
        return szptQyxxService.updateSzptQyxx(szptQyxxDTO);
    }

    @ApiOperation(value = "删除工地预警流水表")
    @PostMapping("/deleteSzptQyxx")
    public Integer deleteSzptQyxx(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptQyxxService.deleteSzptQyxx(commonDelDTO);
    }
}
