package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.CommonDelIntDTO;
import com.zksy.szpt.domain.dto.SzptClockInRulesDTO;
import com.zksy.szpt.domain.po.SzptClockInRules;
import com.zksy.szpt.mapper.SzptClockInRulesMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptClockInRulesService {
    @Resource
    private SzptClockInRulesMapper szptClockInRulesMapper;

    public Integer addSzptClockInRules(SzptClockInRulesDTO szptClockInRulesDTO) {
        SzptClockInRules szptClockInRules = BeanMapperUtil.map(szptClockInRulesDTO, SzptClockInRules.class);
        return szptClockInRulesMapper.insert(szptClockInRules);
    }

    public Integer updateSzptClockInRules(SzptClockInRulesDTO szptClockInRulesDTO) {
        SzptClockInRules szptClockInRules = BeanMapperUtil.map(szptClockInRulesDTO, SzptClockInRules.class);
        LambdaUpdateWrapper<SzptClockInRules> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptClockInRules::getId, szptClockInRules.getId());
        return szptClockInRulesMapper.update(szptClockInRules,wrapper);
    }

    public Integer deleteSzptClockInRules(CommonDelIntDTO commonDelIntDTO) {
        LambdaQueryWrapper<SzptClockInRules> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptClockInRules::getId, commonDelIntDTO.getIds());
        return szptClockInRulesMapper.delete(wrapper);
    }
}
