package com.zksy.szpt.domain.dto;


import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;

public class SzptQyxxDTO {

    /**
     * 区域ID
     */
    @ApiModelProperty(value = "区域ID")
    @NotBlank(message = "区域ID不能为空")
    private String id;
    /**
     * 场所ID
     */
    @ApiModelProperty(value = "场所ID")
    @NotBlank(message = "场所ID不能为空")
    private String csid;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称")
    @NotBlank(message = "区域名称不能为空")
    private String qymc;

    /**
     * 区域简称
     */
    @ApiModelProperty(value = "区域简称")
    @NotBlank(message = "场所ID区域简称不能为空")
    private String qyjc;

    /**
     * 区域全称
     */
    @ApiModelProperty(value = "区域全称")
    private String qyqc;

    /**
     * 区域类型[3123]：(11-苑，12-楼幢，13-单元，14-房屋，15-房间)
     */
    @ApiModelProperty(value = "区域类型[3123]：(11-苑，12-楼幢，13-单元，14-房屋，15-房间)")
    @NotBlank(message = "区域类型不能为空")
    private String qylx;

    /**
     * 层级
     */
    @ApiModelProperty(value = "层级")
    @NotBlank(message = "层级不能为空")
    private String level;

    /**
     * 上级区域id
     */
    @ApiModelProperty(value = "上级区域id")
    private String fqyid;

    /**
     * 显示顺序
     */
    @ApiModelProperty(value = "显示顺序")
    private String xssx;

    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private String lng;

    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private String lat;

    /**
     * 自定义经度
     */
    @ApiModelProperty(value = "自定义经度")
    private String customlng;

    /**
     * 自定义纬度
     */
    @ApiModelProperty(value = "自定义纬度")
    private String customlat;

    /**
     * 状态[3101](1-有效，2-注销)
     */
    @ApiModelProperty(value = "状态[3101](1-有效，2-注销)")
    @NotBlank(message = "状态不能为空")
    private String zt;

//    /**
//     * 数据归属单位代码
//     */
//    @NotBlank(message = "数据归属单位代码不能为空")
//    private String sjgsdwdm;
//
//    /**
//     * 数据归属单位名称
//     */
//    private String sjgsdwmc;

    /**
     * 登记公安机关机构代码
     */
    @ApiModelProperty(value = "登记公安机关机构代码")
    @NotBlank(message = "登记公安机关机构代码不能为空")
    private String createGajgjgdm;

    /**
     * 登记公安机关名称
     */
    @ApiModelProperty(value = "登记公安机关名称")
    @NotBlank(message = "登记公安机关名称不能为空")
    private String createGajgmc;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCsid() {
        return csid;
    }

    public void setCsid(String csid) {
        this.csid = csid == null ? null : csid.trim();
    }

    public String getQymc() {
        return qymc;
    }

    public void setQymc(String qymc) {
        this.qymc = qymc == null ? null : qymc.trim();
    }

    public String getQyjc() {
        return qyjc;
    }

    public void setQyjc(String qyjc) {
        this.qyjc = qyjc == null ? null : qyjc.trim();
    }

    public String getQyqc() {
        return qyqc;
    }

    public void setQyqc(String qyqc) {
        this.qyqc = qyqc == null ? null : qyqc.trim();
    }

    public String getQylx() {
        return qylx;
    }

    public void setQylx(String qylx) {
        this.qylx = qylx == null ? null : qylx.trim();
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level == null ? null : level.trim();
    }

    public String getFqyid() {
        return fqyid;
    }

    public void setFqyid(String fqyid) {
        this.fqyid = fqyid == null ? null : fqyid.trim();
    }

    public String getXssx() {
        return xssx;
    }

    public void setXssx(String xssx) {
        this.xssx = xssx == null ? null : xssx.trim();
    }

    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng == null ? null : lng.trim();
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat == null ? null : lat.trim();
    }

    public String getCustomlng() {
        return customlng;
    }

    public void setCustomlng(String customlng) {
        this.customlng = customlng == null ? null : customlng.trim();
    }

    public String getCustomlat() {
        return customlat;
    }

    public void setCustomlat(String customlat) {
        this.customlat = customlat == null ? null : customlat.trim();
    }

    public String getZt() {
        return zt;
    }

    public void setZt(String zt) {
        this.zt = zt == null ? null : zt.trim();
    }

//    public String getSjgsdwdm() {
//        return sjgsdwdm;
//    }
//
//    public void setSjgsdwdm(String sjgsdwdm) {
//        this.sjgsdwdm = sjgsdwdm == null ? null : sjgsdwdm.trim();
//    }
//
//    public String getSjgsdwmc() {
//        return sjgsdwmc;
//    }
//
//    public void setSjgsdwmc(String sjgsdwmc) {
//        this.sjgsdwmc = sjgsdwmc == null ? null : sjgsdwmc.trim();
//    }

    public String getCreateGajgjgdm() {
        return createGajgjgdm;
    }

    public void setCreateGajgjgdm(String createGajgjgdm) {
        this.createGajgjgdm = createGajgjgdm == null ? null : createGajgjgdm.trim();
    }

    public String getCreateGajgmc() {
        return createGajgmc;
    }

    public void setCreateGajgmc(String createGajgmc) {
        this.createGajgmc = createGajgmc == null ? null : createGajgmc.trim();
    }
}
