package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelParamDTO;
import com.zksy.szpt.domain.dto.XxYjdwdmDTO;
import com.zksy.szpt.service.XxYjdwdmService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "义警队伍代码服务")
@RequestMapping("/rest/xxYjdwdm")
@RestController
@Validated
public class XxYjdwdmController {
    private final XxYjdwdmService service;

    public XxYjdwdmController(XxYjdwdmService service) {
        this.service = service;
    }

    @ApiOperation(value = "新增义警队伍代码数据")
    @PostMapping("/add")
    public Integer addXxYjdwdm(@RequestBody @Validated XxYjdwdmDTO dto) {
        return service.addXxYjdwdm(dto);
    }

    @ApiOperation(value = "修改义警队伍数据")
    @PostMapping("/update")
    public Integer update(@RequestBody @Validated XxYjdwdmDTO dto) {
        return service.update(dto);
    }

    @ApiOperation(value = "根据义警队伍代码ID删除义警队伍数据")
    @PostMapping("/delete")
    public Integer delete(@RequestBody  @Validated CommonDelParamDTO dto) {
        return service.delete(dto);
    }

}
