package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptClockInRulesDTO;
import com.zksy.szpt.service.SzptClockInRulesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptClockInRulesController {
    private final SzptClockInRulesService szptClockInRulesService;

    public SzptClockInRulesController(SzptClockInRulesService szptClockInRulesService) {
        this.szptClockInRulesService = szptClockInRulesService;
    }

    @ApiOperation(value="新增szpt_clock_in_rules数据")
    @PostMapping("/addSzptClockInRules")
    public Integer addSzptClockInRules(@RequestBody @Validated SzptClockInRulesDTO szptClockInRulesDTO){
        return szptClockInRulesService.addSzptClockInRules(szptClockInRulesDTO);
    }

    @ApiOperation(value="编辑szpt_clock_in_rules数据")
    @PostMapping("/updateSzptClockInRules")
    public Integer updateSzptClockInRules(@RequestBody @Validated SzptClockInRulesDTO szptClockInRulesDTO){
        return szptClockInRulesService.updateSzptClockInRules(szptClockInRulesDTO);
    }

    @ApiOperation(value = "删除SzptClockInRules数据")
    @PostMapping("/deleteSzptClockInRules")
    public Integer deleteSzptClockInRules(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptClockInRulesService.deleteSzptClockInRules(commonDelDTO);
    }
}
