package com.zksy.szpt.aspect;



import com.zksy.szpt.domain.HttpResult;
import com.zksy.szpt.domain.HttpResultState;
import com.zksy.szpt.service.AppStoreService;
import com.zksy.szpt.util.EncryptUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;

//@Aspect//声明切面，标记类(1时间，2地点，3内容)
//@Component
public class AuthAspect {
    private static final Logger logger = LoggerFactory.getLogger(AuthAspect.class);

    @Resource
    AppStoreService appStoreService;

    //
    @Pointcut("execution( * com.zksy.szpt.controller.*.*(..))")
    private void auth() {

    }

    @Around(value = "auth()")
    public Object auth(ProceedingJoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Object[] paramValues = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature) joinPoint.getSignature()).getParameterNames();

//      按请求参数名及参数值相互连接组成一个字符串
        Map<String, String> param = new HashMap<>();
        for (int i = 0; i < paramNames.length; i++) {
            if (paramValues[i] instanceof Map) {//接口参数
                Map<String, Object> bodyPara = (Map<String, Object>) paramValues[i];
                Iterator<Map.Entry<String, Object>> iterator = bodyPara.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry = iterator.next();
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    param.put(key, value == null ? "" : value.toString());
                }
            } else {//系统级参数
                param.put(paramNames[i], paramValues[i].toString());
            }
        }
        String appSecret = appStoreService.getAppSecretByAppKey(param.get("appKey"));
        //appKey不存在
        if (appSecret == null) {
            HttpResultState httpResultState = HttpResultState.NOTIFICATION;
            logger.info("appKey:{}不存在", param.get("appKey"));
            httpResultState.setMessage("不存在的appKey");
            return new HttpResult<String>(httpResultState);
        }
        //客户端传递过来的签名
        String clientSign = param.get("sign");
        param.remove("sign");
        //根据客户端的参数生成的签名
        String serverSign = EncryptUtil.getInstance().shaEncode(appSecret + sortJoin(param) + appSecret);
        //传递的签名通过
        if (serverSign.equals(clientSign)) {
            return joinPoint.proceed();
        } else {//传递的签名没有通过
            logger.info("appKey:{}没有通过验证", param.get("appKey"));
            return new HttpResult<String>(HttpResultState.INVALID_SIGNATURE);
        }
    }

    private String sortJoin(Map<String, String> map) {
        // 移除值为空的
        map.entrySet().removeIf(entry -> Objects.isNull(entry.getValue()) || "".equals(entry.getValue()));
        List<Map.Entry<String, String>> infoIds = new ArrayList<>(map.entrySet());
        // 对所有传入参数按照字段名的 ASCII 码从小到大排序（字典序）
        infoIds.sort((o1, o2) -> o1.getKey().compareToIgnoreCase(o2.getKey()));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> infoId : infoIds) {
            sb.append(infoId.getKey());
//            sb.append("=");
            sb.append(infoId.getValue());
//            sb.append("&");
        }
        return sb.substring(0, sb.length());
    }
}
