package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptXyzhKqmbDTO;
import com.zksy.szpt.service.SzptXyzhKqmbService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "考勤模板")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptXyzhKqmbController {
    private final SzptXyzhKqmbService szptXyzhKqmbService;
    public SzptXyzhKqmbController(SzptXyzhKqmbService szptXyzhKqmbService) {
        this.szptXyzhKqmbService = szptXyzhKqmbService;
    }

    @ApiOperation(value="新增考勤模板")
    @PostMapping("/addSzptXyzhKqmb")
    public Integer addSzptXyzhKqmb(@RequestBody @Validated SzptXyzhKqmbDTO szptXyzhKqmbDTO){
        return szptXyzhKqmbService.addSzptXyzhKqmb(szptXyzhKqmbDTO);
    }

    @ApiOperation(value="编辑考勤模板")
    @PostMapping("/updateSzptXyzhKqmb")
    public Integer updateSzptXyzhKqmb(@RequestBody @Validated SzptXyzhKqmbDTO szptXyzhKqmbDTO){
        return szptXyzhKqmbService.updateSzptXyzhKqmb(szptXyzhKqmbDTO);
    }

    @ApiOperation(value = "删除考勤模板")
    @PostMapping("/deleteSzptXyzhKqmb")
    public Integer deleteSzptXyzhKqmb(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptXyzhKqmbService.deleteSzptXyzhKqmb(commonDelDTO);
    }
}
