package com.zksy.szpt;

import cn.hutool.crypto.digest.DigestUtil;
import com.zksy.szpt.domain.dto.*;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest()
public class TestAppStore {
    /**
     * 新增AppId
     */
    @Test
    @DisplayName("新增AppId")
    public void addAppId() {
        AppStoreDTO appStoreDTO = new AppStoreDTO();
        appStoreDTO.setAppKey("us2");
        appStoreDTO.setAppSecret(DigestUtil.md5Hex("us"));
        appStoreDTO.setDeptCode("123456");

        TestHttpUtil.signatureAndRequest("/rest/appStore/updateAppIdSecret", appStoreDTO, AppStoreDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/appStore/insertAppStore", appStoreDTO, AppStoreDTO.class);
//        TestHttpUtil.signatureAndRequest("/rest/appStore/insertAppStore", appStoreDTO);
    }

    @Test
    @DisplayName("更新AppId的密钥")
    public void updateAppIdSecret() {
        AppStoreDTO appStoreDTO = new AppStoreDTO();
        appStoreDTO.setAppKey("us2");
        appStoreDTO.setAppSecret(DigestUtil.md5Hex("asdfasdfadf11"));
        TestHttpUtil.signatureAndRequest("/rest/appStore/updateAppIdSecret", appStoreDTO, AppStoreDTO.class);
    }
}
