package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptFwxxDTO;
import com.zksy.szpt.domain.po.SzptFwxx;
import com.zksy.szpt.mapper.SzptFwxxMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptFwxxService {

    @Resource
    private SzptFwxxMapper szptFwxxMapper;

    public Integer addSzptFwxx(SzptFwxxDTO szptFwxxDTO) {
        SzptFwxx szptFwxx = BeanMapperUtil.map(szptFwxxDTO, SzptFwxx.class);
        return szptFwxxMapper.insert(szptFwxx);
    }

    public Integer updateSzptFwxx(SzptFwxxDTO szptFwxxDTO) {
        SzptFwxx szptFwxx = BeanMapperUtil.map(szptFwxxDTO, SzptFwxx.class);
        LambdaUpdateWrapper<SzptFwxx> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptFwxx::getQyid, szptFwxx.getQyid());
        wrapper.eq(SzptFwxx::getSjgsdwdm, szptFwxx.getSjgsdwdm());
        return szptFwxxMapper.update(szptFwxx,wrapper);
    }

    public Integer deleteSzptFwxx(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptFwxx> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptFwxx::getQyid, commonDelDTO.getIds());
        wrapper.eq(SzptFwxx::getSjgsdwdm, commonDelDTO.getSjgsdwdm());
        return szptFwxxMapper.delete(wrapper);
    }
}
