package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptQyxxDTO;
import com.zksy.szpt.domain.po.SzptQyxx;
import com.zksy.szpt.mapper.SzptQyxxMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptQyxxService {
    @Resource
    private SzptQyxxMapper szptQyxxMapper;
    public Integer addSzptQyxx(SzptQyxxDTO szptQyxxDTO){
        SzptQyxx szptQyxx = BeanMapperUtil.map(szptQyxxDTO,SzptQyxx.class);
        return szptQyxxMapper.insert(szptQyxx);
    }

    public Integer updateSzptQyxx(SzptQyxxDTO szptQyxxDTO) {
        SzptQyxx szptQyxx = BeanMapperUtil.map(szptQyxxDTO, SzptQyxx.class);
        LambdaUpdateWrapper<SzptQyxx> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptQyxx::getId, szptQyxx.getId());
        wrapper.eq(SzptQyxx::getSjgsdwdm, szptQyxx.getSjgsdwdm());
        return szptQyxxMapper.update(szptQyxx,wrapper);
    }

    public Integer deleteSzptQyxx(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptQyxx> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptQyxx::getId, commonDelDTO.getIds());
        return szptQyxxMapper.delete(wrapper);
    }
}
