package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptXyzhKqmbDTO;
import com.zksy.szpt.domain.dto.SzptXyzhMbdhDTO;
import com.zksy.szpt.domain.po.SzptXyzhKqmb;
import com.zksy.szpt.domain.po.SzptXyzhMbdh;
import com.zksy.szpt.mapper.SzptXyzhMbdhMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptXyzhMbdhService {
    @Resource
    private SzptXyzhMbdhMapper szptXyzhMbdhMapper;

    public Integer addSzptXyzhMbdh(SzptXyzhMbdhDTO szptXyzhMbdhDTO) {
        SzptXyzhMbdh szptXyzhMbdh = BeanMapperUtil.map(szptXyzhMbdhDTO, SzptXyzhMbdh.class);
        return szptXyzhMbdhMapper.insert(szptXyzhMbdh);
    }

    public Integer updateSzptXyzhMbdh(SzptXyzhMbdhDTO szptXyzhMbdhDTO) {
        SzptXyzhMbdh szptXyzhMbdh = BeanMapperUtil.map(szptXyzhMbdhDTO, SzptXyzhMbdh.class);
        LambdaUpdateWrapper<SzptXyzhMbdh> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptXyzhMbdh::getId, szptXyzhMbdh.getId());
        return szptXyzhMbdhMapper.update(szptXyzhMbdh,wrapper);
    }

    public Integer deleteSzptXyzhMbdh(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptXyzhMbdh> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptXyzhMbdh::getId, commonDelDTO);
        return szptXyzhMbdhMapper.delete(wrapper);
    }
}
