package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.domain.po.*;
import com.zksy.szpt.mapper.*;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class IndexService {

    @Resource
    private XxRwwcqkMapper xxRwwcqkMapper;

    public Integer addXxRwwcqk(XxRwwcqkDTO xxRwwcqkDTO) {
        XxRwwcqk xxRwwcqk = BeanMapperUtil.map(xxRwwcqkDTO, XxRwwcqk.class);
        return xxRwwcqkMapper.insert(xxRwwcqk);
    }

    public Integer updateXxRwwcqk(XxRwwcqkDTO xxRwwcqkDTO) {
        XxRwwcqk xxRwwcqk = BeanMapperUtil.map(xxRwwcqkDTO, XxRwwcqk.class);
        LambdaUpdateWrapper<XxRwwcqk> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(XxRwwcqk::getRwid, xxRwwcqk.getRwid());
        return xxRwwcqkMapper.update(xxRwwcqk,wrapper);
    }

    public Integer deleteXxRwwcqk(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<XxRwwcqk> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(XxRwwcqk::getRwid, commonDelDTO);
        return xxRwwcqkMapper.delete(wrapper);
    }
}
