package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.service.IndexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class IndexController {
    private final IndexService indexService;

    public IndexController(IndexService indexService) {
        this.indexService = indexService;
    }

    @ApiOperation(value = "新增xx_rwwcqk数据")
    @PostMapping("/addXxRwwcqk")
    public Integer addXxRwwcqk(@RequestBody @Valid XxRwwcqkDTO xxRwwcqkDTO) {
        return indexService.addXxRwwcqk(xxRwwcqkDTO);
    }

    @ApiOperation(value="编辑xx_rwwcqk数据")
    @PostMapping("/updateXxRwwcqk")
    public Integer updateXxRwwcqk(@RequestBody @Validated XxRwwcqkDTO xxRwwcqkDTO){
        return indexService.updateXxRwwcqk(xxRwwcqkDTO);
    }

    @ApiOperation(value = "删除xx_rwwcqk数据")
    @PostMapping("/deleteXxRwwcqk")
    public Integer deleteXxRwwcqk(@RequestBody CommonDelDTO commonDelDTO) {
        return indexService.deleteXxRwwcqk(commonDelDTO);
    }
}
