package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptXyzhDkxxDTO;
import com.zksy.szpt.service.SzptXyzhDkxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "打卡信息")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptXyzhDkxxController {
    private final SzptXyzhDkxxService szptXyzhDkxxService;
    public SzptXyzhDkxxController(SzptXyzhDkxxService szptXyzhDkxxService) {
        this.szptXyzhDkxxService = szptXyzhDkxxService;
    }

    @ApiOperation(value="新增打卡信息")
    @PostMapping("/addSzptXyzhDkxx")
    public Integer addSzptXyzhDkxx(@RequestBody @Validated SzptXyzhDkxxDTO szptXyzhDkxxDTO){
        return szptXyzhDkxxService.addSzptXyzhDkxx(szptXyzhDkxxDTO);
    }

    @ApiOperation(value="编辑打卡信息")
    @PostMapping("/updateSzptXyzhDkxx")
    public Integer updateSzptXyzhDkxx(@RequestBody @Validated SzptXyzhDkxxDTO szptXyzhDkxxDTO){
        return szptXyzhDkxxService.updateSzptXyzhDkxx(szptXyzhDkxxDTO);
    }

    @ApiOperation(value = "删除打卡信息")
    @PostMapping("/deleteSzptXyzhDkxx")
    public Integer deleteSzptXyzhDkxx(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptXyzhDkxxService.deleteSzptXyzhDkxx(commonDelDTO);
    }
}
