package com.zksy.szpt.config;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;

import java.util.List;

/**
 * MyBatis Generator 插件：自动为实体类添加 Swagger 注解
 * 类上属性需要mysql的url需要加useInformationSchema=true
 */
public class SwaggerAnnotationPlugin extends PluginAdapter {

    @Override
    public boolean validate(List<String> warnings) {
        return true; // 永远返回 true，表示插件可用
    }

    /**
     * 处理 Model 类，为其添加 Swagger 注解
     */
    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        // 添加 @ApiModel 注解
        topLevelClass.addImportedType("io.swagger.annotations.ApiModel");
        topLevelClass.addAnnotation("@ApiModel(\"" + introspectedTable.getRemarks() + "\")");

        return true;
    }

    /**
     * 处理 Model 字段，为其添加 @ApiModelProperty 注解
     */
    @Override
    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass,
                                       IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable,
                                       ModelClassType modelClassType) {
        // 添加 @ApiModelProperty 注解
        topLevelClass.addImportedType("io.swagger.annotations.ApiModelProperty");
        String columnComment = introspectedColumn.getRemarks(); // 获取数据库中的字段注释
        field.addAnnotation("@ApiModelProperty(value = \"" + columnComment + "\")");

        return true;
    }
}

