package com.zksy.szpt;

import com.zksy.szpt.domain.dto.*;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@SpringBootTest()
public class MainTestX {

    /**
     * ===================================================考勤===================================================
     */
    @Test
    @DisplayName("考勤--新增")
    public void szptClockInAddTest() {
        //请求参数
        SzptClockInDTO szptClockInDTO = new SzptClockInDTO();
        szptClockInDTO.setId(3);
        szptClockInDTO.setCsid("123456111111111111111");
        szptClockInDTO.setSbqd("123456");
        szptClockInDTO.setXbqt("123456");
        szptClockInDTO.setXcqk("1");
        szptClockInDTO.setSbsj("1");
        szptClockInDTO.setSbr("123456");
        szptClockInDTO.setQdr("123456");
        szptClockInDTO.setQdrlxdh("123456");
        szptClockInDTO.setQddkdd("1");
        szptClockInDTO.setQddkzp("1");
        szptClockInDTO.setQtdkdd("1");
        szptClockInDTO.setQtdkzp("1");
        szptClockInDTO.setGkdj("1");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptClockIn", szptClockInDTO, SzptClockInDTO.class);
    }

    @Test
    @DisplayName("考勤--更新")
    public void szptClockInUpdateTest() {
        //请求参数
        SzptClockInDTO szptClockInDTO = new SzptClockInDTO();
        szptClockInDTO.setId(1);
        szptClockInDTO.setCsid("111111");
        szptClockInDTO.setSbqd("1");
        szptClockInDTO.setXbqt("1");
        szptClockInDTO.setXcqk("1");
        szptClockInDTO.setSbsj("1");
        szptClockInDTO.setSbr("123456");
        szptClockInDTO.setQdr("123456");
        szptClockInDTO.setQdrlxdh("123456");
        szptClockInDTO.setQddkdd("1");
        szptClockInDTO.setQddkzp("1");
        szptClockInDTO.setQtdkdd("1");
        szptClockInDTO.setQtdkzp("1");
        szptClockInDTO.setGkdj("1");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptClockIn", szptClockInDTO, SzptClockInDTO.class);
    }

    @Test
    @DisplayName("考勤--删除")
    public void szptClockInDeleteTest() {
        //请求参数
        List<Integer> ids = new ArrayList<>();
        ids.add(16);
        ids.add(17);
        ids.add(18);
        ids.add(19);
        ids.add(20);
        ids.add(21);
        ids.add(22);
        ids.add(25);
        ids.add(100);
        CommonDelIntDTO commonDelIntDTO = new CommonDelIntDTO();
        commonDelIntDTO.setIds(ids);
        commonDelIntDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptClockIn", commonDelIntDTO, CommonDelIntDTO.class);
    }

    /**
     * ===================================================考勤规则===================================================
     */
    @Test
    @DisplayName("考勤规则--新增")
    public void szptClockInRulesAddTest() {
        //请求参数
        SzptClockInRulesDTO szptClockInRulesDTO = new SzptClockInRulesDTO();
        szptClockInRulesDTO.setId(2);
        szptClockInRulesDTO.setName("123456");
        szptClockInRulesDTO.setCsid("123456");
        szptClockInRulesDTO.setChockInTime("123456");
        szptClockInRulesDTO.setClockInScope("1");
        szptClockInRulesDTO.setQrCode("1");
        szptClockInRulesDTO.setCslx("123456");
        szptClockInRulesDTO.setBz("123456");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptClockInRules", szptClockInRulesDTO, SzptClockInRulesDTO.class);
    }

    @Test
    @DisplayName("考勤规则--更新")
    public void szptClockInRulesUpdateTest() {
        //请求参数
        SzptClockInRulesDTO szptClockInRulesDTO = new SzptClockInRulesDTO();
        szptClockInRulesDTO.setId(2);
        szptClockInRulesDTO.setName("22222");
        szptClockInRulesDTO.setCsid("22222");
        szptClockInRulesDTO.setChockInTime("22222");
        szptClockInRulesDTO.setClockInScope("1");
        szptClockInRulesDTO.setQrCode("1");
        szptClockInRulesDTO.setCslx("123456");
        szptClockInRulesDTO.setBz("123456");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptClockInRules", szptClockInRulesDTO, SzptClockInRulesDTO.class);
    }

    @Test
    @DisplayName("考勤规则--删除")
    public void szptClockInRulesDeleteTest() {
        //请求参数
        List<Integer> ids = new ArrayList<>();
        ids.add(1);
        ids.add(2);
        CommonDelIntDTO commonDelIntDTO = new CommonDelIntDTO();
        commonDelIntDTO.setIds(ids);
        commonDelIntDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptClockInRules", commonDelIntDTO, CommonDelIntDTO.class);
    }

    /**
     * ===================================================房屋信息===================================================
     */
    @Test
    @DisplayName("房屋信息--新增")
    public void szptFwxxAddTest() {
        //请求参数
        SzptFwxxDTO szptFwxxDTO = new SzptFwxxDTO();
        szptFwxxDTO.setQyid("5");
        szptFwxxDTO.setCsid("123456");
        szptFwxxDTO.setFwjc("123456");
        szptFwxxDTO.setJzqk("1");
        szptFwxxDTO.setCzyt("1");
        szptFwxxDTO.setHxjg("1");
        szptFwxxDTO.setFxid("123456");
        szptFwxxDTO.setCzba("2");
        szptFwxxDTO.setCzbah("123456");
        szptFwxxDTO.setCzbaqs("1");
        szptFwxxDTO.setCzbajz("1");
        szptFwxxDTO.setFzxm("1");
        szptFwxxDTO.setFzsfzh("1");
        szptFwxxDTO.setFzryid("1");
        szptFwxxDTO.setFzlxdh("1");
        szptFwxxDTO.setFwlc("1");
        szptFwxxDTO.setFwfjh("1");
        szptFwxxDTO.setFwzt("1");
        szptFwxxDTO.setQjms("1");
        szptFwxxDTO.setQjzt("1");
        szptFwxxDTO.setZjqjsj(new Date());
        szptFwxxDTO.setZdrq("1");
        szptFwxxDTO.setZdzq("1");
        szptFwxxDTO.setFwcs("1");
        szptFwxxDTO.setGlrlx("1");
        szptFwxxDTO.setGlrxm("1");
        szptFwxxDTO.setGlrsfzh("1");
        szptFwxxDTO.setGlrryid("1");
        szptFwxxDTO.setGlrlxdh("1");
        szptFwxxDTO.setGlrgsmc("1");
        szptFwxxDTO.setZcsid("1");
        szptFwxxDTO.setBz("1");
        szptFwxxDTO.setFkdjzdsh("1");
        szptFwxxDTO.setQtfwyt("1");
        szptFwxxDTO.setJkmhysj(new Date());
        szptFwxxDTO.setSjgsdwdm("330102");
        szptFwxxDTO.setSjgsdwmc("1");
        szptFwxxDTO.setFzzjzp("1");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptFwxx", szptFwxxDTO, SzptFwxxDTO.class);
    }

    @Test
    @DisplayName("房屋信息--更新")
    public void szptFwxxUpdateTest() {
        //请求参数
        SzptFwxxDTO szptFwxxDTO = new SzptFwxxDTO();
        szptFwxxDTO.setQyid("5");
        szptFwxxDTO.setCsid("1");
        szptFwxxDTO.setFwjc("123456");
        szptFwxxDTO.setJzqk("1");
        szptFwxxDTO.setCzyt("1");
        szptFwxxDTO.setHxjg("1");
        szptFwxxDTO.setFxid("123456");
        szptFwxxDTO.setCzba("2");
        szptFwxxDTO.setCzbah("123456");
        szptFwxxDTO.setCzbaqs("1");
        szptFwxxDTO.setCzbajz("1");
        szptFwxxDTO.setFzxm("1");
        szptFwxxDTO.setFzsfzh("1");
        szptFwxxDTO.setFzryid("1");
        szptFwxxDTO.setFzlxdh("1");
        szptFwxxDTO.setFwlc("1");
        szptFwxxDTO.setFwfjh("1");
        szptFwxxDTO.setFwzt("1");
        szptFwxxDTO.setQjms("1");
        szptFwxxDTO.setQjzt("1");
        szptFwxxDTO.setZjqjsj(new Date());
        szptFwxxDTO.setZdrq("1");
        szptFwxxDTO.setZdzq("1");
        szptFwxxDTO.setFwcs("1");
        szptFwxxDTO.setGlrlx("1");
        szptFwxxDTO.setGlrxm("1");
        szptFwxxDTO.setGlrsfzh("1");
        szptFwxxDTO.setGlrryid("1");
        szptFwxxDTO.setGlrlxdh("1");
        szptFwxxDTO.setGlrgsmc("1");
        szptFwxxDTO.setZcsid("1");
        szptFwxxDTO.setBz("1");
        szptFwxxDTO.setFkdjzdsh("1");
        szptFwxxDTO.setQtfwyt("1");
        szptFwxxDTO.setJkmhysj(new Date());
        szptFwxxDTO.setSjgsdwdm("330102");
        szptFwxxDTO.setSjgsdwmc("1");
        szptFwxxDTO.setFzzjzp("1");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptFwxx", szptFwxxDTO, SzptFwxxDTO.class);
    }

    @Test
    @DisplayName("房屋信息--删除")
    public void szptFwxxDeleteTest() {
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("3");
        ids.add("5");
        ids.add("demo");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptFwxx", commonDelDTO, CommonDelDTO.class);
    }

    /**
     * ===================================================场所预警忽略对象===================================================
     */
    @Test
    @DisplayName("场所预警忽略对象--新增")
    public void szptGdCsyjhldxAddTest() {
        //请求参数
        SzptGdCsyjhldxDTO szptGdCsyjhldxDTO = new SzptGdCsyjhldxDTO();
        szptGdCsyjhldxDTO.setId("2");
        szptGdCsyjhldxDTO.setCsid("123456123456");
        szptGdCsyjhldxDTO.setYjlx("1");
        szptGdCsyjhldxDTO.setYjzlx("1");
        szptGdCsyjhldxDTO.setYwid("1");
        szptGdCsyjhldxDTO.setYwms("1");
        szptGdCsyjhldxDTO.setBz("123456");
        szptGdCsyjhldxDTO.setZt("1");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptGdCsyjhldx", szptGdCsyjhldxDTO, SzptGdCsyjhldxDTO.class);
    }

    @Test
    @DisplayName("场所预警忽略对象--更新")
    public void szptGdCsyjhldxUpdateTest() {
        //请求参数
        SzptGdCsyjhldxDTO szptGdCsyjhldxDTO = new SzptGdCsyjhldxDTO();
        szptGdCsyjhldxDTO.setId("1");
        szptGdCsyjhldxDTO.setCsid("1");
        szptGdCsyjhldxDTO.setYjlx("1");
        szptGdCsyjhldxDTO.setYjzlx("1");
        szptGdCsyjhldxDTO.setYwid("1");
        szptGdCsyjhldxDTO.setYwms("1");
        szptGdCsyjhldxDTO.setBz("123456");
        szptGdCsyjhldxDTO.setZt("1");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptGdCsyjhldx", szptGdCsyjhldxDTO, SzptGdCsyjhldxDTO.class);
    }

    @Test
    @DisplayName("场所预警忽略对象--删除")
    public void szptGdCsyjhldxDeleteTest() {
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptGdCsyjhldx", commonDelDTO, CommonDelDTO.class);
    }

    /**
     * ===================================================工地人员信息===================================================
     */
    @Test
    @DisplayName("工地人员信息--新增")
    public void szptGdRyxxAddTest() {
        //请求参数
        SzptGdRyxxDTO szptGdRyxxDTO = new SzptGdRyxxDTO();
        szptGdRyxxDTO.setRkbm("2");
        szptGdRyxxDTO.setCsid("1123111111111111");
        szptGdRyxxDTO.setCjrlid("1");
        szptGdRyxxDTO.setXm("1");
        szptGdRyxxDTO.setXb("1");
        szptGdRyxxDTO.setLxdh("123456");
        szptGdRyxxDTO.setCyzjdm("1");
        szptGdRyxxDTO.setZjhm("5");
        szptGdRyxxDTO.setNl("1");
        szptGdRyxxDTO.setUrl("1");
        szptGdRyxxDTO.setMd5("1");
        szptGdRyxxDTO.setZjcxts(1);
        szptGdRyxxDTO.setZcxts(1);
        szptGdRyxxDTO.setYsrczjts(1);
        szptGdRyxxDTO.setYsrcbz("1");
        szptGdRyxxDTO.setYsrczts(5);
        szptGdRyxxDTO.setCkbz("1");
        szptGdRyxxDTO.setLkbz("1");
        szptGdRyxxDTO.setHjdzDzmc("1");
        szptGdRyxxDTO.setHjdzXzqhdm("1");
        szptGdRyxxDTO.setHjdzPcsmc("1");
        szptGdRyxxDTO.setHjdzPcsdm("123456");
        szptGdRyxxDTO.setXzdDzmc("1");
        szptGdRyxxDTO.setXzdXzqhdm("5");
        szptGdRyxxDTO.setXzdPcsmc("123456123456");
        szptGdRyxxDTO.setXzdPcsdm("1");
        szptGdRyxxDTO.setZt("1");
        szptGdRyxxDTO.setJcsj(new Date());
        szptGdRyxxDTO.setTcsj(new Date());
        szptGdRyxxDTO.setYjtcsj(new Date());
        szptGdRyxxDTO.setZjzpsj(new Date());
        szptGdRyxxDTO.setSfglry("5");
        szptGdRyxxDTO.setDjzt(1);
        szptGdRyxxDTO.setQyid("1");
        szptGdRyxxDTO.setQymc("1");
        szptGdRyxxDTO.setRylb("1");
        szptGdRyxxDTO.setRylx("1");
        szptGdRyxxDTO.setLkbdsj(new Date());
        szptGdRyxxDTO.setCkbdsj(new Date());
        szptGdRyxxDTO.setDatasource("1");
        szptGdRyxxDTO.setOrderid("1");
        szptGdRyxxDTO.setSjrzrs("123456");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptGdRyxx", szptGdRyxxDTO, SzptGdRyxxDTO.class);
    }

    @Test
    @DisplayName("工地人员信息--更新")
    public void szptGdRyxxUpdateTest() {
        //请求参数
        SzptGdRyxxDTO szptGdRyxxDTO = new SzptGdRyxxDTO();
        szptGdRyxxDTO.setRkbm("1");
        szptGdRyxxDTO.setCsid("1");
        szptGdRyxxDTO.setCjrlid("1");
        szptGdRyxxDTO.setXm("1");
        szptGdRyxxDTO.setXb("1");
        szptGdRyxxDTO.setLxdh("123456");
        szptGdRyxxDTO.setCyzjdm("1");
        szptGdRyxxDTO.setZjhm("5");
        szptGdRyxxDTO.setNl("1");
        szptGdRyxxDTO.setUrl("1");
        szptGdRyxxDTO.setMd5("1");
        szptGdRyxxDTO.setZjcxts(1);
        szptGdRyxxDTO.setZcxts(1);
        szptGdRyxxDTO.setYsrczjts(1);
        szptGdRyxxDTO.setYsrcbz("1");
        szptGdRyxxDTO.setYsrczts(5);
        szptGdRyxxDTO.setCkbz("1");
        szptGdRyxxDTO.setLkbz("1");
        szptGdRyxxDTO.setHjdzDzmc("1");
        szptGdRyxxDTO.setHjdzXzqhdm("1");
        szptGdRyxxDTO.setHjdzPcsmc("1");
        szptGdRyxxDTO.setHjdzPcsdm("123456");
        szptGdRyxxDTO.setXzdDzmc("1");
        szptGdRyxxDTO.setXzdXzqhdm("5");
        szptGdRyxxDTO.setXzdPcsmc("123456123456");
        szptGdRyxxDTO.setXzdPcsdm("1");
        szptGdRyxxDTO.setZt("1");
        szptGdRyxxDTO.setJcsj(new Date());
        szptGdRyxxDTO.setTcsj(new Date());
        szptGdRyxxDTO.setYjtcsj(new Date());
        szptGdRyxxDTO.setZjzpsj(new Date());
        szptGdRyxxDTO.setSfglry("5");
        szptGdRyxxDTO.setDjzt(1);
        szptGdRyxxDTO.setQyid("1");
        szptGdRyxxDTO.setQymc("1");
        szptGdRyxxDTO.setRylb("1");
        szptGdRyxxDTO.setRylx("1");
        szptGdRyxxDTO.setLkbdsj(new Date());
        szptGdRyxxDTO.setCkbdsj(new Date());
        szptGdRyxxDTO.setDatasource("1");
        szptGdRyxxDTO.setOrderid("1");
        szptGdRyxxDTO.setSjrzrs("123456");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptGdRyxx", szptGdRyxxDTO, SzptGdRyxxDTO.class);
    }

    @Test
    @DisplayName("工地人员信息--删除")
    public void szptGdRyxxDeleteTest() {
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptGdRyxx", commonDelDTO, CommonDelDTO.class);
    }

    /**
     * ===================================================设备信息===================================================
     */
    @Test
    @DisplayName("设备信息--新增")
    public void szptGdSbxxAddTest() {
        //请求参数
        SzptGdSbxxDTO szptGdSbxxDTO = new SzptGdSbxxDTO();
        szptGdSbxxDTO.setSbsn("1");
        szptGdSbxxDTO.setSbmc("1");
        szptGdSbxxDTO.setSbbh("1");
        szptGdSbxxDTO.setSbms("1");
        szptGdSbxxDTO.setMac("1");
        szptGdSbxxDTO.setIp("123456");
        szptGdSbxxDTO.setNetmask("1");
        szptGdSbxxDTO.setGw("5");
        szptGdSbxxDTO.setCsid("1");
        szptGdSbxxDTO.setYxzt("1");
        szptGdSbxxDTO.setZtgxsj(new Date());
        szptGdSbxxDTO.setCj("1");
        szptGdSbxxDTO.setXh("1");
        szptGdSbxxDTO.setQyid("1");
        szptGdSbxxDTO.setQymc("1");
        szptGdSbxxDTO.setSbcs("1");
        szptGdSbxxDTO.setSblb("1");
        szptGdSbxxDTO.setZt("1");
        szptGdSbxxDTO.setSjgsdwdm("330102");
        szptGdSbxxDTO.setSjgsdwmc("1");
        szptGdSbxxDTO.setCreateGajgjgdm("123");
        szptGdSbxxDTO.setCreateGajgmc("123");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptGdSbxx", szptGdSbxxDTO, SzptGdSbxxDTO.class);
    }

    @Test
    @DisplayName("设备信息--更新")
    public void szptGdSbxxUpdateTest() {
        //请求参数
        SzptGdSbxxDTO szptGdSbxxDTO = new SzptGdSbxxDTO();
        szptGdSbxxDTO.setSbsn("1");
        szptGdSbxxDTO.setSbmc("1");
        szptGdSbxxDTO.setSbbh("1");
        szptGdSbxxDTO.setSbms("1");
        szptGdSbxxDTO.setMac("1");
        szptGdSbxxDTO.setIp("123456");
        szptGdSbxxDTO.setNetmask("1");
        szptGdSbxxDTO.setGw("5");
        szptGdSbxxDTO.setCsid("1");
        szptGdSbxxDTO.setYxzt("1");
        szptGdSbxxDTO.setZtgxsj(new Date());
        szptGdSbxxDTO.setCj("1");
        szptGdSbxxDTO.setXh("1");
        szptGdSbxxDTO.setQyid("1");
        szptGdSbxxDTO.setQymc("1");
        szptGdSbxxDTO.setSbcs("1");
        szptGdSbxxDTO.setSblb("1");
        szptGdSbxxDTO.setZt("1");
        szptGdSbxxDTO.setSjgsdwdm("330102");
        szptGdSbxxDTO.setSjgsdwmc("1");
        szptGdSbxxDTO.setCreateGajgjgdm("123");
        szptGdSbxxDTO.setCreateGajgmc("123");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptGdSbxx", szptGdSbxxDTO, SzptGdSbxxDTO.class);
    }

    @Test
    @DisplayName("设备信息--删除")
    public void szptGdSbxxDeleteTest() {
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("4");
        ids.add("5");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptGdSbxx", commonDelDTO, CommonDelDTO.class);
    }

    /**
     * ===================================================工地信息===================================================
     */
    @Test
    @DisplayName("工地信息--新增")
    public void szptGdXxAddTest() {
        //请求参数
        SzptGdXxDTO szptGdXxDTO = new SzptGdXxDTO();
        szptGdXxDTO.setId("3");
        szptGdXxDTO.setCslx("1");
        szptGdXxDTO.setCsmc("1111111111111111111");
        szptGdXxDTO.setCsms("1");
        szptGdXxDTO.setLxdz("1");
        szptGdXxDTO.setLxr("1");
        szptGdXxDTO.setLxdh("123456");
        szptGdXxDTO.setSgdw("1");
        szptGdXxDTO.setSgxkz("5");
        szptGdXxDTO.setKgrq(new Date());
        szptGdXxDTO.setYjjgrq(new Date());
        szptGdXxDTO.setLng("120.3");
        szptGdXxDTO.setLat("30");
        szptGdXxDTO.setCustomlng("1");
        szptGdXxDTO.setCustomlat("1");
        szptGdXxDTO.setZrrxm("1");
        szptGdXxDTO.setZrrlxdh("1");
        szptGdXxDTO.setFrxm("1");
        szptGdXxDTO.setFrlxdh("1");
        szptGdXxDTO.setShxydm("330102");
        szptGdXxDTO.setZcdz("1");
        szptGdXxDTO.setAdminzh("123");
        szptGdXxDTO.setSfzcs("1");
        szptGdXxDTO.setFcsid("1");
        szptGdXxDTO.setBz("1");
        szptGdXxDTO.setCjsj(new Date());
        szptGdXxDTO.setZt("1");
        szptGdXxDTO.setJhsj(new Date());
        szptGdXxDTO.setLocation("1");
        szptGdXxDTO.setSjlyXtmc("340102");
        szptGdXxDTO.setZxsj(new Date());
        szptGdXxDTO.setSqdm("123");
        szptGdXxDTO.setSqmc("123");
        szptGdXxDTO.setMdlx("1");
        szptGdXxDTO.setMdjyzt("1");
        szptGdXxDTO.setSjgsdwdm("330102");
        szptGdXxDTO.setSjgsdwmc("1");
        szptGdXxDTO.setCreateGajgjgdm("1");
        szptGdXxDTO.setCreateGajgmc("1");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptGdXx", szptGdXxDTO, SzptGdXxDTO.class);
    }

    @Test
    @DisplayName("工地信息--更新")
    public void szptGdXxUpdateTest() {
        //请求参数
        SzptGdXxDTO szptGdXxDTO = new SzptGdXxDTO();
        szptGdXxDTO.setId("1");
        szptGdXxDTO.setCslx("1");
        szptGdXxDTO.setCsmc("2");
        szptGdXxDTO.setCsms("1");
        szptGdXxDTO.setLxdz("1");
        szptGdXxDTO.setLxr("1");
        szptGdXxDTO.setLxdh("123456");
        szptGdXxDTO.setSgdw("1");
        szptGdXxDTO.setSgxkz("5");
        szptGdXxDTO.setKgrq(new Date());
        szptGdXxDTO.setYjjgrq(new Date());
        szptGdXxDTO.setLng("120.3");
        szptGdXxDTO.setLat("30");
        szptGdXxDTO.setCustomlng("1");
        szptGdXxDTO.setCustomlat("1");
        szptGdXxDTO.setZrrxm("1");
        szptGdXxDTO.setZrrlxdh("1");
        szptGdXxDTO.setFrxm("1");
        szptGdXxDTO.setFrlxdh("1");
        szptGdXxDTO.setShxydm("330102");
        szptGdXxDTO.setZcdz("1");
        szptGdXxDTO.setAdminzh("123");
        szptGdXxDTO.setSfzcs("1");
        szptGdXxDTO.setFcsid("1");
        szptGdXxDTO.setBz("1");
        szptGdXxDTO.setCjsj(new Date());
        szptGdXxDTO.setZt("1");
        szptGdXxDTO.setJhsj(new Date());
        szptGdXxDTO.setLocation("1");
        szptGdXxDTO.setSjlyXtmc("340102");
        szptGdXxDTO.setZxsj(new Date());
        szptGdXxDTO.setSqdm("123");
        szptGdXxDTO.setSqmc("123");
        szptGdXxDTO.setMdlx("1");
        szptGdXxDTO.setMdjyzt("1");
        szptGdXxDTO.setSjgsdwdm("330102");
        szptGdXxDTO.setSjgsdwmc("1");
        szptGdXxDTO.setCreateGajgjgdm("1");
        szptGdXxDTO.setCreateGajgmc("1");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptGdXx", szptGdXxDTO, SzptGdXxDTO.class);
    }

    @Test
    @DisplayName("工地信息--删除")
    public void szptGdXxDeleteTest() {
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        ids.add("3");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptGdXx", commonDelDTO, CommonDelDTO.class);
    }

    /**
     * ===================================================工地预警流水表===================================================
     */
    @Test
    @DisplayName("工地预警流水表--新增")
    public void szptGdYjAddTest() {
        //请求参数
        SzptGdYjDTO szptGdYjDTO = new SzptGdYjDTO();
        szptGdYjDTO.setId("3");
        szptGdYjDTO.setCsid("1");
        szptGdYjDTO.setYjrq("1");
        szptGdYjDTO.setYjlx("1");
        szptGdYjDTO.setYjzlx("1");
        szptGdYjDTO.setYjnr("1");
        szptGdYjDTO.setYwid("123456");
        szptGdYjDTO.setYwcs("1");
        szptGdYjDTO.setYjzt("5");
        szptGdYjDTO.setClsj(new Date());
        szptGdYjDTO.setCljg("123");
        szptGdYjDTO.setClrid("120.3");
        szptGdYjDTO.setClrxm("30");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptGdYj", szptGdYjDTO, SzptGdYjDTO.class);
    }

    @Test
    @DisplayName("工地预警流水表--更新")
    public void szptGdYjUpdateTest() {
        //请求参数
        SzptGdYjDTO szptGdYjDTO = new SzptGdYjDTO();
        szptGdYjDTO.setId("2");
        szptGdYjDTO.setCsid("11111111111111111111");
        szptGdYjDTO.setYjrq("1");
        szptGdYjDTO.setYjlx("1");
        szptGdYjDTO.setYjzlx("1");
        szptGdYjDTO.setYjnr("1");
        szptGdYjDTO.setYwid("123456");
        szptGdYjDTO.setYwcs("1");
        szptGdYjDTO.setYjzt("5");
        szptGdYjDTO.setClsj(new Date());
        szptGdYjDTO.setCljg("123");
        szptGdYjDTO.setClrid("120.3");
        szptGdYjDTO.setClrxm("30");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptGdYj", szptGdYjDTO, SzptGdYjDTO.class);
    }

    @Test
    @DisplayName("工地预警流水表--删除")
    public void szptGdYjDeleteTest() {
        //请求参数
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        ids.add("3");
//        ids.add("1876882723429670913");
//        ids.add("1876883035569774594");
//        ids.add("1876887147652833281");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptGdYj", commonDelDTO, CommonDelDTO.class);
    }


    /**
     * ===================================================区域信息表===================================================
     */
    @Test
    @DisplayName("区域信息表--新增")
    public void szptQyxxAddTest() {
        //请求参数
        SzptQyxxDTO szptQyxxDTO = new SzptQyxxDTO();
        szptQyxxDTO.setId("3");
        szptQyxxDTO.setCsid("1");
        szptQyxxDTO.setQymc("1");
        szptQyxxDTO.setQyjc("1");
        szptQyxxDTO.setQyqc("1");
        szptQyxxDTO.setQylx("1");
        szptQyxxDTO.setLevel("123456");
        szptQyxxDTO.setFqyid("1");
        szptQyxxDTO.setXssx("5");
        szptQyxxDTO.setLng("6");
        szptQyxxDTO.setLat("123");
        szptQyxxDTO.setCustomlng("120.3");
        szptQyxxDTO.setCustomlat("30");

        szptQyxxDTO.setZt("1");
        szptQyxxDTO.setSjgsdwdm("330102");
        szptQyxxDTO.setSjgsdwmc("123");
        szptQyxxDTO.setCreateGajgjgdm("123");
        szptQyxxDTO.setCreateGajgmc("120.3");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptQyxx", szptQyxxDTO, SzptQyxxDTO.class);
    }

    @Test
    @DisplayName("区域信息表--更新")
    public void szptQyxxUpdateTest() {
        //请求参数
        SzptQyxxDTO szptQyxxDTO = new SzptQyxxDTO();
        szptQyxxDTO.setId("1");
        szptQyxxDTO.setCsid("111111");
        szptQyxxDTO.setQymc("1");
        szptQyxxDTO.setQyjc("1");
        szptQyxxDTO.setQyqc("1");
        szptQyxxDTO.setQylx("1");
        szptQyxxDTO.setLevel("123456");
        szptQyxxDTO.setFqyid("1");
        szptQyxxDTO.setXssx("5");
        szptQyxxDTO.setLng("6");
        szptQyxxDTO.setLat("123");
        szptQyxxDTO.setCustomlng("120.3");
        szptQyxxDTO.setCustomlat("30");

        szptQyxxDTO.setZt("1");
        szptQyxxDTO.setSjgsdwdm("330102");
        szptQyxxDTO.setSjgsdwmc("123");
        szptQyxxDTO.setCreateGajgjgdm("123");
        szptQyxxDTO.setCreateGajgmc("120.3");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptQyxx", szptQyxxDTO, SzptQyxxDTO.class);
    }

    @Test
    @DisplayName("区域信息表--删除")
    public void szptQyxxDeleteTest() {
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        ids.add("3");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptQyxx", commonDelDTO, CommonDelDTO.class);
    }


    /**
     * ===================================================打卡信息===================================================
     */
    @Test
    @DisplayName("打卡信息--新增")
    public void szptXyzhDkxxAddTest() {
        //请求参数
        SzptXyzhDkxxDTO szptXyzhDkxxDTO = new SzptXyzhDkxxDTO();
        szptXyzhDkxxDTO.setDklsid("3");
        szptXyzhDkxxDTO.setXyid("1");
        szptXyzhDkxxDTO.setRyid("1");
        szptXyzhDkxxDTO.setQdsj(new Date());
        szptXyzhDkxxDTO.setQtsj(new Date());
        szptXyzhDkxxDTO.setZt("1");
        szptXyzhDkxxDTO.setQddz("1");
        szptXyzhDkxxDTO.setQtdz("1");
        szptXyzhDkxxDTO.setQdxzb("1");
        szptXyzhDkxxDTO.setQdyzb("1");
        szptXyzhDkxxDTO.setQtxzb("1");
        szptXyzhDkxxDTO.setQtyzb("1");
        szptXyzhDkxxDTO.setQdtp("1");
        szptXyzhDkxxDTO.setQttp("1");
        szptXyzhDkxxDTO.setCjsj(new Date());
        szptXyzhDkxxDTO.setGxsj(new Date());

        TestHttpUtil.signatureAndRequest("/rest/index/addSzptXyzhDkxx", szptXyzhDkxxDTO, SzptXyzhDkxxDTO.class);
    }

    @Test
    @DisplayName("打卡信息--更新")
    public void szptXyzhDkxxUpdateTest() {
        //请求参数
        SzptXyzhDkxxDTO szptXyzhDkxxDTO = new SzptXyzhDkxxDTO();
        szptXyzhDkxxDTO.setDklsid("1");
        szptXyzhDkxxDTO.setXyid("1111");
        szptXyzhDkxxDTO.setRyid("1111");
        szptXyzhDkxxDTO.setQdsj(new Date());
        szptXyzhDkxxDTO.setQtsj(new Date());
        szptXyzhDkxxDTO.setZt("1");
        szptXyzhDkxxDTO.setQddz("1");
        szptXyzhDkxxDTO.setQtdz("1");
        szptXyzhDkxxDTO.setQdxzb("1");
        szptXyzhDkxxDTO.setQdyzb("1");
        szptXyzhDkxxDTO.setQtxzb("1");
        szptXyzhDkxxDTO.setQtyzb("1");
        szptXyzhDkxxDTO.setQdtp("1");
        szptXyzhDkxxDTO.setQttp("1");
        szptXyzhDkxxDTO.setCjsj(new Date());
        szptXyzhDkxxDTO.setGxsj(new Date());
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptXyzhDkxx", szptXyzhDkxxDTO, SzptXyzhDkxxDTO.class);
    }

    @Test
    @DisplayName("打卡信息--删除")
    public void szptXyzhDkxxDeleteTest() {
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        ids.add("3");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptXyzhDkxx", commonDelDTO, CommonDelDTO.class);
    }


    /**
     * ===================================================考勤模板===================================================
     */
    @Test
    @DisplayName("考勤模板--新增")
    public void szptXyzhKqmbAddTest() {
        //请求参数
        SzptXyzhKqmbDTO szptXyzhKqmbDTO = new SzptXyzhKqmbDTO();
        szptXyzhKqmbDTO.setId("3");
        szptXyzhKqmbDTO.setMbmc("1");
        szptXyzhKqmbDTO.setZt("1");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptXyzhKqmb", szptXyzhKqmbDTO, SzptXyzhKqmbDTO.class);
    }

    @Test
    @DisplayName("考勤模板--更新")
    public void szptXyzhKqmbUpdateTest() {
        //请求参数
        SzptXyzhKqmbDTO szptXyzhKqmbDTO = new SzptXyzhKqmbDTO();
        szptXyzhKqmbDTO.setId("2");
        szptXyzhKqmbDTO.setMbmc("22");
        szptXyzhKqmbDTO.setZt("1");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptXyzhKqmb", szptXyzhKqmbDTO, SzptXyzhKqmbDTO.class);
    }

    @Test
    @DisplayName("考勤模板--删除")
    public void szptXyzhKqmbDeleteTest() {
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        ids.add("3");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptXyzhKqmb", commonDelDTO, CommonDelDTO.class);
    }

    /**
     * ===================================================考勤情况===================================================
     */
    @Test
    @DisplayName("考勤情况--新增")
    public void szptXyzhMbdhAddTest() {
        //请求参数
        SzptXyzhMbdhDTO szptXyzhMbdhDTO = new SzptXyzhMbdhDTO();
        szptXyzhMbdhDTO.setId("3");
        szptXyzhMbdhDTO.setMbid("3");
        szptXyzhMbdhDTO.setDay("2");
        szptXyzhMbdhDTO.setSbsj1("1");
        szptXyzhMbdhDTO.setXbsj1("1");
        szptXyzhMbdhDTO.setSbsj2("1");
        szptXyzhMbdhDTO.setXbsj2("1");
        szptXyzhMbdhDTO.setSbsj3("1");
        szptXyzhMbdhDTO.setXbsj3("1");
        szptXyzhMbdhDTO.setZt("1");
        szptXyzhMbdhDTO.setCjrid("1");
        szptXyzhMbdhDTO.setCjrxm("1");
        szptXyzhMbdhDTO.setCjsj(new Date());
        szptXyzhMbdhDTO.setGxrid("1");
        szptXyzhMbdhDTO.setGxrxm("1");
        szptXyzhMbdhDTO.setGxsj(new Date());
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptXyzhMbdh", szptXyzhMbdhDTO, SzptXyzhMbdhDTO.class);
    }

    @Test
    @DisplayName("考勤情况--更新")
    public void szptXyzhMbdhUpdateTest() {
        //请求参数
        SzptXyzhMbdhDTO szptXyzhMbdhDTO = new SzptXyzhMbdhDTO();
        szptXyzhMbdhDTO.setId("1");
        szptXyzhMbdhDTO.setMbid("311111");
        szptXyzhMbdhDTO.setDay("2");
        szptXyzhMbdhDTO.setSbsj1("11111");
        szptXyzhMbdhDTO.setXbsj1("11111");
        szptXyzhMbdhDTO.setSbsj2("1");
        szptXyzhMbdhDTO.setXbsj2("1");
        szptXyzhMbdhDTO.setSbsj3("1");
        szptXyzhMbdhDTO.setXbsj3("1");
        szptXyzhMbdhDTO.setZt("1");
        szptXyzhMbdhDTO.setCjrid("1");
        szptXyzhMbdhDTO.setCjrxm("1");
        szptXyzhMbdhDTO.setCjsj(new Date());
        szptXyzhMbdhDTO.setGxrid("1");
        szptXyzhMbdhDTO.setGxrxm("1");
        szptXyzhMbdhDTO.setGxsj(new Date());
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptXyzhMbdh", szptXyzhMbdhDTO, SzptXyzhMbdhDTO.class);
    }

    @Test
    @DisplayName("考勤情况--删除")
    public void szptXyzhMbdhDeleteTest() {
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        ids.add("3");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptXyzhMbdh", commonDelDTO, CommonDelDTO.class);
    }

    /**
     * ===================================================校园信息===================================================
     */
    @Test
    @DisplayName("校园信息--新增")
    public void szptXyzhXyxxAddTest() {
        //请求参数
        SzptXyzhXyxxDTO szptXyzhXyxxDTO = new SzptXyzhXyxxDTO();
        szptXyzhXyxxDTO.setId(3);
        szptXyzhXyxxDTO.setMc("3");
        szptXyzhXyxxDTO.setSsdwmc("2");
        szptXyzhXyxxDTO.setSsdwdm("1");
        szptXyzhXyxxDTO.setZddw("1");
        szptXyzhXyxxDTO.setCjsj(new Date());
        szptXyzhXyxxDTO.setGxsj(new Date());
        szptXyzhXyxxDTO.setDz("1");
        szptXyzhXyxxDTO.setZb("1");
        szptXyzhXyxxDTO.setXxlx("1");
        szptXyzhXyxxDTO.setDakafw(1);
        szptXyzhXyxxDTO.setKqmbid("1");
        szptXyzhXyxxDTO.setQrcode("1");
        TestHttpUtil.signatureAndRequest("/rest/index/addSzptXyzhXyxx", szptXyzhXyxxDTO, SzptXyzhXyxxDTO.class);
    }

    @Test
    @DisplayName("校园信息--更新")
    public void szptXyzhXyxxUpdateTest() {
        //请求参数
        SzptXyzhXyxxDTO szptXyzhXyxxDTO = new SzptXyzhXyxxDTO();
        szptXyzhXyxxDTO.setId(3);
        szptXyzhXyxxDTO.setMc("333333");
        szptXyzhXyxxDTO.setSsdwmc("2");
        szptXyzhXyxxDTO.setSsdwdm("1");
        szptXyzhXyxxDTO.setZddw("1");
        szptXyzhXyxxDTO.setCjsj(new Date());
        szptXyzhXyxxDTO.setGxsj(new Date());
        szptXyzhXyxxDTO.setDz("1");
        szptXyzhXyxxDTO.setZb("1");
        szptXyzhXyxxDTO.setXxlx("1");
        szptXyzhXyxxDTO.setDakafw(1);
        szptXyzhXyxxDTO.setKqmbid("1");
        szptXyzhXyxxDTO.setQrcode("1");
        TestHttpUtil.signatureAndRequest("/rest/index/updateSzptXyzhXyxx", szptXyzhXyxxDTO, SzptXyzhXyxxDTO.class);
    }

    @Test
    @DisplayName("校园信息--删除")
    public void szptXyzhXyxxDeleteTest() {
        List<String> ids = new ArrayList<>();
        ids.add("1");
        ids.add("2");
        ids.add("3");
        CommonDelDTO commonDelDTO = new CommonDelDTO();
        commonDelDTO.setIds(ids);
        commonDelDTO.setSjgsdwdm("330102");
        TestHttpUtil.signatureAndRequest("/rest/index/deleteSzptXyzhXyxx", commonDelDTO, CommonDelDTO.class);
    }
}
