package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.XxShxxyDwDTO;
import com.zksy.szpt.domain.dto.XxYjrwDTO;
import com.zksy.szpt.service.XxShxxyDwService;
import com.zksy.szpt.service.XxYjrwService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "社会信息员队伍服务")
@RequestMapping("/rest/xxShxxydw")
@RestController
@Validated
public class XxShxxyDwController {
    private final XxShxxyDwService service;

    public XxShxxyDwController(XxShxxyDwService service) {
        this.service = service;
    }


    @ApiOperation(value = "新增社会信息员队伍数据")
    @PostMapping("/add")
    public Integer XxShxxyDw(@RequestBody @Validated XxShxxyDwDTO dto) {
        return service.addXxShxxyDw(dto);
    }

    @ApiOperation(value = "修改社会信息员队伍数据")
    @PostMapping("/update")
    public Integer update(@RequestBody @Validated XxShxxyDwDTO dto) {
        return service.update(dto);
    }

    @ApiOperation(value = "删除社会信息员队伍数据")
    @GetMapping("/delete")
    public Integer delete(@RequestParam(name = "id") String id) {
        return service.delete(id);
    }

}
