package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.SzptGdXxDTO;
import com.zksy.szpt.service.SzptGdXxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptGdXxController {
    private final SzptGdXxService szptGdXxService;

    public SzptGdXxController(SzptGdXxService szptGdXxService) {
        this.szptGdXxService = szptGdXxService;
    }

    @ApiOperation(value="新增工地信息数据")
    @PostMapping("/addSzptGdXx")
    public Integer addSzptGdXx(@RequestBody @Validated SzptGdXxDTO szptGdXxDTO){
        return szptGdXxService.addSzptGdXx(szptGdXxDTO);
    }
}
