package com.zksy.szpt;

import cn.hutool.core.date.DateUtil;
import com.zksy.szpt.domain.ListImageType;
import com.zksy.szpt.domain.UploadImageDTO;
import com.zksy.szpt.domain.dto.*;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.*;

/**
 * A simple unit test
 */
@SpringBootTest()
public class MainTest {

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("任务完成情况")
    public void xxRwwcqkTest() {
        //请求参数
        XxRwwcqkDTO xxRwwcqkDTO = new XxRwwcqkDTO();
        xxRwwcqkDTO.setRwid("123456789101");
//        xxRwwcqkDTO.setXxyid("1234567891015");
        xxRwwcqkDTO.setWczt("1");
        xxRwwcqkDTO.setBmzt("1");
        xxRwwcqkDTO.setYjdw("1");
        xxRwwcqkDTO.setXm("张五常");
        xxRwwcqkDTO.setLxdh("12584587544");
        xxRwwcqkDTO.setFknr("义务巡逻辖区内");
        xxRwwcqkDTO.setJssj(new Date());
        xxRwwcqkDTO.setFksj(new Date());
        xxRwwcqkDTO.setShsj(new Date());
        xxRwwcqkDTO.setShrxm("李凡");
        xxRwwcqkDTO.setShrid("1");
        xxRwwcqkDTO.setShsm("任务待完成");
        xxRwwcqkDTO.setMchid("333021");

        TestHttpUtil.signatureAndRequest("/rest/index/addXxRwwcqk", xxRwwcqkDTO, XxRwwcqkDTO.class);
//        TestHttpUtil.signatureAndRequest("/rest/index/updateXxRwwcqk", xxRwwcqkDTO, XxRwwcqkDTO.class);
    }

    /**
     * 账户信息
     */
    @Test
    @DisplayName("账户信息")
    public void zhxxtest() {
        //请求参数
        XxZhxxDTO dto = new XxZhxxDTO();
//        dto.setZhid("123456789101");
        dto.setXxyid("11");
        dto.setZt("1");
        dto.setClbz("4");
        dto.setZhid("3771928e-5917-45d2-a3cf-e8b6be6debb9");
        dto.setZhlx("1");
        dto.setXm("胡理");
        dto.setSfzh("330182198011279346");
        dto.setLxdh("13900000000");
        dto.setOpenid("bc6dcba1ad58408197f6a0775d0a19e7");
        dto.setNc("昵称3485");
        dto.setUnionid("c7ae76e0940d47188bfe75ef419de0dd");
        dto.setFsqbs("1");
        dto.setAccountid("bcd2939d31743d580942fa231e2b96f");
        dto.setRoles("1");
        dto.setYqm("2");
        dto.setYqmid("1");
        dto.setClsj(new Date());
        dto.setCljg("1");
        dto.setFhsj(new Date());
        dto.setOcuuid("290b63a465c84d88851f6609fc9f5d5a");
        dto.setZhcs("1");
        dto.setMchid("c449340a11e14638adf274bc7a8c6c7c");

//        TestHttpUtil.signatureAndRequest("/rest/xxZhxx/add", dto, XxZhxxDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxZhxx/update", dto, XxZhxxDTO.class);
    }

    /**
     * 账户积分变更
     */
    @Test
    @DisplayName("账户积分变更")
    public void test1() {
        //请求参数
        XxZhjfbgDTO dto = new XxZhjfbgDTO();
        dto.setZhid("1");
        dto.setDhid("123456789101");
        dto.setQbid("2");
        dto.setBgsj(new Date());
        dto.setBgjf(200L);
        dto.setBghjf(300L);
        dto.setBgqjf(500L);
        dto.setBglx("2");
        dto.setBz("积分兑换");
        dto.setQbjlid("1");

        TestHttpUtil.signatureAndRequest("/rest/xxZhjfbg/add", dto, XxZhjfbgDTO.class);
//        TestHttpUtil.signatureAndRequest("/rest/xxZhjfbg/update", dto, XxZhjfbgDTO.class);
    }


    /**
     * 文件上传
     */
    @Test
    @DisplayName("文件上传")
    public void uploadFileTest() {
        //请求参数
        UploadImageDTO uploadImageDTO = new UploadImageDTO();
        uploadImageDTO.setImagePath("http://192.168.168.211/guoqing.jpg");
        uploadImageDTO.setImageType(ListImageType.FACE);
        TestHttpUtil.signatureAndRequest("/rest/image/upload", uploadImageDTO, UploadImageDTO.class);
    }

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("义警任务")
    public void test4() {
        //请求参数
        XxYjrwDTO dto = new XxYjrwDTO();
//        dto.setZhid("123456789101");
        dto.setRwid("123456789101");
        dto.setRwbt("双节前三天海南离岛免税购物金额4.26亿元");
        dto.setRwnr("中秋和国庆长假期间，海南离岛免税购物火爆。据海口海关统计，假期前三天，海口海关共监管离岛免税销售金额4.26亿元，比2022年同期增长40.3%，免税购物人数6.16万人次，比2022年同期增长84.1%。");
        dto.setGzrs(1L);
        dto.setSfsh(1);
        dto.setWcrs(1L);
        dto.setRjjljf(101L);
        dto.setRwqsrq(new Date());
        dto.setRwjzrq(DateUtil.endOfMonth(new Date()));
        dto.setTimePattern(1);
        dto.setScheduleId("1");
        dto.setSfsh(1);
        dto.setFbfwbm("1,10,2,3,4,");
        dto.setFbrid("bbb919c6023646a9a6e595d385a60b95");
        dto.setFbfw("红色卫队,绿色卫队,蓝色卫队,,白色卫队,,洪桥义警联盟,");
        dto.setFbrxm("长兴管理员");
        dto.setFbsj(new Date());
        dto.setMchid("edc788af601211eeab44000c293a2347");
        dto.setRwzt("1");
        dto.setRwlx("1");
        dto.setPictureUrls("https://pics5.baidu.com/feed/9825bc315c6034a8e54636072d08095b082376bf.jpeg@f_auto?token=98350f9a138414c8325ce9b265f43a9c,https://pics5.baidu.com/feed/9825bc315c6034a8e54636072d08095b082376bf.jpeg@f_auto?token=98350f9a138414c8325ce9b265f43a9c");
        TestHttpUtil.signatureAndRequest("/rest/xxYjrw/add", dto, XxYjrwDTO.class);
//        TestHttpUtil.signatureAndRequest("/rest/xxYjrw/update", dto, XxYjrwDTO.class);
    }

    /**
     * 任务完成情况
     */
    @Test
    @DisplayName("义警队伍代码")
    public void test5() {
        //请求参数
        XxYjdwdmDTO dto = new XxYjdwdmDTO();
//        dto.setZhid("123456789101");
        dto.setDwlx(Integer.valueOf(0));
        dto.setId("123456789101");
        dto.setMchid("11111");
        dto.setZt("1");
        dto.setYjdwmc("红色卫队");
        dto.setYjdwjs("红色卫队是一支由青年人组成的卫队");
        dto.setFid("-1");
        TestHttpUtil.signatureAndRequest("/rest/xxYjdwdm/add", dto, XxYjdwdmDTO.class);
//        TestHttpUtil.signatureAndRequest("/rest/xxYjdwdm/update", dto, XxYjdwdmDTO.class);
    }

    @Test
    @DisplayName("社会信息员队伍")
    public void test6() {
        XxShxxyDwDTO dto = new XxShxxyDwDTO();
        dto.setId("123456789101");
        dto.setDwdm("10");
        dto.setShxxyid("M15");
        dto.setYjdwdm("1dbcf7b68e6911eea13b000c293a2347");

        TestHttpUtil.signatureAndRequest("/rest/xxShxxyDw/add", dto, XxShxxyDwDTO.class);
//        TestHttpUtil.signatureAndRequest("/rest/xxShxxyDw/update", dto, XxShxxyDwDTO.class);
    }

    @Test
    @DisplayName("社会信息员")
    public void test7() {
        XxShxxyDTO dto = new XxShxxyDTO();
        dto.setXxyid("123456789101");
        dto.setZt("1");
        dto.setSbfszt("9");
        dto.setShrid("1");
        dto.setMchid("c449340a11e14638adf274bc7a8c6c7c");
        dto.setDj("1");
        dto.setFwcs("百脑汇3楼2022");
        dto.setFsqbzs("12");
        dto.setHfbz("test");
        dto.setHjdz("江西省上饶市鼓楼街道春风小区1-1-101");
        dto.setLxdh("18888888882");
        dto.setLxdh2("18888888882");
        dto.setLxdh3("11");
        dto.setQbflid("70006015");
        dto.setShsj(new Date());
        dto.setZzdz("九莲新村3-1-502");
        dto.setZym("1");
        dto.setZylx("1");
        dto.setYwjrxm("");
        dto.setYjdw("");
        dto.setXm("楼小满");
        dto.setXxybh("M23");
        dto.setXxylx("4");
        dto.setWjsj(new Date());
        dto.setWjrxm("开瑞");
        dto.setWjrid("104");
        dto.setShsm("审核不通过");
        dto.setShsj(new Date());
        dto.setShrxm("长兴管理员");
        dto.setShrid("bbb919c6023646a9a6e595d385a60b95");
        dto.setSfzh("330103198309012215");
        dto.setQtzylx("1");
        dto.setSsbmbm("330902010000");
        dto.setSbfssj(new Date());
        dto.setSbfsjg("");
        dto.setHfbz("");
        dto.setQbflid("70006015");
        dto.setShbz("1");
        TestHttpUtil.signatureAndRequest("/rest/xxShxxy/add", dto, XxShxxyDTO.class);
//        TestHttpUtil.signatureAndRequest("/rest/xxShxxy/update", dto, XxShxxyDTO.class);
    }


    @Test
    @DisplayName("删除服务")
    public void testdelete() {
        List<String> ids = new ArrayList<>();
        ids.add("123456789101");
        ids.add("1234567891015");
        ids.add("1");
        CommonDelParamDTO dto=new CommonDelParamDTO();
        dto.setIds(ids);
//        String url="xxShxxyDw/delete";
//        String url="xxShxxy/delete";
//        String url="xxYjdwdm/delete";
//        String url="xxYjrw/delete";
//        String url="xxZhjfbg/delete";
//        String url = "xxZhxx/delete";
        CommonDelDTO delDTO=new CommonDelDTO();
        delDTO.setIds(ids);
        TestHttpUtil.signatureAndRequest("/rest/xxShxxyDw/delete", dto, CommonDelParamDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxShxxy/delete", dto, CommonDelParamDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxYjdwdm/delete", dto, CommonDelParamDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxYjrw/delete", dto, CommonDelParamDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxZhjfbg/delete", dto, CommonDelParamDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/xxZhxx/delete", dto, CommonDelParamDTO.class);
        TestHttpUtil.signatureAndRequest("/rest/index/deleteXxRwwcqk", delDTO, CommonDelDTO.class);
    }

}
