package com.zksy.szpt.controller;

import com.zksy.szpt.domain.PageInfo;
import com.zksy.szpt.domain.bo.SzptClockInBO;
import com.zksy.szpt.domain.dto.CommonDelIntDTO;
import com.zksy.szpt.domain.dto.SzptClockInDTO;
import com.zksy.szpt.domain.dto.SzptClockInQueryDTO;
import com.zksy.szpt.service.SzptClockInService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


@Api(tags = "边缘性场所、娱乐场所、旅馆酒店从业人员打卡")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptClockInController {
    private final SzptClockInService szptClockInService;
    public SzptClockInController(SzptClockInService szptClockInService) {
        this.szptClockInService = szptClockInService;
    }

    @ApiOperation(value="查询边缘性场所、娱乐场所、旅馆酒店从业人员打卡数据")
    @PostMapping("/querySzptClockIn")
    public PageInfo<SzptClockInBO> querySzptClockIn(@RequestBody @Validated SzptClockInQueryDTO szptClockInQueryDTO){
        return szptClockInService.querySzptClockIn(szptClockInQueryDTO);
    }

    @ApiOperation(value="新增边缘性场所、娱乐场所、旅馆酒店从业人员打卡数据")
    @PostMapping("/addSzptClockIn")
    public Integer addSzptClockIn(@RequestBody @Validated SzptClockInDTO szptClockInDTO){
        return szptClockInService.addSzptClockIn(szptClockInDTO);
    }

    @ApiOperation(value="编辑边缘性场所、娱乐场所、旅馆酒店从业人员打卡数据")
    @PostMapping("/updateSzptClockIn")
    public Integer updateSzptClockIn(@RequestBody @Validated SzptClockInDTO szptClockInDTO){
        return szptClockInService.updateSzptClockIn(szptClockInDTO);
    }

    @ApiOperation(value = "删除边缘性场所、娱乐场所、旅馆酒店从业人员打卡数据")
    @PostMapping("/deleteSzptClockIn")
    public Integer deleteSzptClockIn(@RequestBody CommonDelIntDTO commonDelIntDTO) {
        return szptClockInService.deleteSzptClockIn(commonDelIntDTO);
    }


}
