package com.zksy.szpt.util;

import java.util.regex.Pattern;

public class RedisKeyValidator {
    private static final String INVALID_CHARACTERS = "[\\x00\\x20\\x0A\\x0D\\x09]";  // 常见的无效字符

    public static boolean isValidKey(String key) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        return !key.matches(INVALID_CHARACTERS);
    }

    /**
     *
     * @param str
     * @return
     */
    public static boolean isValidString(String str) {
        // 定义正则表达式，匹配字母、数字和下划线
        String regex = "\\w+";
        return Pattern.matches(regex, str);
    }

    /**
     * 检查是否为有效的秒级时间戳
     * @param timestamp
     * @return
     */
    public static boolean isValidTimestamp(String timestamp) {
        // 检查是否为数字
        if (!timestamp.matches("\\d+")) {
            return false;
        }
        // 检查长度是否为10位（秒）
        return timestamp.length() == 10;
    }

}
