package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.service.XxZhxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "账号信息服务")
@RequestMapping("/rest/xxZhxx")
@RestController
@Validated
public class XxZhxxController {
    private final XxZhxxService service;

    public XxZhxxController(XxZhxxService service) {
        this.service = service;
    }

    @ApiOperation(value = "新增账号信息数据")
    @PostMapping("/add")
    public Integer addXxZhxx(@RequestBody @Validated XxZhxxDTO xxZhxxDTO) {
        return service.addXxZhxx(xxZhxxDTO);
    }

    @ApiOperation(value = "修改账号信息数据")
    @PostMapping("/update")
    public Integer update(@RequestBody @Validated XxZhxxDTO dto) {
        return service.update(dto);
    }


    @ApiOperation(value = "删除账号信息数据")
    @PostMapping("/delete")
    public Integer delete(@RequestParam(name = "zhid") String zhid) {
        return service.delete(zhid);
    }

}
