package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelParamDTO;
import com.zksy.szpt.domain.dto.XxYjdwdmDTO;
import com.zksy.szpt.domain.po.XxYjdwdm;
import com.zksy.szpt.mapper.XxYjdwdmMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class XxYjdwdmService {

    @Resource
    private XxYjdwdmMapper xxYjdwdmMapper;

    public Integer addXxYjdwdm(XxYjdwdmDTO dto) {
        XxYjdwdm xxYjdwdm = BeanMapperUtil.map(dto, XxYjdwdm.class);
        return xxYjdwdmMapper.insert(xxYjdwdm);
    }

    public Integer update(XxYjdwdmDTO dto) {
        XxYjdwdm xxYjdwdm = BeanMapperUtil.map(dto, XxYjdwdm.class);
        LambdaUpdateWrapper<XxYjdwdm> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(XxYjdwdm::getId, xxYjdwdm.getId());
        return xxYjdwdmMapper.update(xxYjdwdm,wrapper);
    }


    public Integer delete(CommonDelParamDTO dto) {
        LambdaQueryWrapper<XxYjdwdm> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(XxYjdwdm::getId, dto.getIds());
        return xxYjdwdmMapper.delete(wrapper);
    }
}
