package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptXyzhMbdhDTO;
import com.zksy.szpt.service.SzptXyzhMbdhService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "考勤情况")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptXyzhMbdhController {
    private final SzptXyzhMbdhService szptXyzhMbdhService;
    public SzptXyzhMbdhController(SzptXyzhMbdhService szptXyzhMbdhService) {
        this.szptXyzhMbdhService = szptXyzhMbdhService;
    }

    @ApiOperation(value="新增考勤情况")
    @PostMapping("/addSzptXyzhMbdh")
    public Integer addSzptXyzhMbdh(@RequestBody @Validated SzptXyzhMbdhDTO szptXyzhMbdhDTO){
        return szptXyzhMbdhService.addSzptXyzhMbdh(szptXyzhMbdhDTO);
    }

    @ApiOperation(value="编辑考勤情况")
    @PostMapping("/updateSzptXyzhMbdh")
    public Integer updateSzptXyzhKqmb(@RequestBody @Validated SzptXyzhMbdhDTO szptXyzhMbdhDTO){
        return szptXyzhMbdhService.updateSzptXyzhMbdh(szptXyzhMbdhDTO);
    }

    @ApiOperation(value = "删除考勤情况")
    @PostMapping("/deleteSzptXyzhMbdh")
    public Integer deleteSzptXyzhMbdh(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptXyzhMbdhService.deleteSzptXyzhMbdh(commonDelDTO);
    }
}
