package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.CommonDelIntDTO;
import com.zksy.szpt.domain.dto.SzptXyzhXyxxDTO;
import com.zksy.szpt.service.SzptXyzhXyxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "校园信息")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptXyzhXyxxController {
    private final SzptXyzhXyxxService szptXyzhXyxxService;
    public SzptXyzhXyxxController(SzptXyzhXyxxService szptXyzhXyxxService) {
        this.szptXyzhXyxxService = szptXyzhXyxxService;
    }

    @ApiOperation(value="新增校园信息")
    @PostMapping("/addSzptXyzhXyxx")
    public Integer addSzptXyzhXyxx(@RequestBody @Validated SzptXyzhXyxxDTO szptXyzhXyxxDTO){
        return szptXyzhXyxxService.addSzptXyzhXyxx(szptXyzhXyxxDTO);
    }

    @ApiOperation(value="编辑校园信息")
    @PostMapping("/updateSzptXyzhXyxx")
    public Integer updateSzptXyzhXyxx(@RequestBody @Validated SzptXyzhXyxxDTO szptXyzhXyxxDTO){
        return szptXyzhXyxxService.updateSzptXyzhXyxx(szptXyzhXyxxDTO);
    }

    @ApiOperation(value = "删除校园信息")
    @PostMapping("/deleteSzptXyzhXyxx")
    public Integer deleteSzptXyzhXyxx(@RequestBody @Validated CommonDelIntDTO commonDelIntDTO) {
        return szptXyzhXyxxService.deleteSzptXyzhXyxx(commonDelIntDTO);
    }
}
