package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptGdYjDTO;
import com.zksy.szpt.service.SzptGdYjService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "工地预警流水表")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptGdYjController {

    private final SzptGdYjService szptGdYjService;

    public SzptGdYjController(SzptGdYjService szptGdYjService) {
        this.szptGdYjService = szptGdYjService;
    }

    @ApiOperation(value="新增工地预警流水表")
    @PostMapping("/addSzptGdYj")
    public Integer addSzptGdYj(@RequestBody @Validated SzptGdYjDTO szptGdYjDTO){
        return szptGdYjService.addSzptGdYj(szptGdYjDTO);
    }

    @ApiOperation(value="编辑工地预警流水表")
    @PostMapping("/updateSzptGdYj")
    public Integer updateSzptGdYj(@RequestBody @Validated SzptGdYjDTO szptGdYjDTO){
        return szptGdYjService.updateSzptGdYj(szptGdYjDTO);
    }

    @ApiOperation(value = "删除工地预警流水表")
    @PostMapping("/deleteSzptGdYj")
    public Integer deleteSzptGdYj(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptGdYjService.deleteSzptGdYj(commonDelDTO);
    }
}
