package com.zksy.szpt.service;

import com.zksy.szpt.domain.dto.SzptClockInDTO;
import com.zksy.szpt.domain.dto.SzptClockInRulesDTO;
import com.zksy.szpt.domain.dto.SzptFwxxDTO;
import com.zksy.szpt.domain.dto.XxRwwcqkDTO;
import com.zksy.szpt.domain.po.SzptClockIn;
import com.zksy.szpt.domain.po.SzptClockInRules;
import com.zksy.szpt.domain.po.SzptFwxx;
import com.zksy.szpt.domain.po.XxRwwcqk;
import com.zksy.szpt.mapper.SzptClockInMapper;
import com.zksy.szpt.mapper.SzptClockInRulesMapper;
import com.zksy.szpt.mapper.SzptFwxxMapper;
import com.zksy.szpt.mapper.XxRwwcqkMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class IndexService {

    @Resource
    private XxRwwcqkMapper xxRwwcqkMapper;

    public Integer addXxRwwcqk(XxRwwcqkDTO xxRwwcqkDTO) {
        XxRwwcqk xxRwwcqk = BeanMapperUtil.map(xxRwwcqkDTO, XxRwwcqk.class);
        return xxRwwcqkMapper.insert(xxRwwcqk);
    }

    @Resource
    private SzptClockInMapper szptClockInMapper;
    public Integer addSzptClockIn(SzptClockInDTO szptClockInDTO){
        SzptClockIn szptClockIn = BeanMapperUtil.map(szptClockInDTO,SzptClockIn.class);
        return szptClockInMapper.insert(szptClockIn);
    }

    @Resource
    private SzptClockInRulesMapper szptClockInRulesMapper;
    public Integer addSzptClockInRules(SzptClockInRulesDTO szptClockInRulesDTO){
        SzptClockInRules szptClockInRules = BeanMapperUtil.map(szptClockInRulesDTO,SzptClockInRules.class);
        return szptClockInRulesMapper.insert(szptClockInRules);
    }

    @Resource
    private SzptFwxxMapper szptFwxxMapper;
    public Integer addSzptFwxx(SzptFwxxDTO szptFwxxDTO){
        SzptFwxx szptFwxx = BeanMapperUtil.map(szptFwxxDTO,SzptFwxx.class);
        return szptFwxxMapper.insert(szptFwxx);
    }
}
