package com.zksy.szpt.controller;

import com.zksy.szpt.domain.UploadImageDTO;
import com.zksy.szpt.service.ImageUploadService;
import io.swagger.annotations.Api;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "文件上传管理")
@RequestMapping("/rest/image")
@RestController
public class ImageUploadController {

    private final ImageUploadService imageUploadService;

    public ImageUploadController(ImageUploadService imageUploadService) {
        this.imageUploadService = imageUploadService;
    }

    @PostMapping("/upload")
    public Integer upload(@RequestBody @Validated UploadImageDTO uploadImageDTO) {
        return imageUploadService.upload(uploadImageDTO);
    }
}
