package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptXyzhDkxxDTO;
import com.zksy.szpt.domain.dto.SzptXyzhKqmbDTO;
import com.zksy.szpt.domain.po.SzptXyzhDkxx;
import com.zksy.szpt.domain.po.SzptXyzhKqmb;
import com.zksy.szpt.mapper.SzptXyzhKqmbMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptXyzhKqmbService {
    @Resource
    private SzptXyzhKqmbMapper szptXyzhKqmbMapper;

    public Integer addSzptXyzhKqmb(SzptXyzhKqmbDTO szptXyzhKqmbDTO) {
        SzptXyzhKqmb szptXyzhKqmb = BeanMapperUtil.map(szptXyzhKqmbDTO, SzptXyzhKqmb.class);
        return szptXyzhKqmbMapper.insert(szptXyzhKqmb);
    }

    public Integer updateSzptXyzhKqmb(SzptXyzhKqmbDTO szptXyzhKqmbDTO) {
        SzptXyzhKqmb szptXyzhKqmb = BeanMapperUtil.map(szptXyzhKqmbDTO, SzptXyzhKqmb.class);
        LambdaUpdateWrapper<SzptXyzhKqmb> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptXyzhKqmb::getId, szptXyzhKqmb.getId());
        return szptXyzhKqmbMapper.update(szptXyzhKqmb,wrapper);
    }

    public Integer deleteSzptXyzhKqmb(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptXyzhKqmb> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptXyzhKqmb::getId, commonDelDTO);
        return szptXyzhKqmbMapper.delete(wrapper);
    }
}
