package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptGdRyxxDTO;
import com.zksy.szpt.service.SzptGdRyxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptGdRyxxController {
    private final SzptGdRyxxService szptGdRyxxService;

    public SzptGdRyxxController(SzptGdRyxxService szptGdRyxxService) {
        this.szptGdRyxxService = szptGdRyxxService;
    }

    @ApiOperation(value="新增工地人员信息数据")
    @PostMapping("/addSzptGdRyxx")
    public Integer addSzptGdRyxx(@RequestBody @Validated SzptGdRyxxDTO szptGdRyxxDTO){
        return szptGdRyxxService.addSzptGdRyxx(szptGdRyxxDTO);
    }

    @ApiOperation(value="编辑工地人员信息数据")
    @PostMapping("/updateSzptGdRyxx")
    public Integer updateSzptGdRyxx(@RequestBody @Validated SzptGdRyxxDTO szptGdRyxxDTO){
        return szptGdRyxxService.updateSzptGdRyxx(szptGdRyxxDTO);
    }

    @ApiOperation(value = "删除工地人员信息数据")
    @PostMapping("/deleteSzptGdRyxx")
    public Integer deleteSzptGdRyxx(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptGdRyxxService.deleteSzptGdRyxx(commonDelDTO);
    }
}
