import {sbczTemplate} from "./components/sbkz.js";
//故障上报

$(function() {
    const router = new VueRouter({
        routes: [
            {
                path: ' ',
                redirect: 'ssdt',
            },
            {
                path: '/ssdt',
                name: 'ssdt',
                component: sbczTemplate,
            },
            {
                path: '/ssdt1',
                name: 'ssdt',
                component: sbczTemplate,
            },
        ]
    });
    var vm = new Vue({
        router,
        data: {
            seleted: '1010',
            menuList: [
                {
                    menuName: "生产车间",
                    menuUrl: "/ssdt",
                    id:'1000',
                    childMenus: [
                        { menuName: "重点人员离开检测", menuUrl: "/ssdt", parentid:'1000',  id:'1010',lebeltext:"人员离岗"},
                        { menuName: "车间通道人员聚集检测", menuUrl: "/ssdt1",parentid:'1000',  id:'1020',lebeltext:"人员聚集" }
                    ]
                },
                {
                    menuName: "监室",
                    menuUrl: "/ssdt",
                    id:'2000',
                    childMenus: [
                        { menuName: "重点人员离开检测", menuUrl: "/ssdt" ,parentid:'2000',  id:'2010',lebeltext:"人员离岗" },
                        { menuName: "人员攀高", menuUrl: "/ssdt" ,parentid:'2000',  id:'2020',lebeltext:"攀高检测"},
                        { menuName: "人员倒地", menuUrl: "/ssdt" ,parentid:'2000',  id:'2030',lebeltext:"倒地检测"},
                    ]
                },
                {
                    menuName: "监区通道",
                    menuUrl: "/ssdt",
                    id:'3000',
                    childMenus: [
                        { menuName: "定时巡更检测", menuUrl: "/ssdt" ,parentid:'3000', id:'3010',lebeltext:"人员靠近"},
                    ]
                },
                {
                    menuName: "周界围墙",
                    menuUrl: "/ssdt",
                    id:'4000',
                    childMenus: [{ menuName: "人员靠近检测", menuUrl: "/ssdt",parentid:'4000' , id:'4010',lebeltext:"人员靠近"}]
                }
            ],
            currentDate: moment()
        },
        methods: {
            routerTo(item) {
                this.seleted=item.id;
                // if (router.path !== item.menuUrl) {
                    // router.push(item.menuUrl);
                    // this.$router.push({
                    //     name: 'ssdt',
                    //     params: {
                    //         page: '1', code: '8989'
                    //     }
                    // })
                this.$router.push({
                    path: item.menuUrl,
                    query: {
                        lebeltext: item.lebeltext, id: item.parentid
                    }
                })
                // }

            }
        },
        mounted() {
            let _this = this;
            setInterval(() => {
                _this.currentDate = moment();
            }, 1000);
        },
        created(){
        }
    }).$mount('#bodydiv');
});


