package im.zksy.yjmqserver.system.service;

import com.github.pagehelper.PageHelper;
import im.zksy.yjmqserver.system.mapper.VideoMapper;
import im.zksy.yjmqserver.system.model.Video;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class VideoService {

    @Resource
    private VideoMapper videoMapper;

    /**
     * 根据父 ID 获取所有部门下的监控信息
     */
    public List<Video> selectByMutiParam(int page, int  rows,String videoName) {
        PageHelper.startPage(page, rows);
        return videoMapper.selectByMutiParam(videoName);
    }

    @Transactional
    public Integer add(Video video) {
        return videoMapper.insert(video);
    }


    @Transactional
    public void delete(String  id) {
        videoMapper.delete(id);
    }


    public void update(Video video) {
        videoMapper.updateByPrimaryKey(video);
    }
}