package im.zksy.yjmqserver.system.service;

import com.github.pagehelper.PageHelper;
import im.zksy.yjmqserver.system.mapper.CodeMapper;
import im.zksy.yjmqserver.system.model.Code;
import im.zksy.yjmqserver.system.model.CodeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class CodeService {

    private static final Logger log = LoggerFactory.getLogger(CodeService.class);

    @Resource
    private CodeMapper codeMapper;


    public List<Code> selectAllWithKey(int page, int rows) {
        PageHelper.startPage(page, rows);
        return codeMapper.selectAllWithKey();
    }

    public int updatecode(List<Code>  code){
        return codeMapper.updatecode(code);
    }


    public int updatetime(List<Code>  code){
        return codeMapper.updatetime(code);
    }
    public List<Code> selectAllWithType(String typeid) {
        return codeMapper.selectAllWithType(typeid);
    }


    public boolean disableCodeByCodeID(String codeid) {
//        offlineByUserId(id); // 加上这段代码, 禁用用户后, 会将当前在线的用户立即踢出.
        return codeMapper.updateNameByCodeID(codeid, "0") == 1;
    }

    public boolean enableCodeByCodeID(String codeid) {
        return codeMapper.updateNameByCodeID(codeid, "1") == 1;
    }

    public boolean updatemanualcode(String name,String alarmlevel) {
        return codeMapper.updatemanualcode(name, alarmlevel) == 1;
    }

    public  List<CodeData>  selectCodeByCodeId(String  codeid, String level){

        return codeMapper.selectCodeByCodeId(codeid, level);
    }

}