package im.zksy.yjmqserver.system.controller;

import im.zksy.yjmqserver.common.shiro.ShiroActionProperties;
import im.zksy.yjmqserver.common.util.ResultBean;
import im.zksy.yjmqserver.common.util.TreeUtil;
import im.zksy.yjmqserver.system.model.Dept;
import im.zksy.yjmqserver.system.service.DeptService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/dept")
public class DeptController {

    @Resource
    private DeptService deptService;

    @Resource
    private ShiroActionProperties shiroActionProperties;

    @Value("${managername}")
    private String managername;



    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @GetMapping("/index")
    public String index() {
        return "dept/dept-list";
    }

    /**
     * LoginController
     * @param parentId
     * @return
     */
    @GetMapping("/list")
    @ResponseBody
    public ResultBean getList(@RequestParam(value="parentId",required = false) Integer parentId) {
        List<Dept> deptList = deptService.selectByParentId(parentId);
        return ResultBean.success(deptList);
    }

    @GetMapping("/tree/root")
    @ResponseBody
    public ResultBean treeAndRoot() {
        return ResultBean.success(deptService.selectAllTreeAndRoot());
    }

    @GetMapping("/tree")
    @ResponseBody
    public ResultBean tree() {
        return ResultBean.success(deptService.selectAllTree());
    }

    @GetMapping
    public String add() {
        return "dept/dept-add";
    }


    @ResponseBody
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultBean add(Dept dept) {

        dept.setCreateTime(sdf.format(new Date()));
        dept.setModifyTime(dept.getCreateTime());
        return ResultBean.success(deptService.insert(dept));
    }


    @DeleteMapping("/{deptId}")
    @ResponseBody
    public ResultBean delete(@PathVariable("deptId") Integer deptId) {
        deptService.deleteCascadeByID(deptId);
        return ResultBean.success();
    }


    @ResponseBody
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultBean update(Dept dept) {
        dept.setModifyTime(sdf.format(new Date()));
        deptService.updateByPrimaryKey(dept);
        return ResultBean.success();
    }

    @GetMapping("/{deptId}")
    public ResultBean update(@PathVariable("deptId") String deptId) {
        List<Map> dept = deptService.selectByPrimaryKey(deptId);
        return ResultBean.success(dept);
    }


    @GetMapping("/getDeptParent/{deptId}")
    @ResponseBody
    public ResultBean getDeptParent(@PathVariable("deptId") String deptId) {
        List<Map> dept = deptService.selectByPrimaryKey(deptId);
        return ResultBean.success(dept);
    }

    /**
     * 新增部门
     * @param currentId
     * @param swapId
     * @return
     */
    @PostMapping("/swap")
    @ResponseBody
    public ResultBean swapSort(Integer currentId, Integer swapId) {
        deptService.swapSort(currentId, swapId);
        return ResultBean.success();
    }

    /***
     * 查询部门及其子節點
     * @param deptId
     * @param username
     * @return
     */

    @GetMapping("/listChildDept")
    @ResponseBody
    public ResultBean listChildDept( @RequestParam("deptId") Integer  deptId,@RequestParam("username") String username) {
        if (null!=username && (shiroActionProperties.getSuperAdminUsername().equals(username)
        ||username.equalsIgnoreCase(managername))) {
            deptId =0;
            username=null;
        }
        List<Dept> deptlist=deptService.selectDeptChildren(deptId, username);
      return ResultBean.success(deptlist);
    }

    @GetMapping("/listAllvideoIdsByDeptid")
    @ResponseBody
    public ResultBean listAllvideoIdsByDeptid(@RequestParam("deptid") String deptid) {

        List<Map> deptList = deptService.listAllvideoIdsByDeptid(deptid);
        return ResultBean.success(deptList);
    }



}
