package im.zksy.yjmqserver.common.util;


import com.sun.org.apache.xpath.internal.operations.Bool;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 时间工具类
 */
public class DateUtils extends org.apache.commons.lang3.time.DateUtils {
    public static String YYYY = "yyyy";

    public static String YYYY_MM = "yyyy-MM";

    public static final String YYYY_MM_DD = "yyyy-MM-dd";

    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    private static final String[] parsePatterns = {
            "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM",
            "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM",
            "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    private static final String format = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> threadLocal = new
             ThreadLocal<>();
    /**
     * 获取当前Date型日期
     *
     * @return Date() 当前日期
     */
    public static Date getNowDate() {
        return new Date();
    }

    /**
     * 获取当前日期, 默认格式为yyyy-MM-dd
     *
     * @return 日期格式化字符串
     */
    public static String getDate() {
        return dateTimeNow(YYYY_MM_DD);
    }

    public static String getTime() {
        return dateTimeNow(YYYY_MM_DD_HH_MM_SS);
    }

    public static String dateTimeNow() {
        return dateTimeNow(YYYYMMDDHHMMSS);
    }

    public static String dateTimeNow(final String format) {
        return parseDateToStr(format, new Date());
    }

    public static String dateTime(final Date date) {
        return parseDateToStr(YYYY_MM_DD, date);
    }

    public static String parseDateToStr(final String format, final Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    /**
     * 日期路径 即年/月/日 如2018/08/08
     */
    public static String datePath() {
        Date now = new Date();
        return DateFormatUtils.format(now, "yyyy/MM/dd");
    }

    /**
     * 日期路径 即年/月/日 如20180808
     */
    public static String dateTime() {
        Date now = new Date();
        return DateFormatUtils.format(now, "yyyyMMdd");
    }

    /**
     * 日期型字符串转化为日期 格式
     */
    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return parseDate(str.toString(), parsePatterns);
        } catch (ParseException e) {
            return null;
        }
    }


    /**
     * 计算两个时间差
     */
    public static long getDatePoor(Date endDate, Date nowDate) {
        long nd = 1000 * 24 * 60 * 60;
        long nh = 1000 * 60 * 60;
        long nm = 1000 * 60;
        // long ns = 1000;
        // 获得两个时间的毫秒时间差异
        long diff = endDate.getTime() - nowDate.getTime();
        // 计算差多少天
        long day = diff / nd;
        // 计算差多少小时
        long hour = diff % nd / nh;
        // 计算差多少分钟
        long min = diff % nd % nh / nm;
        // 计算差多少秒//输出结果
        // long sec = diff % nd % nh % nm / ns;
        return day;
    }

    public static String getEndTimestamp(Integer day,String date) {
            SimpleDateFormat sdf = null;
            sdf = threadLocal.get();
            if (sdf == null){
                     sdf = new SimpleDateFormat(format);
             }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parseDate(date));
            calendar.set(Calendar.HOUR_OF_DAY, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
            calendar.add(Calendar.DAY_OF_MONTH, day);
            Date start = calendar.getTime();
            Timestamp timestamp = new Timestamp(start.getTime());
            return sdf.format(timestamp.getTime());
    }




    public static String getYestodayTimestamp(Integer day,String date) {
            SimpleDateFormat sdf = null;
            sdf = threadLocal.get();
            if (sdf == null){
                sdf = new SimpleDateFormat(format);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parseDate(date));
            calendar.add(Calendar.DAY_OF_MONTH, day);
            Date start = calendar.getTime();
            Timestamp timestamp = new Timestamp(start.getTime());
            return sdf.format(timestamp.getTime());
    }
    public static String getLastMinTime(Date newDate, Integer miniuts, String  year,Integer yearvalue) {
        SimpleDateFormat sdf = null;
        sdf = threadLocal.get();
        if (sdf == null){
            sdf = new SimpleDateFormat(format);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(newDate);//设置起时间
        if(year.equals("year"))
            cal.add(Calendar.YEAR, yearvalue);
        else if(year.equals("month")){
            cal.add(Calendar.MONTH, yearvalue);
        }
        else if(year.equals("day")){
            cal.add(Calendar.DAY_OF_MONTH, yearvalue);
        }
        cal.add(Calendar.MINUTE, miniuts);
        return  sdf.format(cal.getTime());
    }
    public static String getlastYearTime(Date newDate,Integer year) {
        SimpleDateFormat sdf = null;
        sdf = threadLocal.get();
        if (sdf == null){
            sdf = new SimpleDateFormat(format);
        }
        Calendar cal =  Calendar.getInstance();
        cal.setTime(newDate);//设置起时间
        cal.add(Calendar.YEAR, year);
        return  sdf.format(cal.getTime());
    }

    public static String getlastMonthTime(Date newDate,Integer month) {
        SimpleDateFormat sdf = null;
        sdf = threadLocal.get();
        if (sdf == null){
            sdf = new SimpleDateFormat(format);
        }
        Calendar cal= Calendar.getInstance();
        cal.setTime(newDate);//设置起时间
        cal.add(Calendar.MONTH, month);
        return  sdf.format(cal.getTime());
    }
    public static String getlastMonthTimeY_M_D(Date newDate,Integer month) {
        SimpleDateFormat sdf = null;
        sdf = threadLocal.get();
        if (sdf == null){
            sdf = new SimpleDateFormat(YYYY_MM_DD);
        }
        Calendar cal= Calendar.getInstance();
        cal.setTime(newDate);//设置起时间
        cal.add(Calendar.MONTH, month);
        return  sdf.format(cal.getTime());
    }

    public static Date getMonthTimeY_M_D(Date newDate,Integer month) {
        SimpleDateFormat sdf = null;
        sdf = threadLocal.get();
        if (sdf == null){
            sdf = new SimpleDateFormat(YYYY_MM_DD);
        }
        Calendar cal= Calendar.getInstance();
        cal.setTime(newDate);//设置起时间
        cal.add(Calendar.MONTH, month);
        return  cal.getTime();
    }

    public static String getlastDayTime(Date newDate,Integer day) {
        SimpleDateFormat sdf = null;
        sdf = threadLocal.get();
        if (sdf == null){
            sdf = new SimpleDateFormat(format);
        }
        Calendar cal= Calendar.getInstance();
        cal.setTime(newDate);//设置起时间
        cal.add(Calendar.DAY_OF_MONTH, day);
        return  sdf.format(cal.getTime());
    }
    public static String getlastDayTimeY_M_D(Date newDate,Integer day) {
        SimpleDateFormat sdf = null;
        sdf = threadLocal.get();
        if (sdf == null){
            sdf = new SimpleDateFormat(YYYY_MM_DD);
        }
        Calendar cal= Calendar.getInstance();
        cal.setTime(newDate);//设置起时间
        cal.add(Calendar.DAY_OF_MONTH, day);
        return  sdf.format(cal.getTime());
    }
    public static boolean TheSameDay(Date d1,Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        return (c1.get(Calendar.YEAR) == c2.get(Calendar.YEAR))
                && (c1.get(Calendar.MONTH) == c2.get(Calendar.MONTH))
                && (c1.get(Calendar.DAY_OF_MONTH) == c2.get(Calendar.DAY_OF_MONTH));
    }
}