package im.zksy.yjmqserver.common.util;


import im.zksy.yjmqserver.system.model.ResultInfo;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class CommonUtil {



    /**************************************正常的result自定义 的*************************************************/

    /**
     * 请求成功时返回结果
     * @param data
     * @param code
     * @param msg
     * @param flag
     * @return
     */
    public static ResultInfo getResultInfoOk(Object data, Integer code, String msg, boolean flag){
        ResultInfo resultInfo = new ResultInfo(code, msg, data, flag);
        return resultInfo;
    }

    public static ResultInfo getResultInfoOk(Object data, Integer code, String msg){
        ResultInfo resultInfo = new ResultInfo(code, msg, data, true);
        return resultInfo;
    }

    public static ResultInfo getResultInfoOk(Object data, boolean flag){
        ResultInfo resultInfo = new ResultInfo(200, "", data, flag);
        return resultInfo;
    }

    public static ResultInfo getResultInfoOk(Object data){
        ResultInfo resultInfo = new ResultInfo(200, "", data, true);
        return resultInfo;
    }

    /**
     * 请求失败时返回结果
     * @param data
     * @param code
     * @param msg
     * @return
     */
    public static ResultInfo getResultInfoFailed(Object data, Integer code, String msg){
        ResultInfo resultInfo = new ResultInfo(code, msg, data, false);
        return resultInfo;
    }


    /**
     * 得到随机数来做id
     * @return
     */
    public static String getUUID(){
        int length = 8;
        String val = "";
        Random random = new Random();
        //参数length，表示生成几位随机数
        for(int i = 0; i < length; i++) {
            String charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            //输出字母还是数字
            if( "char".equalsIgnoreCase(charOrNum) ) {
                //输出是大写字母还是小写字母
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val += (char)(random.nextInt(26) + temp);
            } else if( "num".equalsIgnoreCase(charOrNum) ) {
                val += String.valueOf(random.nextInt(10));
            }
        }
        long millis = System.currentTimeMillis();
        return millis+val;
    }

    /*求余取整*/
    public static int getNum(int num,int size){
        int a=num/size;
        int b=num%size;
        if(b==0){
            return a;
        }else{
            return a+1;
        }
    }
    /*
     * 传入String类型日期（yyyy-MM-dd HH:mm:ss）
     *
     * */
    public static String dateStrToISO8601(String dateStr){
        SimpleDateFormat dtf=new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            Date date=dtf.parse(dateStr);
            String pattern ="yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
            String dateISOStr= DateFormatUtils.format(date,pattern);
            return dateISOStr;
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }

    }



}
