package im.zksy.yjmqserver.system.listener;

import im.zksy.yjmqserver.system.mqtt.MQTTSubsribe;
import im.zksy.yjmqserver.system.mqtt.MyMqttRecieveMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.Arrays;


@Component
public class MyCommandLineRunner implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(MyCommandLineRunner.class);

    @Autowired
    MQTTSubsribe mqttsub;

    @Value("${spring.mqtt.topic}")
    private  String  topic;


    @Override
    public void run(String... strings) throws Exception {
        logger.info("系统启动后自动执行");
        if(null!=topic&& topic.split(",").length>0) {
            mqttsub.subscribe(Arrays.asList(topic.split(",")));
        }
    }
}
