package im.zksy.yjmqserver.system.mqtt;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import im.zksy.yjmqserver.common.util.CommonUtil;
import im.zksy.yjmqserver.common.util.DateUtil;
import im.zksy.yjmqserver.common.util.FTPUtils;
import im.zksy.yjmqserver.system.model.Alarm;
import im.zksy.yjmqserver.system.model.Data;
import im.zksy.yjmqserver.system.model.Picture;
import im.zksy.yjmqserver.system.service.AlarmService;
import im.zksy.yjmqserver.system.service.PictureService;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;


//@Component
public class MqttRecieveCallback implements MqttCallback {
    private static Logger log = LoggerFactory.getLogger(MqttRecieveCallback.class);
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private static MqttRecieveCallback mqtt;

    @Autowired
    private PictureService pictureService;

    @PostConstruct
    public void init() {
        mqtt = this;
        mqtt.alarmService = this.alarmService;
        mqtt.pictureService = this.pictureService;
    }

    @Override
    public void connectionLost(Throwable cause) {
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) {
        String str = message.toString();
        log.info(str.toString());
        try {
            Integer checkvalue = 1;
            Alarm alarm = new ObjectMapper().readValue(str, Alarm.class);
            if (alarm.getType().equals("0"))//type 指令类型：0：告警事件 1：边缘设备运行状态
            {
                Data alarmdata = alarm.getData();
//                if ((alarmdata.getLabel13() != null && alarmdata.getLabel13().equals(checkvalue))//人脸考勤
//                        || (alarmdata.getLabel14() != null && alarmdata.getLabel14().equals(checkvalue))//陌生人
//                        || (alarmdata.getLabel18() != null && alarmdata.getLabel18().equals(checkvalue))//行人跟踪
//                        || (alarmdata.getLabel19() != null && alarmdata.getLabel19().equals(checkvalue))//倒地检测
//                        || (alarmdata.getLabel20() != null && alarmdata.getLabel20().equals(checkvalue))//行人检测
//                        || (alarmdata.getLabel49() != null && alarmdata.getLabel49().equals(checkvalue))//人员离岗
//                        || (alarmdata.getLabel50() != null && alarmdata.getLabel50().equals(checkvalue))//人员聚集
//                        || (alarmdata.getLabel51() != null && alarmdata.getLabel51().equals(checkvalue))//攀高检测
//                ) {

                    String checkJpg = alarmdata.getCheckJpg();
                    String path = DateUtil.getDateStringNoSign(new Date());
                    String picid = CommonUtil.getUUID() + ".jpg";
                    alarm.getData().setCheckJpg(path + "/" + picid);
                    //labeltext
                    List<String> list=alarm.getData().getLabel_text();
                    List<String>  list_normal = list.stream()
                            .filter(b -> b.indexOf("人脸考勤")<0 && b.indexOf("陌生人")<0 && b.indexOf("行人跟踪")<0 && b.indexOf("行人检测")<0  )
                            .collect(Collectors.toList());
                    //过滤人员进行人员靠近数据替换
                    List<String>  list_rykj = list.stream()
                            .filter(b -> b.indexOf("人脸考勤")>=0 || b.indexOf("陌生人")>=0 || b.indexOf("行人跟踪")>=0 || b.indexOf("行人检测")>=0  )
                            .collect(Collectors.toList());
                    if(list_rykj.size()>0){
                        list_normal.add("人员靠近");
                    }
                    alarm.getData().setLabel_text(list_normal);
                    int alarmid = mqtt.alarmService.insert(alarm); //入表
                    //异步上传ftpconnectServer
                    FTPUtils util = new FTPUtils();
                    try {
                        Picture pic = new Picture();
                        pic.setId(alarm.getId());
                        pic.setImgpath(path + "/" + picid);
                        if (util.uploadFile(path, picid, checkJpg)) {
                            pic.setStatus("1");//成功
                        } else {
                            //记录入表.失败保留图片base64？
                            pic.setImg(checkJpg);
                            pic.setStatus("0");
                        }
                        mqtt.pictureService.insert(pic);
                    } catch (Exception ex) {
                        log.error(ex.toString());
                    }
                }
//            }

        } catch (Exception ex) {
            log.error(ex.toString());
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {

    }
}
