package im.zksy.yjmqserver.system.controller;

import com.github.pagehelper.PageInfo;
import im.zksy.yjmqserver.common.util.PageResultBean;
import im.zksy.yjmqserver.common.util.ResultBean;
import im.zksy.yjmqserver.system.model.Code;
import im.zksy.yjmqserver.system.model.CodeData;
import im.zksy.yjmqserver.system.service.CodeService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/code")
public class CodeController {


    @Resource
    private CodeService codeService;

    @GetMapping("/list")
    @ResponseBody
    public PageResultBean<Code> getList(@RequestParam(value = "page", defaultValue = "1") int page,
                                        @RequestParam(value = "limit", defaultValue = "10") int limit) {
        List<Code> codes = codeService.selectAllWithKey(page, limit);
        PageInfo<Code> userPageInfo = new PageInfo<>(codes);
        return new PageResultBean<>(userPageInfo.getTotal(), userPageInfo.getList());
    }

    @GetMapping("/list/{typeid}")
    @ResponseBody
    public ResultBean getList(@PathVariable("typeid") String typeid) {
        List<Code> codes = codeService.selectAllWithType(typeid);
        return ResultBean.success(codes);
    };


    @PostMapping("/update")
    public ResultBean update(@RequestBody List<Code> codelist) {

        int result = codeService.updatecode(codelist);
        return ResultBean.success();
    }



    @PostMapping("/updatetime")
    public ResultBean updatetime(@RequestBody List<Code> codelist) {

        int result = codeService.updatetime(codelist);
        return ResultBean.success();
    }

    @PostMapping("/{codeId}/disable")
    @ResponseBody
    public ResultBean disable(@PathVariable("codeId") String codeId) {
        return ResultBean.success(codeService.disableCodeByCodeID(codeId));
    }

    @PostMapping("/{codeId}/enable")
    @ResponseBody
    public ResultBean enable(@PathVariable("codeId") String codeId) {
        return ResultBean.success(codeService.enableCodeByCodeID(codeId));
    }


    @GetMapping("/listcode")
    @ResponseBody
    public ResultBean listcode(@RequestParam("codeid") String codeid,
                               @RequestParam("alarmlevel") String level
    ) {
        List<CodeData> deptList = codeService.selectCodeByCodeId(codeid, level);
        return ResultBean.success(deptList);
    }
}