package im.zksy.yjmqserver.system.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import im.zksy.yjmqserver.common.util.CommonUtil;
import im.zksy.yjmqserver.system.mapper.AlarmMapper;
import im.zksy.yjmqserver.system.model.Alarm;
import im.zksy.yjmqserver.system.model.AlarmInfo;
import im.zksy.yjmqserver.system.model.Params;
import im.zksy.yjmqserver.system.model.ResultInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AlarmService {
    @Autowired
    private AlarmMapper alarmMapper;

    public ResultInfo getAlarm(Params params) {
        if(params != null) {
            Integer page = params.getPageInfo().getPageNum();
            Integer count = params.getPageInfo().getPageSize();
            if (page != null && count != null) {
                PageHelper.startPage(page, count);
            }
        }
        List<AlarmInfo> list= alarmMapper.getAlarm(params);
        PageInfo pageInfo = new PageInfo(list);
        ResultInfo resultInfo = CommonUtil.getResultInfoOk(pageInfo);
        return resultInfo;
    }


    public int insert(Alarm alarmInfo) {
        return alarmMapper.insert(alarmInfo);

    }

    public int insertAlarm(AlarmInfo alarmInfo){
        return alarmMapper.insertAlarm(alarmInfo);
    }
}
