var sbczTemplate={
    data(){
        return {
            msg: "",
            dateTimes: [moment().add(-7, "d").format("YYYY-MM-DD HH:mm:ss"),moment().startOf('day').format("YYYY-MM-DD HH:mm:ss")],
            value: [],
            options: [
                {
                    value: "red",
                    label: "红色"
                },
                {
                    value: "yellow",
                    label: "黄色"
                }
            ],
            tableData: [],
            pageNum: 1,
            total: 0,
            loadingInstance:'',
            lebeltext: '',
            id: ''
        };
    },
    template:`<div class="hello">
    <el-container>
      <el-header>
        <el-row :gutter="20">
          <el-col :span="8">
            <span>选择日期:</span>
            <el-date-picker
              v-model="dateTimes"
              type="datetimerange"
              range-separator="至"
              start-placeholder="开始日期"
              end-placeholder="结束日期"
            >
            </el-date-picker>
          </el-col>
          <el-col :span="4">
            <el-button type="primary" @click="lookfor">搜索</el-button>
            <el-button type="success">重置</el-button>
          </el-col>

          <!-- <el-col :span="4">
            <el-radio-group v-model="radio1" size="mini">
              <el-radio-button label="Table"></el-radio-button>
              <el-radio-button label="Card"></el-radio-button>
            </el-radio-group>
          </el-col> -->
        </el-row>
      </el-header>
      <el-main>
        <el-row :gutter="20">
          <el-col :span="6" v-for="(item, index) in tableData" :key="index">
            <div class="card-item">
              <div class="card-item1">
                <div class="avatar">
                  <img :size="100" :src="'/alarm/api/alg/files/'+item.checkJpg">
                </div>
              </div>
              <div class="card-item2">
                <div> <el-button type="danger" size="mini" v-for="(item1 ,index2) in item.labels">{{item1}}</el-button></div>
                <div>{{item.device_name}}</div>
                <div>{{tranf(item.time_norm)}}</div>
              </div>
            </div>
          </el-col>
        </el-row>
      </el-main>
      <el-footer>
        <div class="pageInfo">
          <el-pagination
            background
            @current-change="handleCurrentChange"
            :current-page="pageNum"
            :page-size="10"
            layout="total, prev, pager, next, jumper"
            :total="total"
          >
          </el-pagination>
        </div>
      </el-footer>
    </el-container>
  </div>`,
    methods:{
        lookfor() {
            let _that=this;
            this.lebeltext = this.$route.query.lebeltext;
            this.id = this.$route.query.id;
            let kssj=new Date(this.dateTimes[0]).getTime();
            let jssj=new Date(this.dateTimes[1]).getTime();
            // this.loadingInstance = loadingOpen(this);
            post_jquery('alarm/getAlarm', {kssj:kssj,jssj:jssj,labelText:this.lebeltext,menuid:this.id,
                pageInfo:{pageNum:this.pageNum,pageSize:10}
            }, function (data, that) {
                // loadingClose(that.loadingInstance);
                var result = data;
                if(result.data!=null){
                    if(result.data.list.length==0){
                        _that.$message({
                            message: '无数据！',
                            type: 'warning'
                        });
                    }
                    that.tableData=result.data.list;
                    that.total=result.data.total;
                    that.tableData.forEach(function(item) {
                        let labels= JSON.parse(item.label_text);
                        item.labels=labels;
                    });
                }
            },this);
        },
        handleCurrentChange(val) {
            console.log(`当前页: ${val}`);
            this.pageNum = val;
            this.lookfor();
        },
        tranf(val){
           let dateStr= moment(Number(val)).format('YYYY-MM-DD HH:mm:ss');
           return dateStr;
        },
        tranT(item){
            let labels= JSON.parse(item.label_text);
            item.labels=labels;
        }
    },
    // created() {


    //     this.lookfor()
    // },
    mounted(){
        this.lookfor();
    },
    watch: {
        // 如果路由发生变化，再次执行该方法
        '$route': 'lookfor'
    }
};

export  {sbczTemplate};
