package im.zksy.yjmqserver.system.mapper;

import im.zksy.yjmqserver.system.model.Dept;
import im.zksy.yjmqserver.system.model.DeptTree;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface DeptMapper {

    int deleteByPrimaryKey(Integer deptId);

    int insert(Dept dept);

    int insertDeptTree(DeptTree dept);

    List<Map> selectByPrimaryKey(@Param("deptId")String deptId);

    DeptTree selectDeptTreeByPrimaryKey(Integer deptId);


    int updateByPrimaryKey(Dept dept);
    int updateDeptTreeByPrimaryKey(DeptTree dept);

    List<Dept> selectByParentId(@Param("parentId") Integer parentId);

    List<DeptTree> selectDeptTreeByParentId(@Param("parentId") Integer parentId);

    List<Dept> selectAllTree();

    List<Integer> selectChildrenIDByPrimaryKey(@Param("deptId") Integer deptId);

    int selectMaxOrderNum();

    int swapSort(@Param("currentId") Integer currentId, @Param("swapId") Integer swapId);


    List<Dept> selectDeptChildren(@Param("deptId") Integer deptId, @Param("username") String username);

    int updateDefaultVideoByDeptId(@Param("deptId") String deptId, @Param("videoId") String videoId);

    List<Map> selectDefaultVideoByDeptId(@Param("deptId") String deptId);

    List<Map> selectAllDefaultVideo(@Param("deptId") String deptId);
     int  selectExistsDefaultVideo(@Param("deptId") String deptId, @Param("videoId") String videoId);
    int  insertDefaultVideo(@Param("deptId") String deptId, @Param("videoId") String videoId);
    List<Map>  listAllvideoIdsByDeptid(@Param("deptId") String deptId);
}