package im.zksy.yjmqserver.system.controller;

import com.github.pagehelper.PageInfo;
import im.zksy.yjmqserver.common.util.CommonUtil;
import im.zksy.yjmqserver.common.util.PageResultBean;
import im.zksy.yjmqserver.common.util.ResultBean;
import im.zksy.yjmqserver.system.model.Video;
import im.zksy.yjmqserver.system.service.VideoService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@Controller
@RequestMapping("/video")
public class VideoController {

    @Resource
    private VideoService videoService;


    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /***
     * 根据deptId获取用户列表
     * @param page
     * @param pageSize
     * @param videoName
     * @return
     */
    @GetMapping("/list")
    @ResponseBody
    public PageResultBean<Video> getList(@RequestParam(value = "page", defaultValue = "1") int page,
                                        @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                        @RequestParam(value = "videoName") String videoName) {

        List<Video> videos = videoService.selectByMutiParam(page, pageSize,videoName);
        PageInfo<Video> userPageInfo = new PageInfo<>(videos);
        return new PageResultBean<Video>(userPageInfo.getTotal(), userPageInfo.getList());

    }

    @PostMapping("/add")
    @ResponseBody
    public ResultBean add(Video video) {
        video.setId(CommonUtil.getUUID().toString());
        video.setCreateTime(sdf.format(new Date()));
        video.setModifyTime(video.getCreateTime());
        return ResultBean.success(videoService.add(video));
    }

    @GetMapping("/delete/{Id}")
    @ResponseBody
    public ResultBean delete(@PathVariable("Id") String id) {
        videoService.delete(id);
        return ResultBean.success();
    }


    @PostMapping("/edit")
    @ResponseBody
    public ResultBean update(@Valid Video video) {
        video.setModifyTime(sdf.format(new Date()));
        videoService.update(video);
        return ResultBean.success();
    }

   }