var express = require('express');
var router = express.Router();
let request = require("request");
const co = require('co');
let Client= require('./lib/client');
require('../../util/string');
const model=require("../../util/model");
const config=require("../../application.json").artemis;
const client = new Client(config.appkey, config.appsecret);

router.get("/queryhls/:indexCode", function (req, res, next) {
    const indexCode=req.params.indexCode;
    co(function* () {
        var url = 'https://172.15.182.201:443/artemis/api/mss/v1/hls/{0}';
        var result = yield client.get(url.format(indexCode), {
            query: {
               
            },
            headers: {
                accept: 'application/json',
                'content-type': 'text/plain;charset=UTF-8'
            }
        });
        res.json({
            resultStatus: model.resultStatus.success,
            data: result
        });
    }).catch((error) => {
        //请求错误信息
        res.json({
            resultStatus: model.resultStatus.error(error.message),
            data: null
        });
    });
})

module.exports = router;