function postByAjax(url, data, callback) {
    fetch(url, {
        method: "POST",
        body: JSON.stringify(data),
        credentials: 'include',
        headers: new Headers({
            'Content-Type': 'application/json', // 指定提交方式为表单提交
            'x-requested-with': 'XMLHttpRequest'
        })
    }).then(res=> {
        return res.text();
    }).then(res=> {
        var model = JSON.parse(res);
        if (model.resultStatus.code == 200) {
            callback(model.data);
        } else {
            alert(model.resultStatus.msg);
        }
    });
}

function postByAjaxWithoutCookie(url, data, callback) {
    fetch(url, {
        method: "POST",
        body: JSON.stringify(data),
       // credentials: 'include',
        headers: new Headers({
            'Content-Type': 'application/json', // 指定提交方式为表单提交
            'x-requested-with': 'XMLHttpRequest'
        })
    }).then(res=> {
        return res.text();
    }).then(res=> {
        var model = JSON.parse(res);
        if (model.resultStatus.code == 200) {
            callback(model.data);
        } else {
            alert(model.resultStatus.msg);
        }
    });
}

function getByAjaxWithCode(url, callback){
    fetch(url, {
        method: "GET",
        credentials: 'include',
        headers: new Headers({
            'x-requested-with': 'XMLHttpRequest'
        })
    }).then(res=> {
        return res.text();
    }).then(res=> {
        var model = JSON.parse(res);
        if (model.code ==0) {
            callback(model);
        } else {
            alert(model.msg);
        }
    });

}

//生成guid
function uuid() {
    var s = [];
    var hexDigits = "0123456789abcdef";
    for (var i = 0; i < 36; i++) {
        s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
    }
    s[14] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
    s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01
    s[8] = s[13] = s[18] = s[23] = "-";

    var uuid = s.join("");
    return uuid;
}

function getByAjax(url, callback) {
    fetch(url, {
        method: "GET",
        credentials: 'include',
        headers: new Headers({
            'x-requested-with': 'XMLHttpRequest'
        })
    }).then(res=> {
        return res.text();
    }).then(res=> {
        var model = JSON.parse(res);
        if (model.resultStatus.code == 200) {
            callback(model.data);
        } else {
            alert(model.resultStatus.msg);
        }
    });
}

//筛选//////////////////////////////////////////////////////////////
String.prototype.strcontains=function(val){
    return  RegExp(val).test(this);
};

Array.prototype.remove = function (val) {
    var index = this.indexOf(val);
    if (index > -1) {
        this.splice(index, 1);
    }
};

Array.prototype.arrfindindex = function (obj, field) {
    if (!field) {
        return -1;
    }
    for (var j = 0; j < this.length; j++) {
        if (obj[field] == this[j][field]) {
            return j;
        }
    }
    return false;
};

//两个数组连接，同时去重//////////////////////////////////////////
Array.prototype.distinctconcat = function (arr, field) {
    if (!field) {
        return;
    }
    for (var i = 0; i < arr.length; i++) {
        if (!this.arrfind(arr[i], field))
            this.push(arr[i]);
    }
};
Array.prototype.arrfind = function (obj, field) {
    if (!field) {
        return false;
    }
    for (var j = 0; j < this.length; j++) {
        if (obj[field] == this[j][field]) {
            return true;
        }
    }
    return false;
};

//差集////////////////////////////////////////////////////////////////////
Array.prototype.diff = function(a) {
    return this.filter(function(i) {return a.indexOf(i) < 0;});
};

String.prototype.format = function(args) {
    var result = this;
    if (arguments.length > 0) {    
        if (arguments.length == 1 && typeof (args) == "object") {
            for (var key in args) {
                if(args[key]!=undefined){
                    var reg = new RegExp("({" + key + "})", "g");
                    result = result.replace(reg, args[key]);
                }
            }
        }
        else {
            for (var i = 0; i < arguments.length; i++) {
                if (arguments[i] != undefined&&arguments[i] != null) {
　　　　　 var reg= new RegExp("({)" + i + "(})", "g");
                    result = result.replace(reg, arguments[i]);
                }else{
                    var reg= new RegExp("('{)" + i + "(}')", "g");
                    result = result.replace(reg, null);
                }
            }
        }
    }
    return result;
};

//yyyy-MM-dd hh:mm:ss
Date.prototype.tocustomstring=function(){
    var year = this.getFullYear();       //年
    var month = this.getMonth() + 1;     //月
    var day = this.getDate();            //日

    var hh = this.getHours();            //时
    var mm = this.getMinutes();          //分
    var ss = this.getSeconds();           //秒

    var clock = year + "-";

    if(month < 10)
        clock += "0";

    clock += month + "-";

    if(day < 10)
        clock += "0";

    clock += day + " ";

    if(hh < 10)
        clock += "0";

    clock += hh + ":";
    if (mm < 10) clock += '0';
    clock += mm + ":";

    if (ss < 10) clock += '0';
    clock += ss;
    return(clock);
};

//yyyyMMdd
Date.prototype.toshortcustomstring=function(){
    var year = this.getFullYear();       //年
    var month = this.getMonth() + 1;     //月
    var day = this.getDate();            //日
    var clock = year + "";
    if(month < 10)
        clock += "0";
    clock += month + "";
    if(day < 10)
        clock += "0";
    clock += day + "";
    return(clock);
};

//浅拷贝
function shallowCopy(src) {
    var dst = {};
    for (var prop in src) {
        if (src.hasOwnProperty(prop)) {
            dst[prop] = src[prop];
        }
    }
    return dst;
}
//深拷贝
function deepCopy(obj1,obj2){
    var obj2=obj2||{}; //最初的时候给它一个初始值=它自己或者是一个json
    for(var name in obj1){
        if(typeof obj1[name] === "object"){ //先判断一下obj[name]是不是一个对象
            obj2[name]= (obj1[name].constructor===Array)?[]:{}; //我们让要复制的对象的name项=数组或者是json
            deepCopy(obj1[name],obj2[name]); //然后来无限调用函数自己 递归思想
        }else{
            obj2[name]=obj1[name];  //如果不是对象，直接等于即可，不会发生引用。
        }
    }
    return obj2; //然后在把复制好的对象给return出去
}

function getCookie(c_name) {
    if (document.cookie.length>0){
        var c_start=document.cookie.indexOf(c_name + "=");
        if (c_start!=-1){
            c_start=c_start + c_name.length+1;
            var c_end=document.cookie.indexOf(";",c_start);
            if (c_end==-1) c_end=document.cookie.length;
            return unescape(document.cookie.substring(c_start,c_end))
        }
    }
    return ""
}