var express = require('express');
var async = require('async');
var router = express.Router();
var command = require('../util/database');
var resultStatus = require('../util/model').resultStatus;
var zdry_orders = require('../application.json').order;


var connection = null;

///////////////////////////////////////////////////////////////////////////////////////////////////////////aop 执行前的权限控制和日志记录
router.use(function (req, res, next) {
  if (req.session.user.manager != "1") {
    res.json({
      resultStatus: resultStatus.noAuthority
    });
  } else {
    require("../util/log").logger.info(req.session.user.userid + req.originalUrl + "////////begin");
    if (req.originalUrl.indexOf("ByBatch") >= 0) {//批量导入的时候使用公用的从连接池获取的连接
      command.getConnectionFromPool(function (conn) {
        connection = conn;
        next();
      });
    } else {
      next();
    }
  }
});

//#region 监控
router.post('/monitordata/:type', function (req, res, next) {
  let type = req.params.type;
  let sqlstr = "";
  if (type == "2") {
    sqlstr = "update monitor t set t.name='{0}' ,t.x={1},t.y={2},t.angle={3},t.gridid='{4}',t.ip='{5}',t.url='{6}' where t.id='{7}'";
  } else if (type == "0") {
    sqlstr = "insert into monitor  values('{7}','{0}',{1},{2},{3},'{4}','{5}','{6}')";
  } else if (type == "1") {
    sqlstr = " delete from monitor where id='" + req.body.id + "'";
  }

  let x = req.body.x || "null";
  let y = req.body.y || "null";
  let angle = req.body.angle || "null";
  command.executesql(sqlstr.format(req.body.name, x, y, angle, req.body.gridid, req.body.ip, req.body.url, req.body.id), result => {
    next(result);
  }, "exe");
});
//#endregion

//#region  人口
//房屋编辑
router.post('/buildingdata/:type', function (req, res, next) {
  let type = req.params.type;
  let sqlstr = "";
  if (type == "2") {
    sqlstr = "update building t set t.name='{0}'  where t.id='{1}'";
  } else if (type == "0") {
    sqlstr = "insert into building(id,name)  values('{1}','{0}')";
  } else if (type == "1") {
    sqlstr = " delete from monitor where id='" + req.body.id + "'";
  }
  command.executesql(sqlstr.format(req.body.name, req.body.id), result => {
    next(result);
  }, "exe");
});

//常住人口
router.post('/czrydata/:type', function (req, res, next) {
  let totals = 0;
  async.each(req.body.data, (item, callback) => {
    setCZData(item, req.params.type, req.body.houseid, result => {
      if (result.data == 1 && result.resultStatus.code == 200) {
        totals++;
      }
      callback();
    });
  }, function (err) {
    if (err) {
      next({ resultStatus: resultStatus.error(err) });
    } else {
      next({ resultStatus: resultStatus.success, data: totals });
    }
  });
});

//暂住人口
router.post('/zkrydata/:type', function (req, res, next) {
  let totals = 0;
  async.each(req.body.data, (item, callback) => {
    setZKData(item, req.params.type, req.body.houseid, result => {
      if (result.data == 1 && result.resultStatus.code == 200) {
        totals++;
      }
      callback();
    });
  }, function (err) {
    if (err) {
      next({ resultStatus: resultStatus.error(err) });
    } else {

      next({ resultStatus: resultStatus.success, data: totals });
    }
  });
});

//人员基本信息修改
router.post('/population/:type', function (req, res, next) {
  setData(req.body, req.params.type, data => {
    setParty(req.body, req.params.type, result => {
      setZDRY(req.body, req.params.type, result1 => {
        next(data);
      });
    });
  });
});
//常住
function setCZData(obj, type, houseid, callback) {
  let sqlstr = "",
    bindvars = {
      v_yhzgx: obj.yhzgx,
      v_houseid: houseid,
      v_zjhm: obj.zjhm,
      v_sfzx: obj.sfzx,
      v_bz: obj.bz,
      v_self: '1'
    };
  if (type == "2") {
    sqlstr = "UPDATEPERMANENT";
  } else if (type == "0") {
    sqlstr = "ADDPERMANENT";
  } else if (type == "1") {
    sqlstr = " DELETEPERMANENT";
    bindvars = {
      v_zjhm: obj.zjhm,
      v_houseid: houseid
    };
  }
  command.executefun(sqlstr, bindvars, false, result => {
    callback(result);
  });
}
//租客
function setZKData(obj, type, houseid, callback) {
  let sqlstr = "",
    bindvars = {
      zjhm: obj.zjhm,
      v_houseid: houseid,
      zljzrq: obj.zljzrq,
      v_sfzx: obj.sfzx,
      v_bz: obj.bz,
      zlksrq: obj.zlksrq,
      v_self: '1'
    };
  if (type == "2") {
    sqlstr = "UPDATETEMPORARY";
  } else if (type == "0") {
    sqlstr = "ADDTEMPORARY";
  } else if (type == "1") {
    sqlstr = " DELETETEMPORARY";
    bindvars = {
      v_zjhm: obj.zjhm,
      v_houseid: houseid
    };
  }
  command.executefun(sqlstr, bindvars, false, result => {
    callback(result);
  });
}
//人员表的增删改
function setData(obj, type, callback) {
  let sqlstr1 = "",
    bindvars = {
      zjhm: obj.zjhm,
      name: obj.name,
      xb: obj.xb,
      mz: obj.mz,
      csny: obj.csny,
      hkdjd: obj.hkdjd,
      xjzd: obj.xjzd,
      hyzk: obj.hyzk,
      lxdh: obj.lxdh,
      zjlx: obj.zjlx,
      zjhmqfrq: obj.zjhmqfrq,
      cym: obj.cym,
      csd: obj.csd,
      jg: obj.jg,
      sg: obj.sg,
      xx: obj.xx,
      zzmm: obj.zzmm,
      whcd: obj.whcd,
      sfsw: obj.sfsw,
      gzdw: obj.gzdw,
      bz: obj.bz,
      v_self: '1'
    };
  if (type == "2") {
    sqlstr1 = "UPDATEPOPULATION";
  } else if (type == "0") {
    sqlstr1 = ` ADDPOPULATION`;
  } else if (type == "1") {
    sqlstr1 = "DELETEPOPULATION";
    bindvars = {
      zjhm: obj.zjhm
    };
  }
  command.executefun(sqlstr1, bindvars, false, result => {
    callback(result);
  });
}
//重点人员
function setZDRY(obj, type, callback) {
  command.executefun("pkg_keypersonal.fuc_deletekeypersonal", {
    zjhm: obj.zjhm
  }, false, result => {
    var totals = 0;
    if (obj.zdry && type != "1") {
      var temp = obj.zdry.split(",");
      async.eachSeries(temp, (item, callback1) => {
        var flag = {
          has: false,
          data: {}
        };
        for (var j = 0; j < obj.zdrys.length; j++) {
          if (item == obj.zdrys[j].marktype && !isOwnEmpty(obj.zdrys[j].data)) {
            flag.has = true;
            var order = zdry_orders[item];
            if (order) { //按顺序添加属性
              for (var n = 0; n < order.length; n++) {
                flag.data[order[n]] = obj.zdrys[j].data[order[n]];
              }
            } else {
              flag.data = obj.zdrys[j].data;
            }
            break;
          }
        }
        if (flag.has) {
          flag.data.zjhm = obj.zjhm;
          flag.data.type = item;
          command.executefun("pkg_keypersonal.fuc_addpersonal" + item, flag.data, false, function (x) {
            if (x.resultStatus.code == 200) {
              totals++;
            }
            callback1();
          });
        } else {
          command.executefun("pkg_keypersonal.fuc_addpersonal", {
            zjhm: obj.zjhm,
            type: item
          }, false, function (x) {
            if (x.resultStatus.code == 200) {
              totals++;
            }
            callback1();
          });
        }
      }, function (err) {
        callback({
          resultStatus: result.resultStatus,
          data: totals
        });
      });
    } else {
      callback(result);
    }
  });
}

function isOwnEmpty(obj) {
  for (var name in obj) {
    if (obj.hasOwnProperty(name)) {
      return false;//返回false，不为空对象
    }
  }
  return true;//返回true，为空对象
};
//党员
function setParty(obj, type, callback) {
  var sqlstr = "", bindvars;
  if (!obj.tag || type == "1") {
    sqlstr = "DELETEpartymember";
    bindvars = {
      zjhm: obj.zjhm
    };
  } else {
    bindvars = {
      rdrq: obj.tags.rdrq,
      zz: obj.tags.zz,
      zjhm: obj.zjhm,
      ssdz: obj.tags.ssdz,
      szdzb: obj.tags.szdzb,
      v_self: '1'
    };
    sqlstr = "ADDorupdatepartymember";
  }
  command.executefun(sqlstr, bindvars, false, result => {
    callback(result);
  });
}
//#endregion

//#region 场所
//场所基础信息增改
router.post('/areabaseedit', function (req, res, next) {
  let data = req.body;
  // command.executefun("pkg_area.fun_editarea", {
  //   v_name: data.name,
  //   v_x:data.x,
  //   v_y:data.y,
  //   v_wkt:data.wkt,
  //   v_typeid:data.typeid,
  //   v_id:data.id
  // }, false, (result) =>{
  //   next(result);
  // });
  // let  sqlstr = "select *   from area  where id='" + data.Routerid + "'";
  // command.executesql(sqlstr, (result1) => {
  //   if(result1)
  //   next(result1);
  // }, "exe");
  let sqlstr = `merge into area T1
  USING (SELECT  '{0}' name, '{1}' x, '{2}' y, '{3}' wkt, '{4}' typeid,'{5}' id from dual) T2
  ON (T1.id = T2.id)
  WHEN  MATCHED THEN
    update set name=T2.name, x=T2.x, y=T2.y, wkt=nvl(T2.wkt,null), typeid=T2.typeid
  WHEN NOT MATCHED THEN
    INSERT (name,x,y,wkt,typeid,id) VALUES (T2.name,T2.x,T2.y,nvl(T2.wkt,null),T2.typeid,T2.id)`;
  sqlstr = sqlstr.format(data.name, data.x, data.y, data.wkt, data.typeid, data.id);
  command.executesql(sqlstr, (result) => {
    next(result);
  }, "exe");
});

//场所所有信息删除
router.get('/areadelete/:id/:extenddata', function (req, res, next) {
  let id = req.params.id;
  let extenddata = req.params.extenddata;
  let sqlstr = "delete from area where id='" + id + "'";
  command.executesql(sqlstr, (result) => {
    if (extenddata != "null") {
      sqlstr = "delete from " + extenddata + " where id='" + id + "'";
      command.executesql(sqlstr, (result1) => {
        next(result1);
      }, "exe");
    } else {
      next(result);
    }
  }, "exe");
});
//场所详细信息更新
router.post('/areadetailupdate/:id/:extenddata', function (req, res, next) {
  let id = req.params.id;
  let extenddata = req.params.extenddata;
  let sqlstr = "update " + extenddata + " set ";
  let data = req.body;
  for (let i = 0; i < data.length; i++) {
    if (i != data.length - 1) {
      sqlstr += data[i].key + "= '" + data[i].data + "' ,";
    } else {
      sqlstr += data[i].key + "= '" + data[i].data + "'";
    }
  }
  sqlstr += " where id='" + id + "'";
  command.executesql(sqlstr, result => {
    next(result);
  }, "exe");
});
//场所详细信息新增
router.post('/areadetailinsert/:id/:extenddata', function (req, res, next) {
  let extenddata = req.params.extenddata;
  let sqlstr = "insert into " + extenddata + "( ";
  let data = req.body;
  let sqldata = " values(";
  for (let i = 0; i < data.length; i++) {
    if (i != data.length - 1) {
      sqlstr += data[i].key + ",";
      sqldata += data[i].data ? ("'" + data[i].data + "',") : "null,";
    } else {
      sqlstr += data[i].key + ")";
      sqldata += data[i].data ? ("'" + data[i].data + "')") : "null)";
    }
  }
  command.executesql(sqlstr + sqldata, result => {
    next(result);
  }, "exe");
});

//场所关联的监控修改
router.post('/associatemonitor', function (req, res, next) {
  let obj = req.body;
  let sqlstr = "";
  if (obj.type == "add") {
    sqlstr = "insert into area_monitor(id,areaid,monitorid) values(SYS_GUID(),'{0}','{1}')";
  } else {
    sqlstr = "delete from area_monitor where areaid= '{0}' and monitorid='{1}'";
  }
  sqlstr = sqlstr.format(obj.areaid, obj.monitorid);
  command.executesql(sqlstr, (result) => {
    next(result);
  }, "exe");
});
//#endregion

//#region 门面房
//个体户增删改
router.post('/gthdata/:type', function (req, res, next) {
  var obj = req.body,
    type = req.params.type;
  var bindvars = {
    id: obj.id,
    zjlx: obj.zjlx,
    gtjyhmc: obj.gtjyhmc,
    gtjyhhzxm: obj.gtjyhhzxm,
    fddbr: obj.fddbr,
    tyshxydm: obj.tyshxydm,
    lxdh: obj.lxdh,
    zyywhd: obj.zyywhd,
    hydm: obj.hydm,
    cyrymqrs: obj.cyrymqrs,
    cyrymqnxrs: obj.cyrymqnxrs,
    bz: obj.bz,
    type: type
  };
  command.executefun("pkg_facade.fun_editgth", bindvars, false, result => {
    next(result);
  });
});

//企业增删改
router.post('/qydata/:type', function (req, res, next) {
  var obj = req.body,
    type = req.params.type;
  var bindvars = {
    id: obj.id,
    tyshxydm: obj.tyshxydm,
    dwxxmc: obj.dwxxmc,
    frzjlx: obj.frzjlx,
    frzjhm: obj.frzjhm,
    fddbr: obj.fddbr,
    ctqh: obj.ctqh,
    gddh: obj.gddh,
    yddh: obj.yddh,
    zyywhd1: obj.zyywhd1,
    zyywhd2: obj.zyywhd2,
    zyywhd3: obj.zyywhd3,
    hydm: obj.hydm,
    hymc: obj.hymc,
    jglx: obj.jglx,
    djzclx: obj.djzclx,
    kysj: obj.kysj,
    yyzt: obj.yyzt,
    bz: obj.bz,
    hszyywhd1: obj.hszyywhd1,
    hszyywhd2: obj.hszyywhd2,
    hszyywhd3: obj.hszyywhd3,
    type: type
  };
  command.executefun("pkg_facade.fun_editqy", bindvars, false, result => {
    next(result);
  });
});
//#endregion

//#region 社区
router.post("/updatecommunity", function (req, res, next) {
  var obj = req.body;
  var bindvars = {
    id: obj.id,
    wgz: obj.wgz,
    lxdh: obj.lxdh,
    mj: obj.mj,
    lds: obj.lds,
    hs: obj.hs,
    rks: obj.rks,
  }
  command.executefun("fun_updatecommunity", bindvars, false, (result) => {
    next(result);
  }, "exe");
});
router.post("/updatemodule", function (req, res, next) {
  var obj = req.body;
  command.executesql("update module t set t.content='" + obj.content + "' where t.id='" + obj.id + "'", (result) => {
    next(result);
  }, "exe");
});
//#endregion



//#region  批量导入
////////////////////////////////////////////////////////////////////////////////////////批量导入功能
// 暂住人口批量上传
router.post('/insertByBatch_zzrk', function (req, res, next) {
  let data_zzrk = req.body.data;
  let total = { total_sb: 0, total_xz: 0, total_gx: 0 };
  let errdata = [];
  async.each(data_zzrk, (item, callback) => {
    setZZDataByBatch(item, (result) => {
      if (result.data == '1') {
        total.total_xz++;
        errdata.push({ msg: "新增成功", zjhm: item.zjhm });
      } else if (result.data == '2') {
        total.total_gx++;
        errdata.push({ msg: "更新成功", zjhm: item.zjhm });
      } else {
        total.total_sb++;
        errdata.push({ msg: result.data, zjhm: item.zjhm });
      }
      callback();
    });
  }, function (err) {
    if (err) {
      next({ resultStatus: resultStatus.error(err) });
    } else {
      next({ resultStatus: resultStatus.success, data: { total, errdata } });
    }
  });
});

function setZZDataByBatch(obj, callback) {
  bindvars_zz = {
    xqm: obj.xqm,
    ldh: obj.ldh,
    mph: obj.mph,
    zjhm: obj.zjhm,
    name: obj.name,
    lxdh: obj.lxdh,
    hkdjd: obj.hkdjd,
    xjzd: obj.xjzd,
    hyzk: obj.hyzk,
    xb: obj.xb,
    mz: obj.mz,
    csny: obj.csny,
    zjlx: obj.zjlx,
    zjhmqfrq: obj.zjhmqfrq,
    cym: obj.cym,
    csd: obj.csd,
    jg: obj.jg,
    sg: obj.sg,
    xx: obj.xx,
    zzmm: obj.zzmm,
    whcd: obj.whcd,
    sfsw: obj.sfsw,
    gzdw: obj.gzdw,
    bz: obj.bz,
    zlksrq: obj.zlksrq,
    zljzrq: obj.zljzrq,
    self: '1'
  };
  command.executefunByBatch(connection, "PKG_insertByBatch.FNC_TEMPORARY", bindvars_zz, false, result => {
    callback(result);
  });
}

// 常住人口批量上传
router.post('/insertByBatch_czrk', function (req, res, next) {
  let data_czrk = req.body.data;
  let total = { total_sb: 0, total_xz: 0, total_gx: 0 };
  let errdata = [];
  async.each(data_czrk, (item, callback) => {
    setCZDataByBatch(item, (result) => {
      if (result.data == '1') {
        total.total_xz++;
        errdata.push({ msg: "新增成功", zjhm: item.zjhm });
      } else if (result.data == '2') {
        total.total_gx++;
        errdata.push({ msg: "更新成功", zjhm: item.zjhm });
      } else {
        total.total_sb++;
        errdata.push({ msg: result.data, zjhm: item.zjhm });
      }
      callback();
    });
  }, function (err) {
    if (err) {
      next({ resultStatus: resultStatus.error(err) });
    } else {
      next({ resultStatus: resultStatus.success, data: { total, errdata } });
    }
  });
});

function setCZDataByBatch(obj, callback) {
  bindvars_cz = {
    xqm: obj.xqm,
    ldh: obj.ldh,
    mph: obj.mph,
    zjhm: obj.zjhm,
    name: obj.name,
    lxdh: obj.lxdh,
    hkdjd: obj.hkdjd,
    xjzd: obj.xjzd,
    hyzk: obj.hyzk,
    xb: obj.xb,
    mz: obj.mz,
    csny: obj.csny,
    zjlx: obj.zjlx,
    zjhmqfrq: obj.zjhmqfrq,
    cym: obj.cym,
    csd: obj.csd,
    jg: obj.jg,
    sg: obj.sg,
    xx: obj.xx,
    zzmm: obj.zzmm,
    whcd: obj.whcd,
    sfsw: obj.sfsw,
    gzdw: obj.gzdw,
    bz: obj.bz,
    yhzgx: obj.yhzgx,
    self: '1'
  };
  command.executefunByBatch(connection, "PKG_insertByBatch.FNC_PERMANENT", bindvars_cz, false, result => {
    callback(result);
  });
}

// 党员批量上传
router.post('/insertByBatch_dy', function (req, res, next) {
  let data_dy = req.body.data;
  let type = req.body.type;
  let total = { total_sb: 0, total_xz: 0, total_gx: 0 };
  let errdata = [];
  async.each(data_dy, (item, callback) => {
    setDYDataByBatch(item, type, (result) => {
      if (result.data == '1') {
        total.total_xz++;
        errdata.push({ msg: "新增成功", zjhm: item.zjhm });
      } else if (result.data == '2') {
        total.total_gx++;
        errdata.push({ msg: "更新成功", zjhm: item.zjhm });
      } else {
        total.total_sb++;
        errdata.push({ msg: result.data, zjhm: item.zjhm });
      }
      callback();
    });
  }, function (err) {
    if (err) {
      next({ resultStatus: resultStatus.error(err) });
    } else {
      next({ resultStatus: resultStatus.success, data: { total, errdata } });
    }
  });
});

function setDYDataByBatch(obj, type, callback) {
  let funs;
  if (type == '1') {
    bindvars_dy = {
      xqm: obj.xqm,
      ldh: obj.ldh,
      mph: obj.mph,
      zjhm: obj.zjhm,
      name: obj.name,
      lxdh: obj.lxdh,
      hkdjd: obj.hkdjd,
      xjzd: obj.xjzd,
      hyzk: obj.hyzk,
      xb: obj.xb,
      mz: obj.mz,
      csny: obj.csny,
      zjlx: obj.zjlx,
      zjhmqfrq: obj.zjhmqfrq,
      cym: obj.cym,
      csd: obj.csd,
      jg: obj.jg,
      sg: obj.sg,
      xx: obj.xx,
      zzmm: obj.zzmm,
      whcd: obj.whcd,
      sfsw: obj.sfsw,
      gzdw: obj.gzdw,
      bz: obj.bz,
      zlksrq: obj.zlksrq,
      zljzrq: obj.zljzrq,
      rdrq: obj.rdrq,
      zz: obj.zz,
      ssdz: obj.ssdz,
      szdzb: obj.szdzb
    };
    funs = "PKG_insertByBatch.FNC_DY_TEMPORARY";
  } else {
    bindvars_dy = {
      xqm: obj.xqm,
      ldh: obj.ldh,
      mph: obj.mph,
      zjhm: obj.zjhm,
      name: obj.name,
      lxdh: obj.lxdh,
      hkdjd: obj.hkdjd,
      xjzd: obj.xjzd,
      hyzk: obj.hyzk,
      xb: obj.xb,
      mz: obj.mz,
      csny: obj.csny,
      zjlx: obj.zjlx,
      zjhmqfrq: obj.zjhmqfrq,
      cym: obj.cym,
      csd: obj.csd,
      jg: obj.jg,
      sg: obj.sg,
      xx: obj.xx,
      zzmm: obj.zzmm,
      whcd: obj.whcd,
      sfsw: obj.sfsw,
      gzdw: obj.gzdw,
      bz: obj.bz,
      yhzgx: obj.yhzgx,
      rdrq: obj.rdrq,
      zz: obj.zz,
      ssdz: obj.ssdz,
      szdzb: obj.szdzb
    };
    funs = "PKG_insertByBatch.FNC_DY_PERMANENT";
  }
  command.executefunByBatch(connection, funs, bindvars_dy, false, result => {
    callback(result);
  });
}

// 重点人员批量上传
router.post('/insertByBatch_zdry', function (req, res, next) {
  let data_zdry = req.body.data;
  let type = req.body.type;
  let total = { total_sb: 0, total_xz: 0, total_gx: 0 };
  let errdata = [];
  async.each(data_zdry, (item, callback) => {
    setZDRYDataByBatch(item, type, (result) => {
      if (result.data == '1') {
        total.total_xz++;
        errdata.push({ msg: "新增成功", zjhm: item.zjhm });
      } else if (result.data == '2') {
        total.total_gx++;
        errdata.push({ msg: "更新成功", zjhm: item.zjhm });
      } else {
        total.total_sb++;
        errdata.push({ msg: result.data, zjhm: item.zjhm });
      }
      callback();
    });
  }, function (err) {
    if (err) {
      next({ resultStatus: resultStatus.error(err) });
    } else {
      next({ resultStatus: resultStatus.success, data: { total, errdata } });
    }
  });
});

function setZDRYDataByBatch(obj, type, callback) {
  if (type.rk == 'zk') {
    bindvars_zdry = {
      xqm: obj.xqm,
      ldh: obj.ldh,
      mph: obj.mph,
      zjhm: obj.zjhm,
      name: obj.name,
      lxdh: obj.lxdh,
      hkdjd: obj.hkdjd,
      xjzd: obj.xjzd,
      hyzk: obj.hyzk,
      xb: obj.xb,
      mz: obj.mz,
      csny: obj.csny,
      zjlx: obj.zjlx,
      zjhmqfrq: obj.zjhmqfrq,
      cym: obj.cym,
      csd: obj.csd,
      jg: obj.jg,
      sg: obj.sg,
      xx: obj.xx,
      zzmm: obj.zzmm,
      whcd: obj.whcd,
      sfsw: obj.sfsw,
      gzdw: obj.gzdw,
      bz: obj.bz,
      zlksrq: obj.zlksrq,
      zljzrq: obj.zljzrq,
      type: type
    };
    setZZDataByBatch(obj, result => {
      setZDRYByBatch(obj, type, resx => {
        callback(result);
      });
    });
  } else if (type.rk == 'cz') {
    bindvars_zdry = {
      xqm: obj.xqm,
      ldh: obj.ldh,
      mph: obj.mph,
      zjhm: obj.zjhm,
      name: obj.name,
      lxdh: obj.lxdh,
      hkdjd: obj.hkdjd,
      xjzd: obj.xjzd,
      hyzk: obj.hyzk,
      xb: obj.xb,
      mz: obj.mz,
      csny: obj.csny,
      zjlx: obj.zjlx,
      zjhmqfrq: obj.zjhmqfrq,
      cym: obj.cym,
      csd: obj.csd,
      jg: obj.jg,
      sg: obj.sg,
      xx: obj.xx,
      zzmm: obj.zzmm,
      whcd: obj.whcd,
      sfsw: obj.sfsw,
      gzdw: obj.gzdw,
      bz: obj.bz,
      yhzgx: obj.yhzgx,
      type: type
    };
    setCZDataByBatch(obj, result => {
      setZDRYByBatch(obj, type, resx => {
        callback(result);
      });
    });
  }
}

function setZDRYByBatch(obj, type, callback) {
  if (type.zdry.value) {
    var value = type.zdry.value;
    var xxdobj = {};
    for (var i in value) {
      for (var d in obj) {
        if (d == i) {
          xxdobj[d] = obj[d];
        }
      }
    }
    command.executefunByBatch(connection, "pkg_keypersonal.fuc_addpersonal1" + value, xxdobj, false, result => {
      callback(result);
    });
  } else {
    command.executefunByBatch(connection, "pkg_keypersonal.fuc_addpersonal", { zjhm: obj.zjhm, type: type.zdry.key }, false, result => {
      callback(result);
    });
  }
}
//#endregion


//#region  照片管理
router.post("/deletephoto", function (req, res, next) {
  var obj = req.body;
  command.executefun("PKG_PHOTOS.fun_delete_photo", { id: obj.id, folder: obj.folder }, false, (result) => {
    next(result);
  });
});

router.post("/uploadimg", function (req, res, next) {
  var obj = req.body;
  command.executefun("PKG_PHOTOS.fun_add_photo", { id: obj.id, name: obj.name, path: obj.path, module: obj.module, areaid: obj.areaid }, false, (result) => {
    next(result);
  });
});


router.post("/updatefy", function (req, res, next) {
  var obj = req.body;
  command.executesql("update  local_zdry_fy t set t.sfzdgl= sfzdgl || ',' || '" + obj.name + "' where t.zjhm='" + obj.zjhm + "' and lnsj='" + obj.lnsj + "'", (result) => {
    next(result);
  }, "exe");
});

router.post("/deletefy", function (req, res, next) {
  var obj = req.body;
  command.executesql("update  local_zdry_fy t set t.sfzdgl=replace(sfzdgl,'" + obj.name + "' ,'')  where t.zjhm='" + obj.zjhm + "' and lnsj='" + obj.lnsj + "'", (result) => {
    next(result);
  }, "exe");
});
//#endregion

////////////////////////////////////////////////////////////////////////////////////////////////////////////aop 执行后的日志记录
router.use(function (data, req, res, next) {
  connection && connection.close();//关闭从连接池中获取的连接
  require("../util/log").logger.info(req.session.user.userid + req.originalUrl + "////////end");
  res.json(data);
});
router.post("/gtqydata/:type/:qytype", function (req, res, next) {
  var obj = req.body; 
  let str = " update    com_house  set houseid='{0}'  where id= '{1}' and type='{2}' ";
  command.executesql(str.format(obj.houseid, obj.data[0].id, req.params.qytype), (result) => {
    if(result.data=='1'){   
          next(result);
      }      
      else{
      str = " insert into  com_house(id,houseid,type) values('{0}','{1}','{2}') ";
      command.executesql(str.format(obj.data[0].id, obj.houseid, req.params.qytype), (result1) => {
        next(result1);
      }, "exe");
    }
  }, "exe");
});

router.post("/delqygthouse", function (req, res, next) {
  var obj = req.body;
  let str = " delete from   com_house where  id='{0}'  and  houseid='{1}' ";
  command.executesql(str.format(obj.data[0].id, obj.houseid), (result) => {
    next(result);
  }, "exe");
});


module.exports = router;