// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://js.arcgis.com/3.23/esri/copyright.txt for details.
//>>built
define("esri/layers/TiledMapServiceLayer","dojo/_base/declare dojo/_base/connect dojo/_base/lang dojo/_base/array dojo/_base/url dojo/dom-construct dojo/dom-class dojo/dom-geometry dojo/dom-style dojo/dom dojox/collections/ArrayList dojox/gfx/matrix ../kernel ../config ../sniff ../domUtils ../tileUtils ../geometry/Point ../geometry/Rect ../geometry/Extent ./layer".split(" "),function(D,q,E,B,K,p,L,M,m,S,N,O,v,P,z,Q,G,A,C,T,R){D=D(R,{declaredClass:"esri.layers.TiledMapServiceLayer",constructor:function(a,
d){q.connect(this,"onLoad",this,"_initTiledLayer");this._lowestLevel=(this._displayLevels=d?d.displayLevels:null)?this._displayLevels[0]:0;this.resampling=d?d.resampling:void 0;this._resamplingTolerance=d?d.resamplingTolerance:null;this.exclusionAreas=d?d.exclusionAreas:null;var c=E.hitch;this._addImage=c(this,this._addImage);this._tileLoadHandler=c(this,this._tileLoadHandler);this._tileErrorHandler=c(this,this._tileErrorHandler);this._popTile=c(this,this._popTile);this._cleanUpRemovedImages=c(this,
this._cleanUpRemovedImages);this._fireOnUpdateEvent=c(this,this._fireOnUpdateEvent);this._transitionEnd=c(this,this._transitionEnd);this._tileMapCallback=c(this,this._tileMapCallback)},opacity:1,isPNG32:!1,_multiple:1,isResampling:!1,_initTiledLayer:function(){var a=this.tileInfo,d=a.lods;this.resampling=null!=this.resampling?this.resampling:!1;this._tileW=a.width;this._tileH=a.height;var c=this.scales=[],b=this._displayLevels,e=-Infinity,f=Infinity,l=this.fullExtent,g=new A(l.xmin,l.ymax),l=new A(l.xmax,
l.ymin),r=G.getContainingTileCoords,k,h,m,t=d.length;for(m=0;m<t;m++)h=d[m],k=r(a,g,h),h.startTileRow=0>k.row?0:k.row,h.startTileCol=0>k.col?0:k.col,k=r(a,l,h),h.endTileRow=k.row,h.endTileCol=k.col,b&&-1===B.indexOf(b,h.level)||(c[m]=h.scale,e=h.scale>e?h.scale:e,f=h.scale<f?h.scale:f);-Infinity===e||this._hasMin||this.setMinScale(e);Infinity===f||this._hasMax||this.setMaxScale(f);this.setExclusionAreas(this.exclusionAreas);this._patchIE=6<=z("ie")&&7>z("ie")&&(this.isPNG32||"Mixed"===a.format)},
isVisibleAtScale:function(a){return a?R.prototype._isMapAtVisibleScale.call(this,a,!0):!1},_isMapAtVisibleScale:function(a){var d=this.inherited(arguments,[a,!0]);if(d){var c;c=this._map;var d=this.scales,b=c.getScale(),e=!1,f=c.width>c.height?c.width:c.height;for(c=0;c<d.length;c++)if(Math.abs(d[c]-b)/d[c]<1/f){e=!0;break}d=e}return d},_setMap:function(a,d,c,b){this.inherited(arguments);this._map=a;var e=this._div=p.create("div",null,d),f=a.__visibleDelta,l=q.connect,g=v._css.names,r={position:"absolute",
width:a.width+"px",height:a.height+"px",overflow:"visible"},k=P.defaults.map.zoomDuration;"css-transforms"===a.navigationMode?(r[g.transform]=v._css.translate(-f.x,-f.y),m.set(e,r),delete r[g.transform],r[g.transition]=g.transformName+" "+k+"ms ease",m.set(this._active=p.create("div",null,e),r),this._active._remove=0,this._passives=[]):(r.left=-f.x+"px",r.top=-f.y+"px",m.set(e,r));this._onResizeHandler_connect=l(a,"onResize",this,"_onResizeHandler");this._opacityChangeHandler_connect=l(this,"onOpacityChange",
this,"_opacityChangeHandler");f=this.tileInfo;l=f.spatialReference;g=l._getInfo();(this._wrap=a.wrapAround180&&l._isWrappable()&&Math.abs(g.origin[0]-f.origin.x)<=g.dx)&&G._addFrameInfo(f,g);this.setExclusionAreas(this.exclusionAreas);this.evaluateSuspension();if(this.suspended&&!a.loaded)var h=q.connect(a,"onLoad",this,function(){q.disconnect(h);h=null;this.setExclusionAreas(this.exclusionAreas);this.evaluateSuspension()});return e},_unsetMap:function(a,d){this.suspended||this._suspendImpl();p.destroy(this._div);
this._map=this._div=null;var c=q.disconnect;c(this._onResizeHandler_connect);c(this._opacityChangeHandler_connect);this.inherited(arguments)},onSuspend:function(){this.inherited(arguments);this._suspendImpl()},_suspendImpl:function(){Q.hide(this._div);clearTimeout(this._wakeTimer);this._wakeTimer=null;this._disableDrawConnectors();var a=this._tiles,d=this._tileIds,c=this._loadingList,b,e,f=q.disconnect,l=p.destroy;c&&0<c.count&&(c.forEach(function(c){if(b=a[c])f(b._onload_connect),f(b._onerror_connect),
f(b._onabort_connect),b._onload_connect=b._onerror_connect=b._onabort_connect=null}),c.clear(),this._fireUpdateEnd());this._removeList.clear();for(c=d.length-1;0<=c;c--)(b=(e=d[c])&&a[e])&&l(b);if("css-transforms"===this._map.navigationMode){d=this._active;e=this._passives;var g;this._noDom=0;for(c=e.length-1;0<=c;c--)g=e[c],g._endHandle&&f(g._endHandle),g._matrix=g._multiply=g._endHandle=null,g._marked=g._remove=0,e.splice(c,1),l(g);d._matrix=d._multiply=null;d._marked=d._remove=0}this._tileIds=
this._tiles=this._tileBounds=this._ct=this._loadingList=this._removeList=this._standby=null},onResume:function(){this.inherited(arguments);this._tileIds=[];this._tiles=[];this._tileBounds=[];this._ct=null;this._removeList=new N;this._loadingList=new N;Q.show(this._div);this._enableDrawConnectors();this._wakeTimer=this._wakeTimer||setTimeout(E.hitch(this,function(){this.suspended||this._onExtentChangeHandler(this._map.extent,null,!0,this._map.__LOD)}),0)},_enableDrawConnectors:function(){var a=this._map,
d=q.connect;if("css-transforms"===a.navigationMode){if(this._onScaleHandler_connect=d(a,"onScale",this,this._onScaleHandler),z("esri-mobile")){this._standby=[];var c=this,b=function(){c._noDom=1};this._onPanStartHandler_connect=d(a,"onPanStart",b);this._onZoomStartHandler_connect=d(a,"onZoomStart",b)}}else this._onZoomHandler_connect=d(a,"onZoom",this,"_onZoomHandler");this._onPanHandler_connect=d(a,"onPan",this,"_onPanHandler");this._onExtentChangeHandler_connect=d(a,"onExtentChange",this,"_onExtentChangeHandler")},
_disableDrawConnectors:function(){var a=q.disconnect;a(this._onPanHandler_connect);a(this._onZoomHandler_connect);a(this._onScaleHandler_connect);a(this._onExtentChangeHandler_connect);a(this._onPanStartHandler_connect);a(this._onZoomStartHandler_connect);this._onPanHandler_connect=this._onZoomHandler_connect=this._onScaleHandler_connect=this._onExtentChangeHandler_connect=this._onPanStartHandler_connect=this._onZoomStartHandler_connect=null},_onResizeHandler:function(a,d,c){a={width:d+"px",height:c+
"px"};d=m.set;d(this._div,a);if("css-transforms"===this._map.navigationMode)for(this._active&&d(this._active,a),c=this._passives.length-1;0<=c;c--)d(this._passives[c],a)},_onExtentChangeHandler:function(a,d,c,b){d=this._map;var e=this._standby,f;clearTimeout(this._wakeTimer);this._wakeTimer=null;if(!d._isPanningOrZooming()){if("css-transforms"===d.navigationMode){if(c)for(b=this._passives.length-1;0<=b;b--)f=this._passives[b],m.set(f,v._css.names.transition,"none"),f._marked?(this._passives.splice(b,
1),f.parentNode&&f.parentNode.removeChild(f),p.destroy(f)):0<f.childNodes.length&&(f._multiply=f._multiply?O.multiply(f._matrix,f._multiply):f._matrix);this._noDom=0;if(e&&e.length)for(b=e.length-1;0<=b;b--)f=e[b],m.set(f,"visibility","inherit"),this._popTile(f),e.splice(b,1)}this._fireUpdateStart();this._rrIndex=0;b=G.getCandidateTileInfo(d,this.tileInfo,a);a=d.__visibleDelta;if(!this._ct||b.lod.level!==this._ct.lod.level||c){f=b&&this._ct&&b.lod.level!==this._ct.lod.level;this._ct=b;var l=this._tiles,
g=this._tileIds,r=this._tileBounds,k=this._removeList,h,u=g.length;this._cleanUpRemovedImages();for(b=0;b<u;b++)e=g[b],h=l[e],r[e]=g[b]=null,"css-transforms"===d.navigationMode&&f&&h.parentNode&&d.fadeOnZoom&&(h._fadeOut=f,h.parentNode._remove++),k.add(h);c&&(this._tileIds=[],this._tiles=[],this._tileBounds=[])}b=a.x;c=a.y;"css-transforms"===d.navigationMode?(e={},e[v._css.names.transform]=v._css.translate(b,c),m.set(this._div,e)):m.set(this._div,{left:b+"px",top:c+"px"});this.__coords_dx=b;this.__coords_dy=
c;this._updateImages(new C(0,0,a.width,a.height));0===this._loadingList.count?(this._cleanUpRemovedImages(),this.onUpdate(),this._fireUpdateEnd()):this._fireOnUpdate=!0;c=this._tileW;l=this._tileH;a=new C(-a.x,-a.y,a.width,a.height);for(b=this._tileIds.length-1;0<=b;b--)(e=this._tileIds[b])?(f=this._tiles[e],g=M.getMarginBox(f),g=new C(g.l,g.t,c,l),"css-transforms"===d.navigationMode&&(g.x=f._left,g.y=f._top),a.intersects(g)?this._tileBounds[e]=g:(this._loadingList.contains(e)&&this._popTile(f),p.destroy(f),
this._tileIds.splice(b,1),delete this._tileBounds[e],delete this._tiles[e])):(this._tileIds.splice(b,1),delete this._tileBounds[e],delete this._tiles[e])}},_onPanHandler:function(a,d){var c=this._map,b=c.__visibleDelta.offset(d.x,d.y);this.__coords_dx=this.__coords_dy=0;"css-transforms"===c.navigationMode?(c={},c[v._css.names.transform]=v._css.translate(b.x,b.y),m.set(this._div,c),z("esri-mobile")||this._updateImages({x:-b.x,y:-b.y,width:b.width,height:b.height})):(m.set(this._div,{left:b.x+"px",
top:b.y+"px"}),this._updateImages({x:-b.x,y:-b.y,width:b.width,height:b.height}));0<this._loadingList.count&&(this._fireUpdateStart(),this._fireOnUpdate=!0)},_onScaleHandler:function(a,d){var c,b={},e=v._css.names,f=this._map,l=P.defaults.map.zoomDuration;for(c=this._passives.length-1;0<=c;c--){var g=this._passives[c];0===g.childNodes.length?(this._passives.splice(c,1),p.destroy(g)):("none"===g.style[e.transition]&&m.set(g,e.transition,e.transformName+" "+l+"ms ease"),m.set(g,e.transition,d?"none":
e.transformName+" "+l+"ms ease"),g._matrix=a,b[e.transform]=v._css.matrix(g._multiply?O.multiply(a,g._multiply):a),m.set(g,b))}this._active&&0===this._active.childNodes.length||(m.set(this._active,e.transition,d?"none":e.transformName+" "+l+"ms ease"),this._active._matrix=a,b[e.transform]=v._css.matrix(this._active._matrix),m.set(this._active,b),this._passives.push(this._active),b={position:"absolute",width:f.width+"px",height:f.height+"px",overflow:"visible"},b[e.transition]=e.transformName+" "+
l+"ms ease",m.set(this._active=p.create("div",null,this._div),b),this._active._remove=0,f.fadeOnZoom&&p.place(this._active,this._div,"first"))},_onZoomHandler:function(a,d,c){a=M.getMarginBox(this._div);c=c.offset(-a.l,-a.t);this._previousScale&&1!==d||(this._previousScale=1);var b,e=this._tileW*d,f=this._tileH*d,l=this._tileBounds,g=this._tiles,r=this._previousScale,k=this._multiple,h=m.set,u,t;if((a=z("ie"))&&8>a)B.forEach(this._tileIds,function(a){t="";b=l[a];u=g[a].style.margin.split(" ");B.forEach(u,
function(a){""!==t&&(t+=" ");a=parseFloat(a);t+=a/r*d+"px"});h(g[a],{left:b.x-(e-b.width)*(c.x-b.x)/b.width+"px",top:b.y-(f-b.height)*(c.y-b.y)/b.height+"px",margin:1!==k&&-1===t.indexOf("NaN")?t:"",zoom:d})});else{var v=e*k,U=f*k,n,p;B.forEach(this._tileIds,function(a){t="";b=l[a];n=b.x-(e-b.width)*(c.x-b.x)/b.width;p=b.y-(f-b.height)*(c.y-b.y)/b.height;u=g[a].style.margin.split(" ");B.forEach(u,function(a){""!==t&&(t+=" ");a=parseFloat(a);t+=a/r*d+"px"});h(g[a],{left:n+"px",top:p+"px",margin:1!==
k&&-1===t.indexOf("NaN")?t:"",width:v+"px",height:U+"px"})})}this._previousScale=d},_updateImages:function(a){if(this._ct){var d,c=this._tileW,b=this._tileH,e=this._ct;d=e.lod;var e=e.tile,f=e.offsets,l=e.coords,g=l.row,l=l.col,m=d.level,k=this.opacity,h=this._tileIds,u=this._loadingList,t=this._addImage,p=this._map.id,v=this.id,n=a.x,q=a.y,z=d.startTileRow,A=d.endTileRow,D=d.startTileCol,E=d.endTileCol,G=B.indexOf,y,w,C=f.x-this.__coords_dx,H=f.y-this.__coords_dy;w=c-C+-a.x;var x=b-H+-a.y;y=Math.ceil;
w=0<w?w%c:c-Math.abs(w)%c;x=0<x?x%b:b-Math.abs(x)%b;n=0<n?Math.floor((n+C)/c):y((n-(c-C))/c);q=0<q?Math.floor((q+H)/b):y((q-(b-H))/b);H=n+y((a.width-w)/c);a=q+y((a.height-x)/b);var F,I,J;this._wrap&&(F=d._frameInfo,I=F[0],J=F[1],F=F[2]);for(x=n;x<=H;x++)for(n=q;n<=a;n++)y=g+n,w=l+x,this._wrap&&(w<J?(w%=I,w=w<J?w+I:w):w>F&&(w%=I)),!this._isExcluded(m,y,w)&&y>=z&&y<=A&&w>=D&&w<=E&&(d=p+"_"+v+"_tile_"+m+"_"+n+"_"+x,-1===G(h,d)&&(u.add(d),h.push(d),t(m,n,y,x,w,d,c,b,k,e,f)))}},_cleanUpRemovedImages:function(){var a=
this._removeList,d=p.destroy,c,b=v._css.names;a.forEach(function(a){a._fadeOut||(a.style.filter="",a.style.zoom=1,d(a))});if("css-transforms"===this._map.navigationMode)for(c=this._passives.length-1;0<=c;c--){var e=this._passives[c];0===e.childNodes.length?(this._passives.splice(c,1),d(e)):this._map.fadeOnZoom&&!e._marked&&e._remove===e.childNodes.length&&(e._marked=1,2048>v._css.getScaleFromMatrix(m.get(e,b.transform))?(m.set(e,b.transition,"opacity 0.65s"),m.set(e,"opacity",0),q.disconnect(e._endHandle),
e._endHandle=q.connect(e,b.endEvent,this._transitionEnd)):this._transitionEnd({propertyName:"opacity",target:e}))}a.clear()},_transitionEnd:function(a){var d=a.target;"opacity"===a.propertyName&&(q.disconnect(d._endHandle),d._endHandle=null,a=B.indexOf(this._passives,d),-1<a&&this._passives.splice(a,1),d.parentNode&&d.parentNode.removeChild(d),p.destroy(d))},_addImage:function(a,d,c,b,e,f,l,g,r,k,h){if(this._patchIE)k=this._tiles[f]=p.create("div"),k.id=f,L.add(k,"layerTile"),m.set(k,{left:l*b-h.x+
"px",top:g*d-h.y+"px",width:l+"px",height:g+"px",filter:"progid:DXImageTransform.Microsoft.AlphaImageLoader(src\x3d'"+this.getTileUrl(a,c,e)+"', sizingMethod\x3d'scale')"}),1>r&&m.set(k,"opacity",r),a=k.appendChild(p.create("div")),m.set(a,{opacity:0,width:l+"px",height:g+"px"}),this._div.appendChild(k),k=null,this._loadingList.remove(f),this._fireOnUpdateEvent();else{k=this._tiles[f]=p.create("img");var u=q.connect;k.id=f;k._uid=a+"_"+c+"_"+e;k.alt="";L.add(k,"layerTile");b=l*b-h.x;h=g*d-h.y;d=this._map;
var t=v._css.names;l={width:l+"px",height:g+"px",visibility:"hidden"};"css-transforms"===d.navigationMode?(l[t.transform]=v._css.translate(b,h),m.set(k,l),k._left=b,k._top=h):(l.left=b+"px",l.top=h+"px",m.set(k,l));1>r&&m.set(k,"opacity",r);k._onload_connect=u(k,"onload",this,"_tileLoadHandler");k._onerror_connect=u(k,"onerror",E.hitch(this,"_tileErrorHandler",c,e));k._onabort_connect=u(k,"onabort",this,"_tileAbortHandler");if(this.tileMap)this.tileMap.getTile(a,c,e,f,this._tileMapCallback);else if(f=
this.getTileUrl(a,c,e,k))this._failedRequests&&this._failedRequests[f]?(m.set(k,this._failedRequests[f].css),k.src=this._failedRequests[f].src,this._multiple=parseInt(this._failedRequests[f].css.width)/this._tileW,this.isResampling=1!==this._multiple):(this._multiple=1,this.isResampling=!1,k.src=f);"css-transforms"===d.navigationMode?this._active.appendChild(k):this._div.appendChild(k);k=null}},_tileMapCallback:function(a,d){var c,b;this.suspended||(b=this._tiles[d.id]||S.byId(d.id),c=d.level+"_"+
d.row+"_"+d.col,b&&b._uid===c?(this._multiple=2*(d.level-a.level)||1,this.isResampling=1!==this._multiple,c=this.tileMap.style(a,d),m.set(b,c),b.src=this.getTileUrl(a.level,a.row,a.col)):this._popTile(d))},getTileUrl:function(a,d,c){},_reCheckTS:/[\?\&]_ts=/ig,_reReplaceTS:/([\?\&]_ts=)[0-9]+/ig,addTimestampToURL:function(a){var d=this._refreshTS;d&&(a=this._reCheckTS.test(a)?a.replace(this._reReplaceTS,"$$$1"+d):a+((-1===a.indexOf("?")?"?":"\x26")+"_ts\x3d"+d));return a},refresh:function(){this.suspended||
(this._refreshTS=(new Date).getTime(),this._onExtentChangeHandler(this._map.extent,null,!0,this._map.__LOD))},_popTile:function(a){var d=q.disconnect;d(a._onload_connect);d(a._onerror_connect);d(a._onabort_connect);a._onload_connect=a._onerror_connect=a._onabort_connect=null;this._loadingList.remove(a.id);this._fireOnUpdateEvent()},_tileLoadHandler:function(a){a=a.currentTarget;this._noDom?this._standby.push(a):(m.set(a,"visibility","inherit"),this._popTile(a))},_tileAbortHandler:function(a){a=a.currentTarget;
this.onError(Error("Unable to load tile: "+a.src));m.set(a,"visibility","hidden");this._popTile(a)},_tileErrorHandler:function(a,d,c){c=c.currentTarget;var b,e,f=!0;if(this.tileMap||!this.resampling)f=!1;else if(b=new K(c.src),b=b.path.split("/"),b=parseInt(b[b.length-3]),e=this._ct.lod.level-b+1,this._multiple=Math.pow(2,e),b===this._lowestLevel||0===this._resamplingTolerance||this._resamplingTolerance&&Math.log(this._multiple)/Math.LN2>this._resamplingTolerance)f=!1;f?(this.isResampling=!0,this._resample(c,
a,d)):(this.onError(Error("Unable to load tile: "+c.src)),m.set(c,"visibility","hidden"),this._popTile(c))},_resample:function(a,d,c){var b=(new K(a.src)).path.split("/"),e=this._multiple,f=parseInt(b[b.length-3])-1,l=parseInt(d/e),g=parseInt(c/e),b=c%e,r=d%e,l=this.getTileUrl(f,l,g);d=this.getTileUrl(f+Math.log(e)/Math.LN2,d,c);e={width:this._tileW*e+"px",height:this._tileH*e+"px",margin:"-"+this._tileW*r+"px 0 0 "+("-"+this._tileH*b+"px")};this._failedRequests||(this._failedRequests={});this._failedRequests[d]=
{src:l,css:e};m.set(a,e);z("chrome")&&a.setAttribute("src",null);a.src=l},_fireOnUpdateEvent:function(){0===this._loadingList.count&&(this._cleanUpRemovedImages(),this._fireOnUpdate&&(this._fireOnUpdate=!1,this.onUpdate(),this._fireUpdateEnd()))},setOpacity:function(a){if(this.opacity!=a)this.onOpacityChange(this.opacity=a)},onOpacityChange:function(){},_opacityChangeHandler:function(a){var d=m.set,c,b,e;if("css-transforms"===this._map.navigationMode){if(this._active)for(e=this._active.childNodes,
c=e.length-1;0<=c;c--)d(e[c],"opacity",a);for(c=this._passives.length-1;0<=c;c--)for(e=this._passives[c].childNodes,b=e.length-1;0<=b;b--)d(e[b],"opacity",a)}else for(e=this._div.childNodes,c=e.length-1;0<=c;c--)d(e[c],"opacity",a)},setExclusionAreas:function(a){this.exclusionAreas=a;if(this.loaded&&this._map&&this._map.loaded){var d=this._map.spatialReference,c=this.tileInfo,b=c.origin,e=c.lods,f=e[0].level,l=e[e.length-1].level,g,m,k,h,u,t,q,p,n;if(this.exclusionAreas&&this.exclusionAreas.length)for(this._exclusionsPerZoom=
[],m=0,k=a.length;m<k;m++){if(g=a[m],(n=g.geometry)&&"extent"===n.type&&n.xmin<=n.xmax&&n.ymin<=n.ymax){if(!d.equals(n.spatialReference))if(d._canProject(n.spatialReference))d.isWebMercator()?(p=A.lngLatToXY(n.xmin,n.ymin),n=A.lngLatToXY(n.xmax,n.ymax)):(p=A.xyToLngLat(n.xmin,n.ymin,!0),n=A.xyToLngLat(n.xmax,n.ymax,!0)),n=new T(p[0],p[1],n[0],n[1],d);else continue;q=-1;if(g.minZoom&&-1!==g.minZoom)q=g.minZoom;else if(g.minScale&&-1!==g.minScale)for(h=0,u=e.length;h<u;h++)if(e[h].scale<=g.minScale){q=
e[h].level;break}q=Math.max(q,f);p=-1;if(g.maxZoom&&-1!==g.maxZoom)p=g.maxZoom;else if(g.maxScale&&-1!==g.maxScale)for(h=0,u=e.length;h<u;h++)if(e[h].scale<g.maxScale){p=e[h-1].level;break}else if(e[h].scale===g.maxScale){p=e[h].level;break}p=-1===p?l:Math.min(p,l);for(g=q;g<=p;g++){h=0;for(u=e.length;h<u;h++)if(e[h].level===g){t=e[h];break}t&&(this._exclusionsPerZoom[g]||(this._exclusionsPerZoom[g]=[]),h=1/t.resolution/c.rows,u=1/t.resolution/c.cols,this._exclusionsPerZoom[g].push({rowFrom:Math.floor((b.y-
n.ymax)*h),rowTo:Math.ceil((b.y-n.ymin)*h),colFrom:Math.floor((n.xmin-b.x)*u),colTo:Math.ceil((n.xmax-b.x)*u)}))}}}else this._exclusionsPerZoom=null;this.suspended||this._onExtentChangeHandler(this._map.extent,null,!0,this._map.__LOD)}},_isExcluded:function(a,d,c){var b,e,f;if(!this._exclusionsPerZoom)return!1;b=this._exclusionsPerZoom[a];if(!b)return!1;e=0;for(f=b.length;e<f;e++)if(a=b[e],d>=a.rowFrom&&d<a.rowTo&&c>=a.colFrom&&c<a.colTo)return!0;return!1}});z("extend-esri")&&E.setObject("layers.TiledMapServiceLayer",
D,v);return D});