// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://js.arcgis.com/3.23/esri/copyright.txt for details.
//>>built
require({cache:{"url:esri/layers/support/rasterFunctionSchema.json":'{\r\n  "AspectFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "ColormapFunction": {\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ColorSchemeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.colorSchemeTypeName}",\r\n        "defaultValue": 0,\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "colorSchemeTypes"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                0\r\n              ],\r\n              "active": [\r\n                "ColormapName"\r\n              ],\r\n              "inactive": [\r\n                "ColorRamp"\r\n              ],\r\n              "autoRevert": true\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "Colormap": {\r\n        "required": true,\r\n        "displayName": "${rasterFunctions.rfxArgs.colormapName}",\r\n        "dataType": "rastercolormap",\r\n        "hidden": true\r\n      },\r\n      "ColormapName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.colormapNameName}",\r\n        "hidden": false,\r\n        "defaultValue": "Gray",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "colormapTypes"\r\n        }\r\n      },\r\n      "ColorRamp": {\r\n        "required": true,\r\n        "displayName": "${rasterFunctions.rfxArgs.colorRampName}",\r\n        "dataType": "colorramp",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "ContrastBrightnessFunction": {\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ContrastOffset": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.contrastOffsetName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "range",\r\n          "min": -100,\r\n          "max": 100\r\n        }\r\n      },\r\n      "BrightnessOffset": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.brightnessOffsetName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "range",\r\n          "min": -100,\r\n          "max": 100\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "ExtractBandFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "Method": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.methodName}",\r\n        "hidden": false,\r\n        "defaultValue": 2,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "bandComboMethods"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": false,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                0\r\n              ],\r\n              "active": [\r\n                "BandNames"\r\n              ],\r\n              "inactive": [\r\n                "BandWavelengths",\r\n                "BandIds"\r\n              ]\r\n            },\r\n            {\r\n              "values": [\r\n                1\r\n              ],\r\n              "active": [\r\n                "BandWavelengths"\r\n              ],\r\n              "inactive": [\r\n                "BandNames",\r\n                "BandIds"\r\n              ]\r\n            },\r\n            {\r\n              "values": [\r\n                2\r\n              ],\r\n              "active": [\r\n                "BandIds"\r\n              ],\r\n              "inactive": [\r\n                "BandNames",\r\n                "BandWavelengths"\r\n              ]\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "BandNames": {\r\n        "required": true,\r\n        "dataType": "stringarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.bandNamesName}",\r\n        "hidden": false,\r\n        "defaultValue": [\r\n          "Red",\r\n          "Green",\r\n          "Blue"\r\n        ]\r\n      },\r\n      "BandWavelengths": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.bandWavelengthsName}",\r\n        "hidden": false,\r\n        "defaultValue": [\r\n          600,\r\n          400,\r\n          200\r\n        ]\r\n      },\r\n      "BandIds": {\r\n        "required": true,\r\n        "dataType": "longarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.bandIdsName}",\r\n        "hidden": false,\r\n        "defaultValue": [\r\n          0,\r\n          1,\r\n          2\r\n        ]\r\n      },\r\n      "MissingBandAction": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.missingBandActionName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriMissingBandActions"\r\n        }\r\n      }\r\n    },\r\n    "editorArgumentOverride": {\r\n      "active": true,\r\n      "overrides": [\r\n        {\r\n          "argumentNames": [\r\n            "Method",\r\n            "BandNames",\r\n            "BandWavelengths",\r\n            "BandIds"\r\n          ],\r\n          "widget": {\r\n            "path": "esri/dijit/RasterFunctionEditor/RFxBandCombinationEditor"\r\n          }\r\n        }\r\n      ]\r\n    }\r\n  },\r\n  "GrayscaleFunction": {\r\n    "Description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ConversionParameters": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "dataTypeAttributes": {\r\n          "type": "bandmatrix",\r\n          "nBands": "Raster",\r\n          "cols": 1,\r\n          "displayNames": [\r\n            "${rasterFunctions.rfxArgs.weightName}"\r\n          ]\r\n        },\r\n        "displayName": "${rasterFunctions.rfxArgs.conversionParametersName}",\r\n        "hidden": false,\r\n        "defaultValue": [\r\n          0.299,\r\n          0.587,\r\n          0.114\r\n        ]\r\n      }\r\n    }\r\n  },\r\n  "HillshadeFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "DEM": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "HillshadeType": {\r\n        "required": false,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.hillshadeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriHillshadeTypes"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                1\r\n              ],\r\n              "inactive": [\r\n                "Azimuth",\r\n                "Altitude"\r\n              ],\r\n              "autoRevert": true\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "Azimuth": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.azimuthName}",\r\n        "hidden": false,\r\n        "defaultValue": 315\r\n      },\r\n      "Altitude": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.altitudeName}",\r\n        "hidden": false,\r\n        "defaultValue": 45\r\n      },\r\n      "SlopeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.slopeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriSlopeTypes13"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                3\r\n              ],\r\n              "active": [\r\n                "PSPower",\r\n                "PSZFactor"\r\n              ],\r\n              "autoRevert": true\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "ZFactor": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.zFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 1\r\n      },\r\n      "PSPower": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.PSPowerName}",\r\n        "hidden": false,\r\n        "defaultValue": 0.664\r\n      },\r\n      "PSZFactor": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.PSZFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 0.024\r\n      },\r\n      "RemoveEdgeEffect": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.removeEdgeEffectName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      }\r\n    }\r\n  },\r\n  "ShadedReliefFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ColorSchemeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.colorSchemeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "colorSchemeTypes"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                1\r\n              ],\r\n              "active": [\r\n                "ColorRamp"\r\n              ],\r\n              "inactive": [\r\n                "Colormap"\r\n              ],\r\n              "autoRevert": true\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "ColorRamp": {\r\n        "required": true,\r\n        "dataType": "colorramp",\r\n        "displayName": "${rasterFunctions.rfxArgs.colorRampName}",\r\n        "hidden": false\r\n      },\r\n      "Colormap": {\r\n        "required": true,\r\n        "dataType": "rastercolormap",\r\n        "displayName": "${rasterFunctions.rfxArgs.colormapName}",\r\n        "hidden": false\r\n      },\r\n      "Azimuth": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.azimuthName}",\r\n        "hidden": false,\r\n        "defaultValue": 315\r\n      },\r\n      "Altitude": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.altitudeName}",\r\n        "hidden": false,\r\n        "defaultValue": 45\r\n      },\r\n      "SlopeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.slopeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriSlopeTypes13"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                3\r\n              ],\r\n              "active": [\r\n                "PSPower",\r\n                "PSZFactor"\r\n              ],\r\n              "autoRevert": true\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "ZFactor": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.zFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 1\r\n      },\r\n      "PSPower": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.PSPowerName}",\r\n        "hidden": false,\r\n        "defaultValue": 0.664\r\n      },\r\n      "PSZFactor": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.PSZFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 0.024\r\n      },\r\n      "RemoveEdgeEffect": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.removeEdgeEffectName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      }\r\n    }\r\n  },\r\n  "SlopeFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "DEM": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "SlopeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.slopeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriSlopeTypes"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                3\r\n              ],\r\n              "active": [\r\n                "PSPower",\r\n                "PSZFactor"\r\n              ],\r\n              "autoRevert": true\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "Zfactor": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.zFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 1\r\n      },\r\n      "PSPower": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.PSPowerName}",\r\n        "hidden": false,\r\n        "defaultValue": 0.664\r\n      },\r\n      "PSZFactor": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.PSZFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 0.024\r\n      },\r\n      "RemoveEdgeEffect": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.removeEdgeEffectName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      }\r\n    }\r\n  },\r\n  "UnitConversionFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "FromUnit": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.fromUnitName}",\r\n        "hidden": false,\r\n        "defaultValue": 3,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriUnitConversionFxUnitTypes"\r\n        }\r\n      },\r\n      "ToUnit": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.toUnitName}",\r\n        "hidden": false,\r\n        "defaultValue": 10,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriUnitConversionFxUnitTypes"\r\n        }\r\n      }\r\n    },\r\n    "editorArgumentOverride": {\r\n      "active": true,\r\n      "overrides": [\r\n        {\r\n          "argumentNames": [\r\n            "FromUnit",\r\n            "ToUnit"\r\n          ],\r\n          "widget": {\r\n            "path": "esri/dijit/RasterFunctionEditor/RFxUnitPicker"\r\n          }\r\n        }\r\n      ]\r\n    }\r\n  },\r\n  "StretchFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "StretchType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.stretchTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriRasterStretchTypes"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                0,\r\n                5\r\n              ],\r\n              "inactive": [\r\n                "MinPercent",\r\n                "MaxPercent",\r\n                "NumberOfStandardDeviation",\r\n                "SigmoidStrengthLevel"\r\n              ]\r\n            },\r\n            {\r\n              "values": [\r\n                3\r\n              ],\r\n              "active": [\r\n                "NumberOfStandardDeviation"\r\n              ],\r\n              "inactive": [\r\n                "MinPercent",\r\n                "MaxPercent",\r\n                "SigmoidStrengthLevel"\r\n              ]\r\n            },\r\n            {\r\n              "values": [\r\n                6\r\n              ],\r\n              "active": [\r\n                "MinPercent",\r\n                "MaxPercent"\r\n              ],\r\n              "inactive": [\r\n                "NumberOfStandardDeviation",\r\n                "SigmoidStrengthLevel"\r\n              ]\r\n            },\r\n            {\r\n              "values": [\r\n                9\r\n              ],\r\n              "active": [\r\n                "SigmoidStrengthLevel"\r\n              ],\r\n              "inactive": [\r\n                "MinPercent",\r\n                "MaxPercent",\r\n                "NumberOfStandardDeviation"\r\n              ]\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "Min": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.minName}",\r\n        "hidden": false,\r\n        "defaultValue": 0\r\n      },\r\n      "Max": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.maxName}",\r\n        "hidden": false,\r\n        "defaultValue": 255\r\n      },\r\n      "MinPercent": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.minPercentName}",\r\n        "hidden": false,\r\n        "defaultValue": 0.25\r\n      },\r\n      "MaxPercent": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.maxPercentName}",\r\n        "hidden": false,\r\n        "defaultValue": 0.5\r\n      },\r\n      "NumberOfStandardDeviation": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.numberOfStandardDeviationName}",\r\n        "hidden": false,\r\n        "defaultValue": 2\r\n      },\r\n      "SigmoidStrengthLevel": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.sigmoidStrengthLevelName}",\r\n        "hidden": false,\r\n        "defaultValue": 2,\r\n        "domain": {\r\n          "type": "numlist",\r\n          "start": 1,\r\n          "count": 6,\r\n          "inc": 1,\r\n          "asc": true\r\n        }\r\n      },\r\n      "EstimateStatsHistogram": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.estimateStatsHistogramName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      },\r\n      "DRA": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.DRAName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      },\r\n      "Statistics": {\r\n        "required": true,\r\n        "dataType": "arrayofrasterstatistics",\r\n        "displayName": "${rasterFunctions.rfxArgs.statisticsName}",\r\n        "hidden": false\r\n      },\r\n      "Histograms": {\r\n        "required": true,\r\n        "dataType": "arrayofrasterhistogram",\r\n        "displayName": "${rasterFunctions.rfxArgs.histogramsName}",\r\n        "hidden": true\r\n      },\r\n      "ComputeGamma": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.computeGammaName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      },\r\n      "UseGamma": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.useGammaName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      },\r\n      "Gamma": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.gammaName}",\r\n        "hidden": false\r\n      }\r\n    },\r\n    "editorArgumentOverride": {\r\n      "active": true,\r\n      "overrides": [\r\n        {\r\n          "argumentNames": [\r\n            "Gamma"\r\n          ],\r\n          "widget": {\r\n            "path": "esri/dijit/RasterFunctionEditor/RFxGammaEditor"\r\n          }\r\n        }\r\n      ]\r\n    }\r\n  },\r\n  "RasterCalculatorFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Rasters": {\r\n        "required": true,\r\n        "dataType": "rasterarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "InputNames": {\r\n        "required": true,\r\n        "dataType": "stringarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.inputNamesName}",\r\n        "hidden": false\r\n      },\r\n      "Expression": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.expressionName}",\r\n        "hidden": false\r\n      },\r\n      "CellsizeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.cellsizeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 2,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriCellsizeTypes"\r\n        }\r\n      },\r\n      "ExtentType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.extentTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriExtentTypes"\r\n        }\r\n      }\r\n    },\r\n    "editorArgumentOverride": {\r\n      "active": true,\r\n      "overrides": [\r\n        {\r\n          "argumentNames": [\r\n            "Rasters",\r\n            "InputNames"\r\n          ],\r\n          "widget": {\r\n            "path": "esri/dijit/RasterFunctionEditor/RFxNamedRasterEditor"\r\n          }\r\n        }\r\n      ]\r\n    }\r\n  },\r\n  "ClassifyFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ClassifierDefinitionFile": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.classifierDefinitionFileName}",\r\n        "hidden": false\r\n      },\r\n      "Raster2": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.raster2Name}",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "MaskFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "NoDataInterpretation": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.noDataInterpretationName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriNoDataInterpretationTypes"\r\n        }\r\n      },\r\n      "NoDataValues": {\r\n        "required": true,\r\n        "dataType": "stringarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.noDataValuesName}",\r\n        "hidden": false,\r\n        "dataTypeAttributes": {\r\n          "type": "bandmatrix",\r\n          "nBands": "Raster",\r\n          "cols": 1,\r\n          "displayNames": [\r\n            "${rasterFunctions.rfxArgs.noDataValuesName}"\r\n          ]\r\n        }\r\n      },\r\n      "IncludedRanges": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.includedRangesName}",\r\n        "hidden": false,\r\n        "dataTypeAttributes": {\r\n          "type": "bandmatrix",\r\n          "nBands": "Raster",\r\n          "cols": 2,\r\n          "displayNames": [\r\n            "${rasterFunctions.rfxArgs.minimumName}",\r\n            "${rasterFunctions.rfxArgs.maximumName}"\r\n          ]\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "ColormapToRGBFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "CurvatureFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "CurvatureType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.typeName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriCurvatureTypes"\r\n        }\r\n      },\r\n      "ZFactor": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.zFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 1\r\n      }\r\n    }\r\n  },\r\n  "CompositeBandFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Rasters": {\r\n        "required": true,\r\n        "dataType": "rasterarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.rastersName}",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "TableFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "AttributeTable": {\r\n        "required": true,\r\n        "dataType": "table",\r\n        "displayName": "${rasterFunctions.rfxArgs.attributeTableName}",\r\n        "hidden": false\r\n      },\r\n      "AttributeTableAsRecordSet": {\r\n        "required": true,\r\n        "dataType": "table",\r\n        "displayName": "${rasterFunctions.rfxArgs.attributeTableName}",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "ConvolutionFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ConvolutionType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.convolutionTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 19,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriRasterFilterTypes"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                0,\r\n                1,\r\n                2,\r\n                3,\r\n                4,\r\n                5,\r\n                6,\r\n                7,\r\n                8,\r\n                9,\r\n                10,\r\n                11,\r\n                12,\r\n                13,\r\n                14,\r\n                15,\r\n                16,\r\n                17,\r\n                18,\r\n                19,\r\n                20,\r\n                21\r\n              ],\r\n              "active": [\r\n                "Kernel"\r\n              ],\r\n              "inactive": [\r\n                "Rows",\r\n                "Columns"\r\n              ]\r\n            },\r\n            {\r\n              "values": [\r\n                -1\r\n              ],\r\n              "active": [\r\n                "Rows",\r\n                "Columns",\r\n                "Kernel"\r\n              ]\r\n            },\r\n            {\r\n              "values": [\r\n                255\r\n              ],\r\n              "inactive": [\r\n                "Rows",\r\n                "Columns",\r\n                "Kernel"\r\n              ]\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "Rows": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.rowsName}",\r\n        "hidden": false,\r\n        "defaultValue": 3,\r\n        "domain": {\r\n          "type": "numlist",\r\n          "start": 1,\r\n          "count": 100,\r\n          "inc": 1,\r\n          "asc": true\r\n        }\r\n      },\r\n      "Columns": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.columnsName}",\r\n        "hidden": false,\r\n        "defaultValue": 3,\r\n        "domain": {\r\n          "type": "numlist",\r\n          "start": 1,\r\n          "count": 100,\r\n          "inc": 1,\r\n          "asc": true\r\n        }\r\n      },\r\n      "Kernel": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.kernelName}",\r\n        "hidden": false\r\n      },\r\n      "MirrorEdges": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.mirrorEdgesName}",\r\n        "hidden": true,\r\n        "defaultValue": false\r\n      }\r\n    }\r\n  },\r\n  "StatisticsHistogramFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "Statistics": {\r\n        "required": true,\r\n        "dataType": "rasterstatisticsarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.statisticsName}",\r\n        "hidden": false\r\n      },\r\n      "Histograms": {\r\n        "required": true,\r\n        "dataType": "rasterhistogramarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.histogramsName}",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "WeightedOverlayFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Rasters": {\r\n        "required": true,\r\n        "dataType": "rasterarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.rastersName}",\r\n        "hidden": false\r\n      },\r\n      "Influences": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.influencesName}",\r\n        "hidden": false\r\n      },\r\n      "Fields": {\r\n        "required": true,\r\n        "dataType": "stringarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.fieldsName}",\r\n        "hidden": false\r\n      },\r\n      "Remaps": {\r\n        "required": true,\r\n        "dataType": "stringarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.remapsName}",\r\n        "hidden": false\r\n      },\r\n      "EvalFrom": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.evalFromName}",\r\n        "hidden": false,\r\n        "defaultValue": 1\r\n      },\r\n      "EvalTo": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.evalToName}",\r\n        "hidden": false,\r\n        "defaultValue": 9\r\n      },\r\n      "CellsizeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.cellsizeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 2,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriCellsizeTypes"\r\n        }\r\n      },\r\n      "ExtentType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.extentTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriExtentTypes"\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "WeightedSumFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Rasters": {\r\n        "required": true,\r\n        "dataType": "rasterarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.rastersName}",\r\n        "hidden": false\r\n      },\r\n      "Fields": {\r\n        "required": true,\r\n        "dataType": "stringarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.fieldsName}",\r\n        "hidden": false\r\n      },\r\n      "Weights": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.weightsName}",\r\n        "hidden": false\r\n      },\r\n      "CellsizeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.cellsizeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 2,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriCellsizeTypes"\r\n        }\r\n      },\r\n      "ExtentType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.extentTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriExtentTypes"\r\n        }\r\n      }\r\n    },\r\n    "editorArgumentOverride": {\r\n      "active": true,\r\n      "overrides": [\r\n        {\r\n          "argumentNames": [\r\n            "Rasters",\r\n            "Fields",\r\n            "Weights"\r\n          ],\r\n          "widget": {\r\n            "path": "esri/dijit/RasterFunctionEditor/RFxWeightedSumTableEditor"\r\n          }\r\n        }\r\n      ]\r\n    }\r\n  },\r\n  "ElevationVoidFillFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.DEMName}",\r\n        "hidden": false\r\n      },\r\n      "ShortRangeIDWRadius": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.shortRangeIDWRadiusName}",\r\n        "hidden": false,\r\n        "defaultValue": -1\r\n      },\r\n      "MaxVoidWidth": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.maxVoidWidthName}",\r\n        "hidden": false,\r\n        "defaultValue": -1\r\n      }\r\n    }\r\n  },\r\n  "ContourFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "DEM": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "SigmaGaussian": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.sigmaGaussianName}",\r\n        "hidden": false,\r\n        "defaultValue": 2.5\r\n      },\r\n      "ContourType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.contourTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriContourTypes"\r\n        }\r\n      },\r\n      "ZBase": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.zBaseName}",\r\n        "hidden": false,\r\n        "defaultValue": 0\r\n      },\r\n      "NumberOfContours": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.numberOfContoursName}",\r\n        "hidden": false,\r\n        "defaultValue": 0\r\n      },\r\n      "ContourInterval": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.contourIntervalName}",\r\n        "hidden": false,\r\n        "defaultValue": 100\r\n      },\r\n      "NthContourLineInBold": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.nthContourLineInBoldName}",\r\n        "hidden": false,\r\n        "defaultValue": 5\r\n      },\r\n      "ZFactor": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.zFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 1\r\n      }\r\n    }\r\n  },\r\n  "RasterizeFeatureClassFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "FeatureClass": {\r\n        "required": true,\r\n        "dataType": "featureClass",\r\n        "displayName": "${rasterFunctions.rfxArgs.featureClassName}",\r\n        "hidden": false\r\n      },\r\n      "ClassIndexField": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.classIndexFieldName}",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "FeatureClass"\r\n        }\r\n      },\r\n      "ResolveOverlapMethod": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.resolveOverlapMethodName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriRasterizeResolveOverlapMethod"\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "ResampleFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ResamplingType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.resamplingTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "rstResamplingTypes"\r\n        }\r\n      },\r\n      "InputCellsize": {\r\n        "required": true,\r\n        "dataType": "cellsize",\r\n        "displayName": "${rasterFunctions.rfxArgs.inputCellsizeName}",\r\n        "hidden": false\r\n      },\r\n      "OutputCellsize": {\r\n        "required": true,\r\n        "dataType": "cellsize",\r\n        "displayName": "${rasterFunctions.rfxArgs.outputCellsizeName}",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "TesseledCapFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "RegionGrowFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "PointFeatureClass": {\r\n        "required": true,\r\n        "dataType": "featureClass",\r\n        "displayName": "${rasterFunctions.rfxArgs.pointFeatureClassName}",\r\n        "hidden": false\r\n      },\r\n      "MaxGrowthRadiusField": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.maxGrowthRadiusFieldName}",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "PointFeatureClass"\r\n        }\r\n      },\r\n      "SimilarityThresholdField": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.similarityThresholdFieldName}",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "PointFeatureClass"\r\n        }\r\n      },\r\n      "FillValueField": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.fillValueFieldName}",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "PointFeatureClass"\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "SegmentMeanShiftFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "SpectralDetail": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.spectralDetailName}",\r\n        "hidden": false,\r\n        "defaultValue": 15.5\r\n      },\r\n      "SpatialDetail": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.spatialDetailName}",\r\n        "hidden": false,\r\n        "defaultValue": 15\r\n      },\r\n      "MinNumPixelsPerSegment": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.minNumPixelsPerSegmentName}",\r\n        "hidden": false,\r\n        "defaultValue": 20\r\n      },\r\n      "BoundariesOnly": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.boundariesOnlyName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      }\r\n    }\r\n  },\r\n  "StatisticsFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "StatisticsType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.statisticsTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 3,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriFocalStatisticTypes"\r\n        }\r\n      },\r\n      "Rows": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.rowsName}",\r\n        "hidden": false,\r\n        "defaultValue": 3\r\n      },\r\n      "Columns": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.columnsName}",\r\n        "hidden": false,\r\n        "defaultValue": 3\r\n      },\r\n      "FillNoDataOnly": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.fillNoDataOnlyName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      }\r\n    }\r\n  },\r\n  "VectorFieldFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster1": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.raster1Name}",\r\n        "hidden": false\r\n      },\r\n      "Raster2": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.raster2Name}",\r\n        "hidden": false\r\n      },\r\n      "InputDataType": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.inputDataTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": "Unknown",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "uvMagDirUnkTypes"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                "Vector-MagDir"\r\n              ],\r\n              "active": [\r\n                "AngleReferenceSystem"\r\n              ],\r\n              "autoRevert": true\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "AngleReferenceSystem": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.angleReferenceSystemName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriAngleReferenceSystemTypes"\r\n        }\r\n      },\r\n      "OutputDataType": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.outputDataTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": "Vector-MagDir",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "uvMagDirTypes"\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "InterpolateIrregularDataFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "PointFeatureClass": {\r\n        "required": true,\r\n        "dataType": "featureClass",\r\n        "dataTypeAttributes": {\r\n          "type": "point",\r\n          "hasZ": true\r\n        },\r\n        "displayName": "${rasterFunctions.rfxArgs.inputSamplePointFeatureClassName}",\r\n        "hidden": false\r\n      },\r\n      "ValueField": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "displayName": "${rasterFunctions.rfxArgs.valueFieldName}",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "PointFeatureClass"\r\n        }\r\n      },\r\n      "RasterInfo": {\r\n        "required": true,\r\n        "dataType": "rasterinfo",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterInfoName}",\r\n        "hidden": false\r\n      },\r\n      "InterpolationMethod": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.interpolationMethodName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriInterpolateIrregularDataMethods"\r\n        }\r\n      },\r\n      "Radius": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.radiusName}",\r\n        "hidden": false,\r\n        "defaultValue": 0\r\n      }\r\n    }\r\n  },\r\n  "ReflectanceFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "RadianceGainValues": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.radianceGainValuesName}",\r\n        "hidden": false\r\n      },\r\n      "RadianceBiasValues": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.radianceBiasValuesName}",\r\n        "hidden": false\r\n      },\r\n      "ReflectanceGainValues": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.reflectedGainValuesName}",\r\n        "hidden": false\r\n      },\r\n      "ReflectanceBiasValues": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.reflectedBiasValuesName}",\r\n        "hidden": false\r\n      },\r\n      "SunElevation": {\r\n        "required": true,\r\n        "order": 1000,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.sunElevationName}",\r\n        "hidden": false,\r\n        "defaultValue": 0\r\n      },\r\n      "Albedo": {\r\n        "required": true,\r\n        "order": 1001,\r\n        "dataType": "boolean",\r\n        "displayName": "${rasterFunctions.rfxArgs.albedoName}",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      },\r\n      "ScaleFactor": {\r\n        "required": true,\r\n        "order": 1001,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.scaleFactorName}",\r\n        "hidden": false,\r\n        "defaultValue": 2147483647\r\n      },\r\n      "Offset": {\r\n        "required": true,\r\n        "order": 1001,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.offsetName}",\r\n        "hidden": false,\r\n        "defaultValue": 2147483647\r\n      }\r\n    }\r\n  },\r\n  "ThresholdFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ThresholdType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.thresholdTypeName}",\r\n        "hidden": true,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriRasterThresholdTypes"\r\n        }\r\n      },\r\n      "Thresholds": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "displayName": "${rasterFunctions.rfxArgs.thresholdsName}",\r\n        "hidden": true\r\n      }\r\n    }\r\n  },\r\n  "ArgStatisticsFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Rasters": {\r\n        "required": true,\r\n        "dataType": "rasterarray",\r\n        "displayName": "${rasterFunctions.rfxArgs.rastersName}",\r\n        "hidden": false\r\n      },\r\n      "ArgStatisticsType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.argStatisticsTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 0,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriArgStatisticsTypes"\r\n        },\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "values": [\r\n                0\r\n              ],\r\n              "active": [\r\n                "UndefinedClass"\r\n              ],\r\n              "inactive": [\r\n                "MinValue,MaxValue"\r\n              ],\r\n              "autoRevert": true\r\n            },\r\n            {\r\n              "values": [\r\n                1\r\n              ],\r\n              "active": [\r\n                "UndefinedClass"\r\n              ],\r\n              "inactive": [\r\n                "MinValue,MaxValue"\r\n              ],\r\n              "autoRevert": true\r\n            },\r\n            {\r\n              "values": [\r\n                2\r\n              ],\r\n              "active": [\r\n                ""\r\n              ],\r\n              "inactive": [\r\n                "UndefinedClass",\r\n                "MinValue",\r\n                "MaxValue"\r\n              ],\r\n              "autoRevert": true\r\n            },\r\n            {\r\n              "values": [\r\n                3\r\n              ],\r\n              "active": [\r\n                "MinValue",\r\n                "MaxValue"\r\n              ],\r\n              "inactive": [\r\n                "UndefinedClass"\r\n              ],\r\n              "autoRevert": true\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "UndefinedClass": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.undefinedClassName}",\r\n        "hidden": false,\r\n        "defaultValue": 100\r\n      },\r\n      "MinValue": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.minValueName}",\r\n        "hidden": false,\r\n        "defaultValue": 1\r\n      },\r\n      "MaxValue": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "displayName": "${rasterFunctions.rfxArgs.maxValueName}",\r\n        "hidden": false,\r\n        "defaultValue": 1\r\n      }\r\n    }\r\n  },\r\n  "ArithmeticFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "Raster2": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.raster2Name}",\r\n        "hidden": false\r\n      },\r\n      "Operation": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.operationName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriRasterArithmeticOperations"\r\n        }\r\n      },\r\n      "CellsizeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.cellsizeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 2,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriCellsizeTypes"\r\n        }\r\n      },\r\n      "ExtentType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.extentTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriExtentTypes"\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "ClipFunction": {\r\n    "description": "",\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.rasterName}",\r\n        "hidden": false\r\n      },\r\n      "ClippingType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.clippingTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriRasterClippingTypes"\r\n        }\r\n      },\r\n      "ClippingRaster": {\r\n        "required": false,\r\n        "dataType": "raster",\r\n        "displayName": "${rasterFunctions.rfxArgs.clippingRasterName}",\r\n        "hidden": false\r\n      },\r\n      "ClippingGeometry": {\r\n        "required": true,\r\n        "dataType": "geometry",\r\n        "displayName": "${rasterFunctions.rfxArgs.clippingGeometryName}",\r\n        "hidden": false\r\n      },\r\n      "Extent": {\r\n        "required": true,\r\n        "dataType": "extent",\r\n        "displayName": "${rasterFunctions.rfxArgs.extentName}",\r\n        "hidden": false\r\n      },\r\n      "UseInputFeatureGeometry": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "hidden": false\r\n      }\r\n    },\r\n    "editorArgumentOverride": {\r\n      "active": true,\r\n      "overrides": [\r\n        {\r\n          "argumentNames": [\r\n            "ClippingRaster",\r\n            "ClippingGeometry",\r\n            "Extent"\r\n          ],\r\n          "widget": {\r\n            "path": "esri/dijit/RasterFunctionEditor/RFxClippingGeometry"\r\n          }\r\n        }\r\n      ]\r\n    }\r\n  },\r\n  "RemapFunction": {\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "UseTable": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "hidden": false,\r\n        "editorStateTrigger": {\r\n          "active": true,\r\n          "triggers": [\r\n            {\r\n              "autoRevert": true,\r\n              "values": [\r\n                true\r\n              ],\r\n              "active": [\r\n                "Table",\r\n                "InputField",\r\n                "OutputField",\r\n                "InputMaxField",\r\n                "RemapTableType"\r\n              ],\r\n              "inactive": [\r\n                "InputRanges",\r\n                "OutputValues",\r\n                "NoDataRanges"\r\n              ]\r\n            }\r\n          ]\r\n        }\r\n      },\r\n      "InputRanges": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "hidden": false\r\n      },\r\n      "OutputRanges": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "hidden": false\r\n      },\r\n      "NoDataRanges": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "hidden": false\r\n      },\r\n      "Table": {\r\n        "required": true,\r\n        "dataType": "table",\r\n        "hidden": false\r\n      },\r\n      "InputField": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "OutputField": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "InputMaxField": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "RemapTableType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "hidden": false\r\n      },\r\n      "AllowUnmatched": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "hidden": false\r\n      }\r\n    },\r\n    "editorArgumentOverride": {\r\n      "active": true,\r\n      "overrides": [\r\n        {\r\n          "argumentNames": [\r\n            "InputRanges",\r\n            "OutputValues",\r\n            "NoDataRanges"\r\n          ],\r\n          "widget": {\r\n            "path": "esri/dijit/RasterFunctionEditor/RFxRemapGrid"\r\n          }\r\n        }\r\n      ]\r\n    }\r\n  },\r\n  "NDVIFunction": {\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "VisibleBandID": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "bandIndex",\r\n          "argumentName": "Raster"\r\n        }\r\n      },\r\n      "InfraredBandID": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "bandIndex",\r\n          "argumentName": "Raster"\r\n        }\r\n      },\r\n      "ScientificOutput": {\r\n        "required": true,\r\n        "dataType": "boolean",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "BandArithmeticFunction": {\r\n    "rasterFunctionArguments": {\r\n      "Raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "Method": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "bandArithmeticMethods"\r\n        }\r\n      },\r\n      "BandIndexes": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "ConstantFunction": {\r\n    "rasterFunctionArguments": {\r\n      "Constant": {\r\n        "required": true,\r\n        "dataType": "doublearray",\r\n        "hidden": false,\r\n        "defaultValue": [1]\r\n      },\r\n      "RasterInfo": {\r\n        "required": true,\r\n        "dataType": "rasterinfo",\r\n        "hidden": false\r\n      },\r\n      "Statistics": {\r\n        "required": false,\r\n        "dataType": "rasterstatisticsarray",\r\n        "hidden": true\r\n      }\r\n    }\r\n  },\r\n  "CostAllocation": {\r\n    "rasterFunctionArguments": {\r\n      "ToolName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "CostAllocation_sa"\r\n      },\r\n      "PrimaryInputParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "in_source_data"\r\n      },\r\n      "OutputRasterParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "out_allocation_raster"\r\n      },\r\n      "in_source_data": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "source_field": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "in_source_data"\r\n        }\r\n      },\r\n      "in_cost_raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "maximum_distance": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "in_value_raster": {\r\n        "required": false,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "source_cost_multiplier": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_start_cost": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_resistance_rate": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_capacity": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_direction": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "CostDistance": {\r\n    "rasterFunctionArguments": {\r\n      "ToolName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "CostDistance_sa"\r\n      },\r\n      "PrimaryInputParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "in_source_data"\r\n      },\r\n      "OutputRasterParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "out_distance_raster"\r\n      },\r\n      "in_source_data": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "in_cost_raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "maximum_distance": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "source_cost_multiplier": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_start_cost": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_resistance_rate": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_capacity": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_direction": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "EucAllocation": {\r\n    "rasterFunctionArguments": {\r\n      "ToolName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "EucAllocation_sa"\r\n      },\r\n      "PrimaryInputParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "in_source_data"\r\n      },\r\n      "OutputRasterParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "out_allocation_raster"\r\n      },\r\n      "in_source_data": {\r\n        "required": false,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "source_field": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "in_source_data"\r\n        }\r\n      },\r\n      "maximum_distance": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "in_value_raster": {\r\n        "required": false,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "cell_size": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "EucDistance": {\r\n    "rasterFunctionArguments": {\r\n      "ToolName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "EucDistance_sa"\r\n      },\r\n      "PrimaryInputParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "in_source_data"\r\n      },\r\n      "OutputRasterParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "out_distance_raster"\r\n      },\r\n      "in_source_data": {\r\n        "required": false,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "source_field": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "in_source_data"\r\n        }\r\n      },\r\n      "maximum_distance": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "cell_size": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "KernelDensity": {\r\n    "rasterFunctionArguments": {\r\n      "ToolName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "KernelDensity_sa"\r\n      },\r\n      "PrimaryInputParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "in_features"\r\n      },\r\n      "OutputRasterParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "out_raster"\r\n      },\r\n      "RasterInfo": {\r\n        "required": true,\r\n        "dataType": "rasterinfo",\r\n        "hidden": true,\r\n        "defaultValue": {\r\n          "pixelType": 9,\r\n          "bandCount": 1\r\n        }\r\n      },\r\n      "in_features": {\r\n        "required": true,\r\n        "dataType": "featureclass",\r\n        "hidden": false\r\n      },\r\n      "population_field": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "defaultValue": "NONE",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "in_features"\r\n        }\r\n      },\r\n      "cell_size": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "area_unit_scale_factor": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "SQUARE_MAP_UNITS",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "gpsaKernelDensityAreaUnitTypes"\r\n        }\r\n      },\r\n      "out_cell_values": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "DENSITIES",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "gpsaKernelDensityOutValTypes"\r\n        }\r\n      },\r\n      "method": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "PLANAR",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "gpsaKernelDensityMethods"\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "ShortestPath": {\r\n    "rasterFunctionArguments": {\r\n      "ToolName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "ShortestPath"\r\n      },\r\n      "PrimaryInputParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "in_source_data"\r\n      },\r\n      "OutputRasterParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "out_path_raster"\r\n      },\r\n      "in_source_data": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "in_destination_data": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "destination_field": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "in_destination_data"\r\n        }\r\n      },\r\n      "in_cost_raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "path_type": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "gpsaLeastCostPathTypes"\r\n        }\r\n      },\r\n      "maximum_distance": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "source_cost_multiplier": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_start_cost": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_resistance_rate": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_capacity": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "source_direction": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "Viewshed2": {\r\n    "rasterFunctionArguments": {\r\n      "ToolName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "Viewshed2_sa"\r\n      },\r\n      "PrimaryInputParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "in_raster"\r\n      },\r\n      "OutputRasterParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "out_raster"\r\n      },\r\n      "in_raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "in_observer_features": {\r\n        "required": true,\r\n        "dataType": "featureclass",\r\n        "hidden": false\r\n      },\r\n      "analysis_method": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "ALL_SIGHTLINES",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "gpsaViewshedAnalysisMethods"\r\n        }\r\n      },\r\n      "analysis_type": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "FREQUENCY",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "gpsaViewshedAnalysisTypes"\r\n        }\r\n      },\r\n      "vertical_error": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "0 Meters"\r\n      },\r\n      "refractivity_coefficient": {\r\n        "required": false,\r\n        "dataType": "double",\r\n        "hidden": false,\r\n        "defaultValue": 0.13\r\n      },\r\n      "surface_offset": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "0 Meters"\r\n      },\r\n      "observer_elevation": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "observer_offset": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "1 Meters"\r\n      },\r\n      "inner_radius": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "inner_radius_is_3d": {\r\n        "required": false,\r\n        "dataType": "boolean",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      },\r\n      "outer_radius": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "outer_radius_is_3d": {\r\n        "required": false,\r\n        "dataType": "boolean",\r\n        "hidden": false,\r\n        "defaultValue": false\r\n      },\r\n      "horizontal_start_angle": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "0"\r\n      },\r\n      "horizontal_end_angle": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "360"\r\n      },\r\n      "vertical_upper_angle": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "90"\r\n      },\r\n      "vertical_lower_angle": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "-90"\r\n      }\r\n    }\r\n  },\r\n  "ZonalStatistics": {\r\n    "rasterFunctionArguments": {\r\n      "ToolName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "ZonalStatistics_sa"\r\n      },\r\n      "PrimaryInputParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "in_zone_data"\r\n      },\r\n      "OutputRasterParameterName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true,\r\n        "defaultValue": "out_raster"\r\n      },\r\n      "in_zone_data": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "zone_field": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "fields",\r\n          "argumentName": "in_zone_data"\r\n        }\r\n      },\r\n      "in_value_raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "statistics_type": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "MEAN",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "gpsaZonalStatisticsTypes"\r\n        }\r\n      },\r\n      "ignore_nodata": {\r\n        "required": false,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "defaultValue": "DATA",\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "gpsaIgnoreNoData"\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "HeatIndex": {\r\n    "rasterFunctionArguments": {\r\n      "PythonModule": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "ClassName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "temperature": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "units": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "pyStdTemperatureUnitTypes"\r\n        }\r\n      },\r\n      "outunits": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "pyStdTemperatureUnitTypes"\r\n        }\r\n      },\r\n      "rh": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "Windchill": {\r\n    "rasterFunctionArguments": {\r\n      "PythonModule": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "ClassName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "temperature": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "tunits": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "pyStdTemperatureUnitTypes"\r\n        }\r\n      },\r\n      "ounits": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "pyStdTemperatureUnitTypes"\r\n        }\r\n      },\r\n      "ws": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "wunits": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "pyStdWindspeedUnitTypes"\r\n        }\r\n      }\r\n    }\r\n  },\r\n  "KeyMetadata": {\r\n    "rasterFunctionArguments": {\r\n      "PythonModule": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "ClassName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "raster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "property": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "value": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "bands": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "json": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "RasterizeAttributes": {\r\n    "rasterFunctionArguments": {\r\n      "PythonModule": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "ClassName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "vraster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "zraster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "ztable": {\r\n        "required": true,\r\n        "dataType": "rstring",\r\n        "hidden": false\r\n      },\r\n      "zid": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "attribs": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "background": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "where": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n  "ZonalRemap": {\r\n    "rasterFunctionArguments": {\r\n      "PythonModule": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "ClassName": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": true\r\n      },\r\n      "vraster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "zraster": {\r\n        "required": true,\r\n        "dataType": "raster",\r\n        "hidden": false\r\n      },\r\n      "ztable": {\r\n        "required": true,\r\n        "dataType": "rstring",\r\n        "hidden": false\r\n      },\r\n      "zid": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "zmin": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "zmax": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "zval": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      },\r\n      "background": {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "defzval":  {\r\n        "required": true,\r\n        "dataType": "double",\r\n        "hidden": false\r\n      },\r\n      "where": {\r\n        "required": true,\r\n        "dataType": "string",\r\n        "hidden": false\r\n      }\r\n    }\r\n  },\r\n\r\n  "LocalFunction": {\r\n    "rasterFunctionArguments": {\r\n      "Operation": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "hidden": false,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "localFunctionOperations"\r\n        }\r\n      },\r\n      "ExtentType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.extentTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 1,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriExtentTypes"\r\n        }\r\n      },\r\n      "CellsizeType": {\r\n        "required": true,\r\n        "dataType": "long",\r\n        "displayName": "${rasterFunctions.rfxArgs.cellsizeTypeName}",\r\n        "hidden": false,\r\n        "defaultValue": 2,\r\n        "domain": {\r\n          "type": "list",\r\n          "enum": "esriCellsizeTypes"\r\n        }\r\n      }\r\n    }\r\n  }\r\n}',
"url:esri/layers/support/rasterFunctionResources.json":'{\r\n  "dataTypes": {\r\n    "raster": "raster",\r\n    "long": "long",\r\n    "double": "double",\r\n    "string": "string",\r\n    "longArray": "longarray",\r\n    "stringArray": "stringarray",\r\n    "doubleArray": "doublearray",\r\n    "rasterArray": "rasterarray",\r\n    "colorRamp": "colorramp",\r\n    "boolean": "boolean",\r\n    "arrayOfRasterStatistics": "arrayofrasterstatistics",\r\n    "arrayOfRasterHistogram": "arrayofrasterhistogram",\r\n    "table": "table",\r\n    "rasterStatisticsArray": "rasterstatisticsarray",\r\n    "rasterHistogramArray": "rasterhistogramarray",\r\n    "featureClass": "featureclass",\r\n    "geometry": "geometry",\r\n    "extent": "extent",\r\n    "rasterInfo": "rasterinfo",\r\n    "cellSize": "cellsize"\r\n  },\r\n  "enums": {\r\n    "colorSchemeTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.clrSchemeTypeColormap}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.clrSchemeTypeColorRamp}"\r\n      }\r\n    ],\r\n    "colormapTypes": [\r\n      {\r\n        "key": "Gray",\r\n        "label": "${rasterFunctions.enumLabels.colormapTypeGray}"\r\n      },\r\n      {\r\n        "key": "NDVI",\r\n        "label": "${rasterFunctions.enumLabels.colormapTypeNDVI}"\r\n      },\r\n      {\r\n        "key": "NDVI2",\r\n        "label": "${rasterFunctions.enumLabels.colormapTypeNDVI2}"\r\n      },\r\n      {\r\n        "key": "NDVI3",\r\n        "label": "${rasterFunctions.enumLabels.colormapTypeNDVI3}"\r\n      },\r\n      {\r\n        "key": "Random",\r\n        "label": "${rasterFunctions.enumLabels.colormapTypeRandom}"\r\n      }\r\n    ],\r\n    "bandComboMethods": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.bandComboByNames}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.bandComboByWavelength}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.bandComboByIDs}"\r\n      }\r\n    ],\r\n    "esriMissingBandActions": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.missingBandActionBestMatch}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.missingBandActionFail}"\r\n      }\r\n    ],\r\n    "esriHillshadeTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.hillshadeTypeSimple}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.hillshadeTypeMultidirectional}"\r\n      }\r\n    ],\r\n    "esriSlopeTypes13": [\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.none}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.slopeTypeAdjusted}"\r\n      }\r\n    ],\r\n    "esriSlopeTypes": [\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.slopeTypeDegree}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.slopeTypePercentRise}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.slopeTypeScaled}"\r\n      }\r\n    ],\r\n    "esriUnitConversionFxUnitTypes": [\r\n      {\r\n        "key": 200,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeCelsius}"\r\n      },\r\n      {\r\n        "key": 8,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeCentimeters}"\r\n      },\r\n      {\r\n        "key": 12,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeDecimeters}"\r\n      },\r\n      {\r\n        "key": 201,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeFahrenheit}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeFeet}"\r\n      },\r\n      {\r\n        "key": 103,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeFeetPerSec}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeInches}"\r\n      },\r\n      {\r\n        "key": 202,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeKelvin}"\r\n      },\r\n      {\r\n        "key": 10,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeKilometers}"\r\n      },\r\n      {\r\n        "key": 101,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeKmsPerHour}"\r\n      },\r\n      {\r\n        "key": 102,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeKnots}"\r\n      },\r\n      {\r\n        "key": 9,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMeters}"\r\n      },\r\n      {\r\n        "key": 100,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMetersPerSec}"\r\n      },\r\n      {\r\n        "key": 5,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMiles}"\r\n      },\r\n      {\r\n        "key": 104,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMilesPerHour}"\r\n      },\r\n      {\r\n        "key": 7,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMillimeters}"\r\n      },\r\n      {\r\n        "key": 6,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeNauticalMiles}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.unitTypeYards}"\r\n      }\r\n    ],\r\n    "esriRasterStretchTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.none}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.stretchTypeStdDev}"\r\n      },\r\n      {\r\n        "key": 5,\r\n        "label": "${rasterFunctions.enumLabels.stretchTypeMinMax}"\r\n      },\r\n      {\r\n        "key": 6,\r\n        "label": "${rasterFunctions.enumLabels.stretchTypePercentMinMax}"\r\n      },\r\n      {\r\n        "key": 9,\r\n        "label": "${rasterFunctions.enumLabels.stretchTypeSigmoid}"\r\n      }\r\n    ],\r\n    "esriCellsizeTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.cellsizeTypeFirst}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.cellsizeTypeMin}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.cellsizeTypeMax}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.cellsizeTypeMean}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.cellsizeTypeLast}"\r\n      }\r\n    ],\r\n    "esriExtentTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.extentTypeFirst}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.extentTypeIntersection}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.extentTypeUnion}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.extentTypeLast}"\r\n      }\r\n    ],\r\n    "esriNoDataInterpretationTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.noDataInterpretAny}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.noDataInterpretAll}"\r\n      }\r\n    ],\r\n    "esriCurvatureTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.curvatureTypeStandard}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.curvatureTypeProfile}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.curvatureTypePlanform}"\r\n      }\r\n    ],\r\n    "esriRasterFilterTypes": [\r\n      {\r\n        "key": 255,\r\n        "label": "${rasterFunctions.enumLabels.none}"\r\n      },\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeLineDetectionHorizontal}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeLineDetectionVertical}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeLineDetectionLeftDiagonal}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeLineDetectionRightDiagonal}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeGradientNorth}"\r\n      },\r\n      {\r\n        "key": 5,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeGradientWest}"\r\n      },\r\n      {\r\n        "key": 6,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeGradientEast}"\r\n      },\r\n      {\r\n        "key": 7,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeGradientSouth}"\r\n      },\r\n      {\r\n        "key": 8,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeGradientNorthEast}"\r\n      },\r\n      {\r\n        "key": 9,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeGradientNorthWest}"\r\n      },\r\n      {\r\n        "key": 10,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSmoothArithmeticMean}"\r\n      },\r\n      {\r\n        "key": 11,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSmoothing3x3}"\r\n      },\r\n      {\r\n        "key": 12,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSmoothing5x5}"\r\n      },\r\n      {\r\n        "key": 13,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSharpening3x3}"\r\n      },\r\n      {\r\n        "key": 14,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSharpening5x5}"\r\n      },\r\n      {\r\n        "key": 15,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeLaplacian3x3}"\r\n      },\r\n      {\r\n        "key": 16,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeLaplacian5x5}"\r\n      },\r\n      {\r\n        "key": 17,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSobelHorizontal}"\r\n      },\r\n      {\r\n        "key": 18,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSobelVertical}"\r\n      },\r\n      {\r\n        "key": 19,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSharpen}"\r\n      },\r\n      {\r\n        "key": 20,\r\n        "label": "${rasterFunctions.enumLabels.filterTypeSharpen2}"\r\n      },\r\n      {\r\n        "key": 21,\r\n        "label": "${rasterFunctions.enumLabels.filterTypePointSpread}"\r\n      },\r\n      {\r\n        "key": -1,\r\n        "label": "${rasterFunctions.enumLabels.userDefined}"\r\n      }\r\n    ],\r\n    "esriContourTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.ContourTypeLines}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.ContourTypeFill}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.ContourTypeSmoothOnly}"\r\n      }\r\n    ],\r\n    "esriRasterizeResolveOverlapMethod": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.rasterizeKeepFirst}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.rasterizeKeepLast}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.rasterizeKeepSmallest}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.rasterizeKeepLargest}"\r\n      }\r\n    ],\r\n    "rstResamplingTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeNearest}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeBilinear}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeCubic}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeMajority}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeBilinearPlus}"\r\n      },\r\n      {\r\n        "key": 5,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeGauss}"\r\n      },\r\n      {\r\n        "key": 6,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeGaussPlus}"\r\n      },\r\n      {\r\n        "key": 7,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeAverage}"\r\n      },\r\n      {\r\n        "key": 8,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeMinimum}"\r\n      },\r\n      {\r\n        "key": 9,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeMaximum}"\r\n      },\r\n      {\r\n        "key": 10,\r\n        "label": "${rasterFunctions.enumLabels.resamplingTypeVectorAvg}"\r\n      }\r\n    ],\r\n    "esriFocalStatisticTypes": [\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.minimum}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.maximum}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.mean}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.stdDeviation}"\r\n      }\r\n    ],\r\n    "uvMagDirUnkTypes": [\r\n      {\r\n        "key": "Vector-UV",\r\n        "label": "${rasterFunctions.enumLabels.uvMagDirTypeUV}"\r\n      },\r\n      {\r\n        "key": "Vector-MagDir",\r\n        "label": "${rasterFunctions.enumLabels.uvMagDirTypeMagDir}"\r\n      },\r\n      {\r\n        "key": "Unknown",\r\n        "label": "${rasterFunctions.enumLabels.unknown}"\r\n      }\r\n    ],\r\n    "esriAngleReferenceSystemTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.angleRefSysGeographic}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.angleRefSysArithmetic}"\r\n      }\r\n    ],\r\n    "uvMagDirTypes": [\r\n      {\r\n        "key": "Vector-UV",\r\n        "label": "${rasterFunctions.enumLabels.uvMagDirTypeUV}"\r\n      },\r\n      {\r\n        "key": "Vector-MagDir",\r\n        "label": "${rasterFunctions.enumLabels.uvMagDirTypeMagDir}"\r\n      }\r\n    ],\r\n    "esriInterpolateIrregularDataMethods": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.interpolateIrregularDataNearest}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.interpolateIrregularDataTinningLinear}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.interpolateIrregularDataTinningNaturalNeighbor}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.interpolateIrregularDataTinningIDW}"\r\n      }\r\n    ],\r\n    "esriRasterThresholdTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.esriRasterThresholdTypeConstant}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.esriRasterThresholdTypeOtsu}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.esriRasterThresholdTypeTsai}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.esriRasterThresholdTypeKapur}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.esriRasterThresholdTypeKittler}"\r\n      },\r\n      {\r\n        "key": 5,\r\n        "label": "${rasterFunctions.enumLabels.esriRasterThresholdTypeRosin}"\r\n      }\r\n    ],\r\n    "esriArgStatisticsTypes": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.argStatsTypeMax}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.argStatsTypeMin}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.argStatsTypeMedian}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.argStatsTypeDuration}"\r\n      }\r\n    ],\r\n    "esriRasterArithmeticOperations": [\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.arithmeticOpPlus}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.arithmeticOpMinus}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.arithmeticOpMultiply}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.arithmeticOpDivide}"\r\n      },\r\n      {\r\n        "key": 5,\r\n        "label": "${rasterFunctions.enumLabels.arithmeticOpPower}"\r\n      },\r\n      {\r\n        "key": 6,\r\n        "label": "${rasterFunctions.enumLabels.arithmeticOpMode}"\r\n      }\r\n    ],\r\n    "esriRasterClippingTypes": [\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.clipTypeOutside}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.clipTypeInside}"\r\n      }\r\n    ],\r\n    "gpsaIgnoreNoData": [\r\n      {\r\n        "key": "DATA",\r\n        "label": "${rasterFunctions.enumLabels.yes}"\r\n      },\r\n      {\r\n        "key": "NODATA",\r\n        "label": "${rasterFunctions.enumLabels.no}"\r\n      }\r\n    ],\r\n    "gpsaKernelDensityAreaUnitTypes": [\r\n      {\r\n        "key": "SQUARE_MAP_UNITS",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqMapUnits}"\r\n      },\r\n      {\r\n        "key": "SQUARE_MILES",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqMiles}"\r\n      },\r\n      {\r\n        "key": "SQUARE_KILOMETERS",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqKms}"\r\n      },\r\n      {\r\n        "key": "ACRES",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeAcres}"\r\n      },\r\n      {\r\n        "key": "HECTARES",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeHectares}"\r\n      },\r\n      {\r\n        "key": "SQUARE_YARDS",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqYards}"\r\n      },\r\n      {\r\n        "key": "SQUARE_FEET",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqFt}"\r\n      },\r\n      {\r\n        "key": "SQUARE_INCHES",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqInches}"\r\n      },\r\n      {\r\n        "key": "SQUARE_METERS",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqMts}"\r\n      },\r\n      {\r\n        "key": "SQUARE_CENTIMETERS",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqCms}"\r\n      },\r\n      {\r\n        "key": "SQUARE_MILLIMETERS",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeSqMms}"\r\n      }\r\n    ],\r\n    "gpsaKernelDensityOutValTypes": [\r\n      {\r\n        "key": "DENSITIES",\r\n        "label": "${rasterFunctions.enumLabels.densities}"\r\n      },\r\n      {\r\n        "key": "EXPECTED_COUNTS",\r\n        "label": "${rasterFunctions.enumLabels.expectedCounts}"\r\n      }\r\n    ],\r\n    "gpsaKernelDensityMethods": [\r\n      {\r\n        "key": "DENSITIES",\r\n        "label": "${rasterFunctions.enumLabels.planar}"\r\n      },\r\n      {\r\n        "key": "EXPECTED_COUNTS",\r\n        "label": "${rasterFunctions.enumLabels.geodesic}"\r\n      }\r\n    ],\r\n    "gpsaLinearUnitTypes": [\r\n      {\r\n        "key": "Kilometers",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeKilometers}"\r\n      },\r\n      {\r\n        "key": "Meters",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMeters}"\r\n      },\r\n      {\r\n        "key": "Decimeters",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeDecimeters}"\r\n      },\r\n      {\r\n        "key": "Centimeters",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeCentimeters}"\r\n      },\r\n      {\r\n        "key": "Millimeters",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMillimeters}"\r\n      },\r\n      {\r\n        "key": "NauticalMiles",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeNauticalMiles}"\r\n      },\r\n      {\r\n        "key": "Miles",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMiles}"\r\n      },\r\n      {\r\n        "key": "Yards",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeYards}"\r\n      },\r\n      {\r\n        "key": "Feet",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeFeet}"\r\n      },\r\n      {\r\n        "key": "Inches",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeInches}"\r\n      },\r\n      {\r\n        "key": "DecimalDegrees",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeDecimalDegrees}"\r\n      },\r\n      {\r\n        "key": "Points",\r\n        "label": "${rasterFunctions.enumLabels.unitTypePoints}"\r\n      },\r\n      {\r\n        "key": "Unknown",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeUnknown}"\r\n      }\r\n    ],\r\n    "gpsaLeastCostPathTypes": [\r\n      {\r\n        "key": "EACH_CELL",\r\n        "label": "${rasterFunctions.enumLabels.eachCell}"\r\n      },\r\n      {\r\n        "key": "EACH_ZONE",\r\n        "label": "${rasterFunctions.enumLabels.eachZone}"\r\n      },\r\n      {\r\n        "key": "BEST_SINGLE",\r\n        "label": "${rasterFunctions.enumLabels.bestSingle}"\r\n      }\r\n    ],\r\n    "gpsaViewshedAnalysisMethods": [\r\n      {\r\n        "key": "ALL_SIGHTLINES",\r\n        "label": "${rasterFunctions.enumLabels.allSightlines}"\r\n      },\r\n      {\r\n        "key": "PERIMETER_SIGHTLINES",\r\n        "label": "${rasterFunctions.enumLabels.perimeterSightlines}"\r\n      }\r\n    ],\r\n    "gpsaViewshedAnalysisTypes": [\r\n      {\r\n        "key": "FREQUENCY",\r\n        "label": "${rasterFunctions.enumLabels.frequency}"\r\n      },\r\n      {\r\n        "key": "PERIMETER_SIGHTLINES",\r\n        "label": "${rasterFunctions.enumLabels.observers}"\r\n      }\r\n    ],\r\n    "gpsaZonalStatisticsTypes": [\r\n      {\r\n        "key": "MEAN",\r\n        "label": "${rasterFunctions.enumLabels.mean}"\r\n      },\r\n      {\r\n        "key": "MAJORITY",\r\n        "label": "${rasterFunctions.enumLabels.majority}"\r\n      },\r\n      {\r\n        "key": "MAXIMUM",\r\n        "label": "${rasterFunctions.enumLabels.maximum}"\r\n      },\r\n      {\r\n        "key": "MEDIAN",\r\n        "label": "${rasterFunctions.enumLabels.median}"\r\n      },\r\n      {\r\n        "key": "MINIMUM",\r\n        "label": "${rasterFunctions.enumLabels.minimum}"\r\n      },\r\n      {\r\n        "key": "MINORITY",\r\n        "label": "${rasterFunctions.enumLabels.minority}"\r\n      },\r\n      {\r\n        "key": "RANGE",\r\n        "label": "${rasterFunctions.enumLabels.range}"\r\n      },\r\n      {\r\n        "key": "STD",\r\n        "label": "${rasterFunctions.enumLabels.stdDeviation}"\r\n      },\r\n      {\r\n        "key": "SUM",\r\n        "label": "${rasterFunctions.enumLabels.sum}"\r\n      },\r\n      {\r\n        "key": "VARIETY",\r\n        "label": "${rasterFunctions.enumLabels.variety}"\r\n      }\r\n    ],\r\n    "bandArithmeticMethods": [\r\n      {\r\n        "key": 0,\r\n        "label": "${rasterFunctions.enumLabels.userDefined}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.ndvi}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.savi}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.bandArithmeticMethodTSAVI}"\r\n      },\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.bandArithmeticMethodMSAVI}"\r\n      },\r\n      {\r\n        "key": 5,\r\n        "label": "${rasterFunctions.enumLabels.gemi}"\r\n      },\r\n      {\r\n        "key": 6,\r\n        "label": "${rasterFunctions.enumLabels.pvi}"\r\n      },\r\n      {\r\n        "key": 7,\r\n        "label": "${rasterFunctions.enumLabels.gvi}"\r\n      },\r\n      {\r\n        "key": 8,\r\n        "label": "${rasterFunctions.enumLabels.bandArithmeticMethodSultan}"\r\n      }\r\n    ],\r\n    "pyStdTemperatureUnitTypes": [\r\n       {\r\n        "key": "Celsius",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeCelsius}"\r\n      },\r\n      {\r\n        "key": "Fahrenheit",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeFahrenheit}"\r\n      },\r\n      {\r\n        "key": "Kelvin",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeKelvin}"\r\n      }\r\n    ],\r\n    "pyStdWindspeedUnitTypes": [\r\n      {\r\n        "key": "mph",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMilesPerHour}"\r\n      },\r\n      {\r\n        "key": "kph",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeKmsPerHour}"\r\n      },\r\n      {\r\n        "key": "m/s",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeMetersPerSec}"\r\n      },\r\n      {\r\n        "key": "ft/s",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeFeetPerSec}"\r\n      },\r\n      {\r\n        "key": "knots",\r\n        "label": "${rasterFunctions.enumLabels.unitTypeKnots}"\r\n      }\r\n    ],\r\n    "localFunctionOperations": [\r\n      {\r\n        "key": 4,\r\n        "label": "${rasterFunctions.enumLabels.localSquareRoot}"\r\n      },\r\n      {\r\n        "key": 6,\r\n        "label": "${rasterFunctions.enumLabels.localACos}"\r\n      },\r\n      {\r\n        "key": 7,\r\n        "label": "${rasterFunctions.enumLabels.localASin}"\r\n      },\r\n      {\r\n        "key": 8,\r\n        "label": "${rasterFunctions.enumLabels.localATan}"\r\n      },\r\n      {\r\n        "key": 9,\r\n        "label": "${rasterFunctions.enumLabels.localATanH}"\r\n      },\r\n      {\r\n        "key": 10,\r\n        "label": "${rasterFunctions.enumLabels.localAbs}"\r\n      },\r\n      {\r\n        "key": 13,\r\n        "label": "${rasterFunctions.enumLabels.localBitwiseNot}"\r\n      },\r\n      {\r\n        "key": 18,\r\n        "label": "${rasterFunctions.enumLabels.localBooleanNot}"\r\n      },\r\n      {\r\n        "key": 21,\r\n        "label": "${rasterFunctions.enumLabels.localCos}"\r\n      },\r\n      {\r\n        "key": 22,\r\n        "label": "${rasterFunctions.enumLabels.localCosH}"\r\n      },\r\n      {\r\n        "key": 25,\r\n        "label": "${rasterFunctions.enumLabels.localExp}"\r\n      },\r\n      {\r\n        "key": 26,\r\n        "label": "${rasterFunctions.enumLabels.localExp10}"\r\n      },\r\n      {\r\n        "key": 27,\r\n        "label": "${rasterFunctions.enumLabels.localExp2}"\r\n      },\r\n      {\r\n        "key": 30,\r\n        "label": "${rasterFunctions.enumLabels.localInt}"\r\n      },\r\n      {\r\n        "key": 31,\r\n        "label": "${rasterFunctions.enumLabels.localIsNull}"\r\n      },\r\n      {\r\n        "key": 32,\r\n        "label": "${rasterFunctions.enumLabels.localFloat}"\r\n      },\r\n      {\r\n        "key": 35,\r\n        "label": "${rasterFunctions.enumLabels.localLn}"\r\n      },\r\n      {\r\n        "key": 36,\r\n        "label": "${rasterFunctions.enumLabels.localLog10}"\r\n      },\r\n      {\r\n        "key": 37,\r\n        "label": "${rasterFunctions.enumLabels.localLog2}"\r\n      },\r\n      {\r\n        "key": 45,\r\n        "label": "${rasterFunctions.enumLabels.localNegate}"\r\n      },\r\n      {\r\n        "key": 48,\r\n        "label": "${rasterFunctions.enumLabels.localRoundDown}"\r\n      },\r\n      {\r\n        "key": 49,\r\n        "label": "${rasterFunctions.enumLabels.localRoundUp}"\r\n      },\r\n      {\r\n        "key": 51,\r\n        "label": "${rasterFunctions.enumLabels.localSin}"\r\n      },\r\n      {\r\n        "key": 52,\r\n        "label": "${rasterFunctions.enumLabels.localSinH}"\r\n      },\r\n      {\r\n        "key": 53,\r\n        "label": "${rasterFunctions.enumLabels.localSquare}"\r\n      },\r\n      {\r\n        "key": 56,\r\n        "label": "${rasterFunctions.enumLabels.localTan}"\r\n      },\r\n      {\r\n        "key": 57,\r\n        "label": "${rasterFunctions.enumLabels.localTanH}"\r\n      },\r\n      {\r\n        "key": 59,\r\n        "label": "${rasterFunctions.enumLabels.localACosH}"\r\n      },\r\n      {\r\n        "key": 60,\r\n        "label": "${rasterFunctions.enumLabels.localASinH}"\r\n      },\r\n      {\r\n        "key": 1,\r\n        "label": "${rasterFunctions.enumLabels.localPlus}"\r\n      },\r\n      {\r\n        "key": 2,\r\n        "label": "${rasterFunctions.enumLabels.localMinus}"\r\n      },\r\n      {\r\n        "key": 3,\r\n        "label": "${rasterFunctions.enumLabels.localTimes}"\r\n      },\r\n      {\r\n        "key": 5,\r\n        "label": "${rasterFunctions.enumLabels.localPower}"\r\n      },\r\n      {\r\n        "key": 11,\r\n        "label": "${rasterFunctions.enumLabels.localBitwiseAnd}"\r\n      },\r\n      {\r\n        "key": 12,\r\n        "label": "${rasterFunctions.enumLabels.localBitwiseLeftShift}"\r\n      },\r\n      {\r\n        "key": 14,\r\n        "label": "${rasterFunctions.enumLabels.localBitwiseOr}"\r\n      },\r\n      {\r\n        "key": 15,\r\n        "label": "${rasterFunctions.enumLabels.localBitwiseRightShift}"\r\n      },\r\n      {\r\n        "key": 16,\r\n        "label": "${rasterFunctions.enumLabels.localBitwiseXor}"\r\n      },\r\n      {\r\n        "key": 17,\r\n        "label": "${rasterFunctions.enumLabels.localBooleanAnd}"\r\n      },\r\n      {\r\n        "key": 19,\r\n        "label": "${rasterFunctions.enumLabels.localBooleanOr}"\r\n      },\r\n      {\r\n        "key": 20,\r\n        "label": "${rasterFunctions.enumLabels.localBooleanXor}"\r\n      },\r\n      {\r\n        "key": 23,\r\n        "label": "${rasterFunctions.enumLabels.localDivide}"\r\n      },\r\n      {\r\n        "key": 24,\r\n        "label": "${rasterFunctions.enumLabels.localEqualTo}"\r\n      },\r\n      {\r\n        "key": 28,\r\n        "label": "${rasterFunctions.enumLabels.localGreaterThan}"\r\n      },\r\n      {\r\n        "key": 29,\r\n        "label": "${rasterFunctions.enumLabels.localGreaterThanEqual}"\r\n      },\r\n      {\r\n        "key": 33,\r\n        "label": "${rasterFunctions.enumLabels.localLessThan}"\r\n      },\r\n      {\r\n        "key": 34,\r\n        "label": "${rasterFunctions.enumLabels.localLessThanEqual}"\r\n      },\r\n      {\r\n        "key": 44,\r\n        "label": "${rasterFunctions.enumLabels.localMod}"\r\n      },\r\n      {\r\n        "key": 46,\r\n        "label": "${rasterFunctions.enumLabels.localNotEqual}"\r\n      },\r\n      {\r\n        "key": 41,\r\n        "label": "${rasterFunctions.enumLabels.localATan2}"\r\n      }\r\n    ]\r\n\r\n  }\r\n}'}});
define("esri/dijit/RasterFunctionEditor/RFxArgsEditor","dojo/_base/declare dojo/_base/lang dojo/_base/array dojo/has dojo/string dojo/i18n!../../nls/jsapi dojo/dom-style dojo/dom-class dojo/dom-construct dojo/store/Memory dojo/data/ObjectStore dojo/json ../../lang ../../kernel ../../layers/RasterFunction dojo/text!../../layers/support/rasterFunctionSchema.json dojo/text!../../layers/support/rasterFunctionResources.json dijit/_WidgetBase dijit/_TemplatedMixin dijit/form/TextBox dijit/form/CheckBox dijit/form/NumberTextBox dijit/form/Select dijit/TitlePane dijit/Tooltip ./RFxArgSlider ./RFxBandMatrix ./RFxRasterArrayEditor ./RFxStatisticsGrid ./RFxBandIndexPicker ./utils ../ColorRampSelector ../../renderers/colorRampUtils".split(" "),
function(G,m,h,O,H,B,P,C,l,D,E,w,x,Q,Y,R,S,T,U,u,I,y,v,V,W,J,K,L,M,X,z,N,Z){var p,A,F,k;C=G([T,U],{declaredClass:"esri.dijit.RasterFunctionEditor.RFxArgsEditor",widgetsInTemplate:!0,templateString:"\x3cdiv class\x3d'esriRFxArgsEditor'\x3e\x3cdiv data-dojo-attach-point\x3d'_argsContainterNode'\x3e\x3c/div\x3e\x3c/div\x3e",_inputWidgets:[],_supportedDataTypes:"raster long double string longarray stringarray doublearray rasterarray colorramp boolean rasterstatisticsarray arrayofrasterstatistics cellsize".split(" "),
constructor:function(a){G.safeMixin(this,a);this._i18n=B.widgets.rasterFunctionEditor.rfxArgsEditor;this._rfxTemplate=m.clone(this.rfxTemplate);p=w.parse(H.substitute(R,B,m.hitch(this,this._substituteString)));F=(A=w.parse(H.substitute(S,B,m.hitch(this,this._substituteString))))&&A.enums;k=A&&A.dataTypes},startup:function(a){this.inherited(arguments)},postCreate:function(a){this.inherited(arguments);this.rfxTemplate&&(this._honorIsPublic=this._getHonorIsPublic(this.rfxTemplate),this._populateUI())},
destroy:function(){this._destroyInputWidgets();this.inherited(arguments)},reset:function(){},getName:function(){return this._rfxTemplate&&this._rfxTemplate.name},getRFT:function(a){a=a||this._rfxTemplate;var b=a.arguments,c,d;if(b)if(c=this._getArgRFT(b))"RasterFunctionVariable"===b.type?b.value=this.getRFT(c):a.arguments=this.getRFT(c);else if(this._hasRFTElements(b))h.forEach(b.value.elements,function(a,c){(d=this._getArgRFT(a))?b.value.elements[c]=this.getRFT(d):a.value=this._getArgumentValue({Raster:a})},
this);else if("RasterFunctionVariable"===b.type)b.value=this._getArgumentValue({Raster:b},a["function"]);else for(var f in b)if(b.hasOwnProperty(f)&&"type"!==f){var e=b[f];c={};if(c[f]=e)(d=this._getArgRFT(e))?"RasterFunctionVariable"===e.type?e.value=this.getRFT(d):b[f]=this.getRFT(d):this._hasRasterElements(e)?h.forEach(e.value.elements,function(a,b){(d=this._getArgRFT(a))?e.value.elements[b]=this.getRFT(d):a.value=this._getArgumentValue(a)},this):"RasterFunctionVariable"!==e.type||this._isColorRamp(e)?
this._isColorRamp(e)&&(b[f]=this._getArgumentValue(c,a["function"])):e.value=this._getArgumentValue(c,a["function"])}return this._cloneRFT(a,["input","uxBlocks"])},getFunctionArguments:function(){return z.getFunctionArguments(this._rfxTemplate,m.hitch(this,this._getArgumentValue))},_substituteString:function(a,b){if("undefined"===typeof a)throw Error(" RFxArgsEditor: "+b);return null===a?"":this._escapeValue(String(a))},_getHonorIsPublic:function(a){var b=a&&a.arguments;return a&&b?a.aliases?!0:h.some(Object.keys(b),
function(a){return(a=b[a])?this._hasRasterElements(a)?h.some(a.value&&a.value.elements,this._getHonorIsPublic,this):this._getHonorIsPublic(this._getArgRFT(a)):!1},this):!1},_hasRFTElements:function(a){if(a&&a.value&&a.value.elements)return h.some(a.value.elements,function(a){return a&&"RasterFunctionTemplate"===a.type})},_hasRasterElements:function(a){if(a&&a.value&&a.value.elements)return(a=a.value.elements[0])&&(a.isDataset||"RasterFunctionTemplate"===a.type)},_isColorRamp:function(a){if(!a)return!1;
if(a.type&&0<=a.type.toLowerCase().indexOf("colorramp")||a.value&&a.value.type&&0<=a.value.type.toLowerCase().indexOf("colorramp"))return!0},_getArgRFT:function(a){if(a){if("RasterFunctionTemplate"===a.type)return a;if(a.value&&"RasterFunctionTemplate"===a.value.type)return a.value}},_cloneRFT:function(a,b){var c={};if("object"===typeof a&&!(a instanceof Array)&&null!==a){for(var d in a)a.hasOwnProperty(d)&&0>h.indexOf(b,d)&&(c[d]=this._cloneRFT(a[d],b));return c}return m.clone(a)},_populateUI:function(){this._destroyInputWidgets();
l.empty(this._argsContainterNode);this._buildRFxTemplateUI(this._rfxTemplate)},_buildRFxTemplateUI:function(a){var b=a.arguments,c;a["function"]&&a.name&&b&&this._buildRFxUI(a);(a=this._getArgRFT(b))?this._buildRFxTemplateUI(a):this._hasRasterElements(b)&&h.forEach(b.value.elements,function(a){(c=this._getArgRFT(a))&&this._buildRFxTemplateUI(c)},this);for(var d in b)b.hasOwnProperty(d)&&"type"!==d&&(a=b[d],(c=this._getArgRFT(a))?this._buildRFxTemplateUI(c):this._hasRasterElements(a)&&h.forEach(a.value.elements,
function(a){(c=this._getArgRFT(a))&&this._buildRFxTemplateUI(c)},this))},_getFunctionSchema:function(a){if(a&&a["function"]&&a["function"].type){var b=a["function"].type;return"gpadapterfunction"===b.toLowerCase()?(a=a&&a.arguments&&a.arguments.ToolName,a=a.value&&a.value.replace("_sa",""),p[a]):"pythonadapterfunction"===b.toLowerCase()?(a=a&&a.arguments&&a.arguments.ClassName,p[a]):p[b]}},_getSchemaArgKey:function(a,b){if(a){var c=Object.keys(a),d;if(void 0===b&&1===c.length)return c[0];h.some(c,
function(a){a.toLowerCase()===(b&&b.toLowerCase())&&(d=a)});return d}},_buildRFxUI:function(a){var b,c=a.arguments,d,f=[],e=[],g,r=[],q=this._getFunctionSchema(a),n=q&&q.rasterFunctionArguments,q=q&&q.editorArgumentOverride&&q.editorArgumentOverride.active?q.editorArgumentOverride.overrides:null,k=l.create("table",{"class":"esriRFxArgsEditor__table"}),t=l.create("tbody",null,k),m=l.create("div",null,this._argsContainterNode,"first");if(!c||"RasterFunctionTemplate"!==c.type){if(c.type&&"RasterFunctionVariable"===
c.type)n&&(g=this._getSchemaArgKey(n),d=n[g]),this._isShown(c,d)&&this._buildRFxArgLayout(c,t,d);else{for(var p in c)c.hasOwnProperty(p)&&(n&&(g=this._getSchemaArgKey(n,p),d=n[g]),b=c[p])&&(q&&h.some(q,function(a){0<=h.indexOf(a.argumentNames,g)&&this._isOverrideWidgetShown(a.argumentNames,c)&&0>h.indexOf(e,g)&&(e=e.concat(a.argumentNames),this._buildOverrideWidgetLayout(a,c,t,n))},this),0>h.indexOf(e,g)&&b.type&&"RasterFunctionTemplate"!==b.type&&this._isShown(b,d)&&(d&&0>h.indexOf(this._supportedDataTypes,
d.dataType)?r.push(b.name||d.displayName):this._hasRasterElements(b)?h.forEach(b.value.elements,function(a){!this._getArgRFT(a)&&this._isShown(a,d)&&this._buildRFxArgLayout(a,t,d,c)},this):this._buildRFxArgLayout(b,t,d,c)),d&&d.editorStateTrigger&&d.editorStateTrigger.active&&f.push({rfxArg:b,schemaArgDef:d}));h.forEach(f,function(a){var d=b&&b.value;b=a.rfxArg;this._handleEditorStateTriggers(c,d,a.schemaArgDef)},this)}t.childNodes&&t.childNodes.length&&this._buildTitlePane(k,m,a["function"],r)}},
_isOverrideWidgetShown:function(a,b){var c;return h.some(a,function(a){c=this._getCaseInsenstitiveArg(a,b);if(this._isShown(c))return!0},this)},_isShown:function(a,b){return!a||this._honorIsPublic&&!a.isPublic||b&&b.hidden?!1:!0},_buildTitlePane:function(a,b,c,d){b=new V({title:c&&c.name,content:a},b);b.startup();a=m.hitch(this,function(a,b){this.own(new W({connectId:[a],label:"\x3cdiv class\x3d'esriRFxArgsEditor__label--fx-desc'\x3e"+b+"\x3c/div\x3e"}));a.onclick=function(a){a.stopPropagation()}});
if(b.titleNode){var f=l.create("a",{"class":"esriFloatTrailing helpIcon",style:"float: right; margin-right: -6px;"},b.titleNode);a(f,c&&c.description);d&&d.length&&(c=l.create("a",{"class":"esriRFxArgsEditor__icon--warning"},b.titleNode),d=this._i18n.unsupportedDataTypeWarning+"\x3cbr\x3e\x3cbr\x3e\x3cstrong\x3e"+d.join(",")+"\x3c/strong\x3e",a(c,d))}},_buildRFxArgLayout:function(a,b,c,d){var f,e,g;if(!("RasterFunctionTemplate"===a.type||a.value&&"RasterFunctionTemplate"===a.value.type)){e=(c&&c.dataType)===
k["boolean"];if((g=this._useRFxArgWidget(c))||e)f=l.create("tr",{"class":"esriRFxArgsEditor__tr"},b),a.uxBlocks=[f];return g?this._buildRFxWidgetLayout(f,a,c,d):e?this._buildBooleanLayout(f,a,c,d):this._buildStdTwoRowLayout(b,a,c,d)}},_useRFxArgWidget:function(a){return a&&a.domain&&"range"===a.domain.type},_createInputWidget:function(a,b,c,d){b=this._getWidget(a,b,c,d);b.startup();a.input=b;this._inputWidgets.push(b)},_createOverrideWidget:function(a,b,c){var d=new a(b,c),f=b&&b.inputArgs;d.startup();
this._inputWidgets.push(d);d.on("drawtool-activate",m.hitch(this,function(a){this.emit("drawtool-activate",a)}));d.on("drawtool-deactivate",m.hitch(this,function(a){this.emit("drawtool-deactivate",a)}));d.domNode&&f&&h.forEach(Object.keys(f),function(a){if(a=f[a])a.uxBlocks=[d.domNode]})},_buildOverrideWidgetLayout:function(a,b,c,d){if(a){var f={},e={},g,r;h.forEach(a.argumentNames,function(a){(g=this._getCaseInsenstitiveArg(a,b))&&(e[a]=g)},this);h.forEach(Object.keys(d),function(a){r=d[a];r.dataType===
k.raster&&(g=this._getCaseInsenstitiveArg(a,b))&&(f[a]=g)},this);try{require([a.widget.path],m.hitch(this,function(a){var b=l.create("tr",{"class":"esriRFxArgsEditor__tr"},c),b=l.create("td",null,b),b=l.create("div",null,b);this._createOverrideWidget(a,{rasterFunctionEnums:F,rasterFunctions:p,rasterArgs:f,inputArgs:e,inputLayers:this.inputLayers,map:this.map},b)}))}catch(q){console.error(q),h.forEach(Object.keys(e),function(a){g=e[a];r=this._getCaseInsenstitiveArg(a,d);this._buildRFxArgLayout(g,c,
r,b)},this)}}},_buildBooleanLayout:function(a,b,c,d){a=l.create("td",{innerHTML:b.name},a);a=l.create("div",null,a,"first");this._createInputWidget(b,a,c,d)},_buildStdTwoRowLayout:function(a,b,c,d){var f,e;f=l.create("tr",{"class":"esriRFxArgsEditor__tr--arg-name"},a);l.create("td",{innerHTML:b.name||c&&c.displayName},f);a=l.create("tr",{"class":"esriRFxArgsEditor__tr--arg-widget"},a);e=l.create("td",null,a);e=l.create("div",null,e);b.uxBlocks=[f,a];this._createInputWidget(b,e,c,d)},_buildRFxWidgetLayout:function(a,
b,c,d){a=l.create("td",null,a);a=l.create("div",null,a);this._createInputWidget(b,a,c,d)},_getDatasetOptions:function(){if(this.inputLayers)return this._inputLayerStore=new E(new D({data:this.inputLayers}))},_destroyInputWidgets:function(){h.forEach(this._inputWidgets,function(a){if(a&&a.destroy)try{a.destroy()}catch(b){console.log(b)}});this._inputWidgets=[]},_getWidget:function(a,b,c,d){if(a){var f=a.value,e,g=c&&c.dataType,h=c&&c.domain,k=c&&c.dataTypeAttributes;!a.isDataset||f&&f.arguments||(f&&
f.type&&"scalar"===f.type.toLowerCase()?e=new y({value:f.value},b):(e=new v({store:this._getDatasetOptions(),labelAttr:"name"},b),x.isDefined(f)&&this._selectInputDataset(e,f)));e||(!h&&!k||h&&"fields"===h.type?e=this._getDataTypeBasedWidget(g,a,b):h?e=this._getDomainBasedWidget(h,a,d,b):k&&(e=this._getDataTypeAttributeBasedWidget(g,k,a,d,b)));if(e)e.on("change",m.partial(m.hitch(this,this._onArgumentValueChange),a,c,d));return e}},_getDataTypeBasedWidget:function(a,b,c){var d=b.value;switch(a){case k.rasterArray:a=
new L({inputLayers:this.inputLayers},c);break;case "undefined":case k.string:a=new u({value:d},c);break;case k["double"]:a=new y({value:d},c);break;case k["long"]:a=new y({constraints:{places:0},value:d},c);break;case k.colorRamp:a=new N({style:"text-indent: 0; height: 2.2em;",maxHeight:200,includeDefault:!1},c);this._setColorRampValue(a,b);break;case k["boolean"]:a=new I({checked:d},c);break;case k.stringArray:case k.doubleArray:case k.longArray:d&&d.length&&(d=d.join(","));a=new u({value:d},c);
break;case k.rasterStatisticsArray:case k.arrayOfRasterStatistics:a=new M({value:d},c);break;case k.cellSize:a=new u({},c);try{a.set("value",w.stringify(d))}catch(f){a.set("value",d)}break;default:a=new u({value:d},c)}return a},_getDomainBasedWidget:function(a,b,c,d){if(a&&b){var f=a&&a.type,e=b.value,g;"numlist"===f?(a=new E(new D({idProperty:"key",data:this._getNumListData(a)})),g=new v({store:a,labelAttr:"key"},d),x.isDefined(e)&&g.set("value",e.toString())):"list"===f?(a=this._getEnumData(F[a["enum"]]),
a=new E(new D({idProperty:"key",data:a})),g=new v({store:a,labelAttr:"label",maxHeight:200},d),x.isDefined(e)&&g.set("value",e.toString())):"range"===f?g=new J({min:a.min,max:a.max,label:b.name,value:e},d):"bandIndex"===f&&(a=this._getCaseInsenstitiveArg(a.argumentName,c),g=new X({nBandsArg:a,value:e},d));return g}},_getDataTypeAttributeBasedWidget:function(a,b,c,d,f){var e;"bandmatrix"===b.type&&(a=this._getCaseInsenstitiveArg(b.nBands,d),e=new K({nBandsArg:a,nCols:b.cols,displayNames:b.displayNames,
value:c.value},f));return e},_getNumListData:function(a){if(a){for(var b=[],c=a.start,d=0;d<a.count;c+=a.inc,d++)b.push({key:c.toString()});return b}},_getEnumData:function(a){h.forEach(a,function(a){a.key=a.key.toString()});return a},_onArgumentValueChange:function(a,b,c,d){(a&&a.input)instanceof v&&b&&b.dataType===k["long"]&&(d=parseInt(d,10));this._handleEditorStateTriggers(c,d,b)},_handleEditorStateTriggers:function(a,b,c){c&&c.editorStateTrigger&&c.editorStateTrigger.active&&a&&h.forEach(c.editorStateTrigger.triggers,
function(d){var c,e,g,k,l=d.autoRevert,n,m;for(m in a)if(a.hasOwnProperty(m)&&(c=a[m],k=c.uxBlocks)){c=0<=h.indexOf(d.values,b);e=this._containsArgName(d.active,m);g=this._containsArgName(d.inactive,m);if(e&&c||g&&!c&&l)n=k&&k[0]&&"TR"===k[0].tagName?"table-row":"block";if(g&&c||e&&!c&&l)n="none";h.forEach(k,function(a){a&&n&&P.set(a,"display",n)});n=null}},this)},_containsArgName:function(a,b){if(!a||!b)return!1;var c=b.toLowerCase();return h.some(a,function(a){return a.toLowerCase()===c})},_getArgumentValue:function(a,
b){function c(a){return h.some(a,function(a){if(e instanceof a)return!0})}if(a&&b){var d=Object.keys(a)[0];if(d&&a[d]){a=a[d];var f,e=a.input,g;g=p&&p[b.type];var l,d=(d=this._getCaseInsenstitiveArg(d,g&&g.rasterFunctionArguments))&&d.dataType;if(!e)return a.value;g=[y,v,u];l=[I];var m=[J,K,L,M],n=[N];if(a.isDataset){if(a.value&&a.value.type&&"scalar"===a.value.type.toLowerCase())return e.value;d=this._inputLayerStore.get(e.value);return z.getRasterJsonFromLayer(d)}if(c(n))return z.getRFxArgColorRampValue(e.colorRamp);
if(c(m))return e.value;if(c(g))switch(g=e.value,d&&0<=d.indexOf("array")&&g&&"string"===typeof g&&(f=0<=g.indexOf(",")?g.split(","):g.split(" ")),d){case k.longArray:return h.forEach(f,function(a,b){f[b]=parseInt(a,10)}),f;case k.doubleArray:return h.forEach(f,function(a,b){f[b]=parseFloat(a)}),f;case k.stringArray:case k.rasterArray:return h.forEach(f,function(a,b){f[b]=a.trim()}),f;case k["long"]:return parseInt(g,10);case k.cellSize:try{return w.parse(g)}catch(aa){}return g;case void 0:return g=
g&&g.trim(),d=/^[+-]?(\d+)?(\.\d+)?$/.test(g),l=0<=h.indexOf(["true","false"],g),d?parseFloat(g):l?"true"===g:g;default:return g}else if(c(l))return e.checked}}},_getCaseInsenstitiveArg:function(a,b){if(a&&b)return h.some(Object.keys(b),function(b){if(b.toLowerCase()===a.toLowerCase())return a=b,!0}),b[a]},_selectInputDataset:function(a,b){if(a&&a.options.length&&b){var c=b,d=null;"object"===typeof b&&(c=b.url,d=b.name);var f=x.isDefined(d);h.forEach(a.options,function(a){a.selected=a.item.url===
c&&(!f||f&&d===a.item.name)},this)}},_setColorRampValue:function(a,b){var c=z.getColorRampFromArg(b);a&&c&&!a.setSelected(c)&&(a.addColorRamp(c),a.setSelected(c))}});O("extend-esri")&&m.setObject("dijit.RasterFunctionEditor.RFxArgsEditor",C,Q);return C});