﻿
function createMapLoad(idv_ID,extent,mapdata,onLoad) {
    //四至
    var initExtent = new esri.geometry.Extent(extent);
    //map容器
    var map = new esri.Map(idv_ID, {
        extent: esri.geometry.geographicToWebMercator(initExtent),
        logo: false,
        maxZoom:20,//最大空间等级
        minZoom:14,//最小空间等级
    });
    // 绑定加载事件
    dojo.connect(map, "onLoad", function (x) {
        onLoad(map);
    });

    //底图
    //arcgis地图
    //var myTiledMapServiceLayer = new esri.layers.ArcGISTiledMapServiceLayer("https://58.213.133.181:7773/tilemap/ArcGIS/rest/services/NJSL201807/MapServer");

    for(var i=0;i<mapdata.length;i++){
        map.addLayer(new esri.layers.ArcGISTiledMapServiceLayer(mapdata[i].url));
    }
    //var myTiledMapServiceLayer = new esri.layers.ArcGISTiledMapServiceLayer(mapurl);
    //天地图地图
    // var layer = TDTLayer();
    //var layer_word = TDTWordLayer();
    //map.addLayer(layer);
    //map.addLayer(layer_word);
    //map.addLayer(myTiledMapServiceLayer);
}

//测量工具
var MeasureTool=function (map) {
    this.bolDraw=false;//用于和其他的toolbar功能区分开
    this.graphicslayer1 = new esri.layers.GraphicsLayer();
    map.addLayer(this.graphicslayer1);
    this.graphicslayer1.on('mouse-over', function (e) {
        map.setMapCursor("url(./img/pointer.cur),auto");
    });
    this.graphicslayer1.on('mouse-out', function (e) {
        map.setMapCursor("default");
    });
    this.graphicslayer1.on('click', function (e) {
        this.remove(e.graphic);
        e.graphic.attributes.layer.remove(e.graphic.attributes.arr[0]);
        e.graphic.attributes.layer.remove(e.graphic.attributes.arr[1]);
        e.graphic.attributes.layer.remove(e.graphic.attributes.arr[2]);
        map.setMapCursor("default");
    });
    this.graphicslayer2 = new esri.layers.GraphicsLayer();
    map.addLayer(this.graphicslayer2);
};

MeasureTool.prototype= {
    getLength: function (polyline) {
        var unitMeter=false;
        var length = 0;
        for (var i = 0, ii = polyline.paths.length; i < ii; i++) {
            length += this.getLength_(polyline.paths[i]);
        }
        //大于100米使用公里
        if(length>100){
            unitMeter=true;
            length=(length)/1000;
        }
        length=length.toFixed(1);
        //绘画的图形
        var symbol_measure = new esri.symbol.SimpleLineSymbol(
            esri.symbol.SimpleLineSymbol.STYLE_SOLID,
            new dojo.Color([255, 0, 0]),
            2
        );
        //×图片
        var symbol_click = new esri.symbol.PictureMarkerSymbol("./img/measure_click.png", 15, 15);
        //文字
        var textSymbol = new esri.symbol.TextSymbol('总长:'+length+(unitMeter?'公里':'米')).setColor(
            new esri.Color([0, 0, 0])).setAlign(esri.symbol.Font.ALIGN_START).setAngle(0).setFont(
            new esri.symbol.Font("8pt")).setOffset(43,18);
        //面板图片
        var blankSymbol = new esri.symbol.PictureMarkerSymbol("./img/measure_blank.png", 90, 22 ).setOffset(43,20);

        var graphic_measure = new esri.Graphic(polyline, symbol_measure);
        var graphic_text = new esri.Graphic(new esri.geometry.Point(polyline.paths[0][polyline.paths[0].length-1][0],polyline.paths[0][polyline.paths[0].length-1][1]), textSymbol);
        var graphic_blank = new esri.Graphic(new esri.geometry.Point(polyline.paths[0][polyline.paths[0].length-1][0],polyline.paths[0][polyline.paths[0].length-1][1]), blankSymbol);

        var attribute={arr:[graphic_measure,graphic_text,graphic_blank],layer:this.graphicslayer2};
        var graphic_click = new esri.Graphic(new esri.geometry.Point(polyline.paths[0][polyline.paths[0].length-1][0],polyline.paths[0][polyline.paths[0].length-1][1]), symbol_click,attribute);
        this.graphicslayer1.add(graphic_click);
        this.graphicslayer2.add(graphic_measure);  // 将绘图加入到图层中
        this.graphicslayer2.add(graphic_blank);
        this.graphicslayer2.add(graphic_text);

    },
    getArea: function (polygon) {
        var area = 0, len = polygon.rings[0].length, radius = 6371008.8;
        var x1 = polygon.rings[0][len - 1][0];
        var y1 = polygon.rings[0][len - 1][1];
        for (var i = 0; i < len; i++) {
            var x2 = polygon.rings[0][i][0], y2 = polygon.rings[0][i][1];
            area += this.toRadians(x2 - x1) * (2 + Math.sin(this.toRadians(y1)) + Math.sin(this.toRadians(y2)));
            x1 = x2;
            y1 = y2;
        }
        area= (area * radius * radius / 2.0)/1000000;
        area=area.toFixed(1);
        var symbol_measure = new esri.symbol.SimpleFillSymbol(
            esri.symbol.SimpleFillSymbol.STYLE_SOLID,
            new esri.symbol.SimpleLineSymbol(
                esri.symbol.SimpleLineSymbol.STYLE_SOLID,
                new dojo.Color([255, 0, 0]),
                2
            ),
            new dojo.Color([255, 0, 0, 0.05])
        );
        //×图片
        var symbol_click = new esri.symbol.PictureMarkerSymbol("./img/measure_click.png", 15, 15);
        //文字
        var textSymbol = new esri.symbol.TextSymbol('面积:'+area+'平方公里').setColor(
            new esri.Color([0, 0, 0])).setAlign(esri.symbol.Font.ALIGN_START).setAngle(0).setFont(
            new esri.symbol.Font("8pt")).setOffset(43,18);
        //面板图片
        var blankSymbol = new esri.symbol.PictureMarkerSymbol("./img/measure_blank.png", 110, 22 ).setOffset(43,20);

        var graphic_measure = new esri.Graphic(polygon, symbol_measure);
        var graphic_text = new esri.Graphic(new esri.geometry.Point(polygon.rings[0][polygon.rings[0].length-1][0],polygon.rings[0][polygon.rings[0].length-1][1]), textSymbol);
        var graphic_blank = new esri.Graphic(new esri.geometry.Point(polygon.rings[0][polygon.rings[0].length-1][0],polygon.rings[0][polygon.rings[0].length-1][1]), blankSymbol);

        var attribute={arr:[graphic_measure,graphic_text,graphic_blank],layer:this.graphicslayer2};
        var graphic_click = new esri.Graphic(new esri.geometry.Point(polygon.rings[0][polygon.rings[0].length-1][0],polygon.rings[0][polygon.rings[0].length-1][1]), symbol_click,attribute);
        this.graphicslayer1.add(graphic_click);
        this.graphicslayer2.add(graphic_measure);  // 将绘图加入到图层中
        this.graphicslayer2.add(graphic_blank);
        this.graphicslayer2.add(graphic_text);
    },
    getLength_: function (ring) {
        var length = 0;
        for (i = 0, ii = ring.length; i < ii - 1; ++i) {
            length += this.getDistance_(ring[i], ring[i + 1]);
        }
        return length;
    },
    getDistance_: function (c1, c2) {
        var radius = 6371008.8;
        var lat1 = this.toRadians(c1[1]);
        var lat2 = this.toRadians(c2[1]);
        var deltaLatBy2 = (lat2 - lat1) / 2;
        var deltaLonBy2 = this.toRadians(c2[0] - c1[0]) / 2;
        var a = Math.sin(deltaLatBy2) * Math.sin(deltaLatBy2) + Math.sin(deltaLonBy2) * Math.sin(deltaLonBy2) * Math.cos(lat1) * Math.cos(lat2);
        return 2 * radius * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
    },
    toRadians: function (angleInDegrees) {
        return angleInDegrees * Math.PI / 180;
    }
};
